/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.BetaFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BetaFilteredYoVariableTest {
    private final Random rng = new Random();

    @Test
    public void testBetaFilteredYoVariable() {
        int beta = 5000;
        double pseudoNoise = 0.0;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        BetaFilteredYoVariable betaFilteredYoVariable = new BetaFilteredYoVariable("betaFilteredYoVariable", registry, beta, positionVariable);
        positionVariable.set(10.0);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                pseudoNoise = this.rng.nextDouble();
            }
            positionVariable.add(Math.pow(-1.0, i) * pseudoNoise);
            betaFilteredYoVariable.update();
        }
        Assert.assertEquals(10.0, betaFilteredYoVariable.getDoubleValue(), 1.0);
    }
}

