/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.AlphaFusedYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFusedYoVariableTest {
    private final Random rng = new Random();

    @Test
    public void testAlphaFusedYoVariable() {
        double alpha = 0.3;
        double slowSignalNoise = 0.0;
        double fastSignalNoise = 0.0;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble slowSignal = new YoDouble("slowFrequency", registry);
        YoDouble fastSignal = new YoDouble("fastFrequency", registry);
        slowSignal.set(10.0);
        fastSignal.set(10.0);
        AlphaFusedYoVariable alphaFusedVariable = new AlphaFusedYoVariable("alphaFusedVariable", registry, alpha, slowSignal, fastSignal);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                fastSignalNoise = this.rng.nextDouble();
            }
            fastSignal.add(Math.pow(-1.0, i) * fastSignalNoise);
            if (i % 50 == 0) {
                slowSignalNoise = this.rng.nextDouble();
                slowSignal.add(slowSignalNoise);
            }
            if ((i - 1) % 50 == 0) {
                slowSignal.add(-slowSignalNoise);
            }
            alphaFusedVariable.update();
        }
        Assert.assertEquals(10.0, alphaFusedVariable.getDoubleValue(), 1.0);
    }
}

