/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector2d;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AlphaFilteredYoFrameVector2dTest {
    private static final double EPSILON = 1.0E-15;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConsistencyWithAlphaFilteredYoVariable() {
        Random random = new Random(3453456L);
        for (int i = 0; i < 100; ++i) {
            double alpha = random.nextDouble();
            YoRegistry registry = new YoRegistry("blop");
            AlphaFilteredYoFrameVector2d filteredVector = new AlphaFilteredYoFrameVector2d("tested", "", registry, alpha, ReferenceFrame.getWorldFrame());
            AlphaFilteredYoVariable xFiltered = new AlphaFilteredYoVariable("xRef", registry, alpha);
            AlphaFilteredYoVariable yFiltered = new AlphaFilteredYoVariable("yRef", registry, alpha);
            Vector2D unfilteredVector = new Vector2D();
            for (int j = 0; j < 10; ++j) {
                unfilteredVector.add((Tuple2DReadOnly)EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.0, (double)0.5));
                filteredVector.update((Tuple2DReadOnly)unfilteredVector);
                xFiltered.update(unfilteredVector.getX());
                yFiltered.update(unfilteredVector.getY());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector2D(xFiltered.getValue(), yFiltered.getValue()), (EuclidGeometry)filteredVector, (double)1.0E-15);
            }
        }
    }
}

