/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Tuple3DBasicsTest;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.filters.AlphaFilteredTuple3D;

public class AlphaFilteredTuple3DTest
extends Tuple3DBasicsTest<AlphaFilteredTuple3D> {
    @Test
    public void testFirstSet() {
        AlphaFilteredTuple3D tuple = new AlphaFilteredTuple3D(0.0);
        tuple.set(0.0, 1.0, 2.0);
        Assertions.assertEquals((double)0.0, (double)tuple.getX(), (double)this.getEpsilon());
        Assertions.assertEquals((double)1.0, (double)tuple.getY(), (double)this.getEpsilon());
        Assertions.assertEquals((double)2.0, (double)tuple.getZ(), (double)this.getEpsilon());
    }

    @Test
    public void testFilteredSetters() {
        Random random = new Random(12951L);
        for (int i = 0; i < 1000; ++i) {
            double alpha = random.nextDouble(0.0, 1.0);
            AlphaFilteredTuple3D tuple = this.createRandomTuple(random);
            tuple.setAlpha(alpha);
            double originalX = tuple.getX();
            double originalY = tuple.getY();
            double originalZ = tuple.getZ();
            Point3D point = new Point3D((Tuple3DReadOnly)this.createRandomTuple(random));
            tuple.setX(point.getX());
            tuple.setY(point.getY());
            tuple.setZ(point.getZ());
            double expectedX = (1.0 - alpha) * point.getX() + alpha * originalX;
            double expectedY = (1.0 - alpha) * point.getY() + alpha * originalY;
            double expectedZ = (1.0 - alpha) * point.getZ() + alpha * originalZ;
            Assertions.assertEquals((double)expectedX, (double)tuple.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedY, (double)tuple.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple.getZ(), (double)this.getEpsilon());
        }
    }

    @Test
    public void testSetOther() {
        Random random = new Random(621541L);
        for (int i = 0; i < 1000; ++i) {
            double alpha = random.nextDouble(0.0, 1.0);
            AlphaFilteredTuple3D tuple = this.createRandomTuple(random);
            tuple.setAlpha(alpha);
            double originalX = tuple.getX();
            double originalY = tuple.getY();
            double originalZ = tuple.getZ();
            Point3D point = new Point3D((Tuple3DReadOnly)this.createRandomTuple(random));
            tuple.set((Tuple3DBasics)point);
            double expectedX = (1.0 - alpha) * point.getX() + alpha * originalX;
            double expectedY = (1.0 - alpha) * point.getY() + alpha * originalY;
            double expectedZ = (1.0 - alpha) * point.getZ() + alpha * originalZ;
            Assertions.assertEquals((double)expectedX, (double)tuple.getX(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedY, (double)tuple.getY(), (double)this.getEpsilon());
            Assertions.assertEquals((double)expectedZ, (double)tuple.getZ(), (double)this.getEpsilon());
        }
    }

    public AlphaFilteredTuple3D createEmptyTuple() {
        return new AlphaFilteredTuple3D(0.0);
    }

    public AlphaFilteredTuple3D createTuple(double v, double v1, double v2) {
        return new AlphaFilteredTuple3D(v, v1, v2, 0.0);
    }

    public AlphaFilteredTuple3D createRandomTuple(Random random) {
        return new AlphaFilteredTuple3D(random.nextDouble(), random.nextDouble(), random.nextDouble(), 0.0);
    }

    public double getEpsilon() {
        return 1.0E-7;
    }
}

