/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.YoSignalDerivative;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoSignalDerivativeTest {
    private static double epsilon = 1.0E-10;
    private YoSignalDerivative yoSignalDerivative;

    @BeforeEach
    public void setUp() throws Exception {
        YoRegistry registry = new YoRegistry("testRegistry");
        this.yoSignalDerivative = new YoSignalDerivative("test", registry);
    }

    @Test
    public void checkConstructor() {
        String name = this.yoSignalDerivative.getName();
        Assert.assertEquals("test", name);
    }

    @Test
    public void checkSetDifferentiationMode() {
        this.yoSignalDerivative.setDifferentiationMode(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE);
        YoSignalDerivative.DifferentiationMode differentiationMode = this.yoSignalDerivative.getDifferentiationMode();
        Assert.assertEquals(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, differentiationMode);
        this.yoSignalDerivative.setDifferentiationMode(YoSignalDerivative.DifferentiationMode.USING_DT);
        YoSignalDerivative.DifferentiationMode differentiationMode2 = this.yoSignalDerivative.getDifferentiationMode();
        Assert.assertEquals(YoSignalDerivative.DifferentiationMode.USING_DT, differentiationMode2);
    }

    @Test
    public void checkDTMode() {
        this.yoSignalDerivative.initialize(YoSignalDerivative.DifferentiationMode.USING_DT, 0.5, 0.0, 0.0);
        YoSignalDerivative.DifferentiationMode differentiationMode = this.yoSignalDerivative.getDifferentiationMode();
        Assert.assertEquals(YoSignalDerivative.DifferentiationMode.USING_DT, differentiationMode);
        double derivative = this.yoSignalDerivative.getDerivative(1.0, 0.5);
        Assert.assertEquals(1.0, derivative, epsilon);
        double derivative2 = this.yoSignalDerivative.getDerivative(0.5, 1.0);
        Assert.assertEquals(-1.0, derivative2, epsilon);
        double derivative3 = this.yoSignalDerivative.getDerivative(4.0, 2.0);
        Assert.assertEquals(3.5, derivative3, epsilon);
        double derivative4 = this.yoSignalDerivative.getDerivative(4.0, 3.0);
        Assert.assertEquals(0.0, derivative4, epsilon);
    }

    @Test
    public void checkSignalChangeModeWithDefaultTolerance() {
        this.yoSignalDerivative.initialize(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, 0.0, 0.1, 4.0);
        YoSignalDerivative.DifferentiationMode differentiationMode = this.yoSignalDerivative.getDifferentiationMode();
        Assert.assertEquals(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, differentiationMode);
        double derivative = this.yoSignalDerivative.getDerivative(0.0, 0.25);
        Assert.assertEquals(4.0, derivative, epsilon);
        double derivative2 = this.yoSignalDerivative.getDerivative(1.0, 0.5);
        Assert.assertEquals(2.5, derivative2, epsilon);
        double derivative3 = this.yoSignalDerivative.getDerivative(0.5, 1.0);
        Assert.assertEquals(-1.0, derivative3, epsilon);
        double derivative4 = this.yoSignalDerivative.getDerivative(4.0, 2.0);
        Assert.assertEquals(3.5, derivative4, epsilon);
        double derivative5 = this.yoSignalDerivative.getDerivative(4.0, 3.0);
        Assert.assertEquals(3.5, derivative5, epsilon);
    }

    @Test
    public void checkSignalChangeModeWithUserTolerance() {
        this.yoSignalDerivative.initialize(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, 0.1, 0.0, 0.0, 0.0);
        YoSignalDerivative.DifferentiationMode differentiationMode = this.yoSignalDerivative.getDifferentiationMode();
        Assert.assertEquals(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, differentiationMode);
        double derivative = this.yoSignalDerivative.getDerivative(1.0, 0.5);
        Assert.assertEquals(2.0, derivative, epsilon);
        double derivative2 = this.yoSignalDerivative.getDerivative(0.5, 1.0);
        Assert.assertEquals(-1.0, derivative2, epsilon);
        double derivative3 = this.yoSignalDerivative.getDerivative(4.0, 2.0);
        Assert.assertEquals(3.5, derivative3, epsilon);
        double derivative4 = this.yoSignalDerivative.getDerivative(4.0, 3.0);
        Assert.assertEquals(3.5, derivative4, epsilon);
        double derivative5 = this.yoSignalDerivative.getDerivative(4.09, 4.0);
        Assert.assertEquals(3.5, derivative5, epsilon);
        double derivative6 = this.yoSignalDerivative.getDerivative(4.108, 5.0);
        Assert.assertEquals(0.036, derivative6, epsilon);
    }

    @Test
    public void checkResetToZero() {
        this.yoSignalDerivative.initialize(YoSignalDerivative.DifferentiationMode.ON_SIGNAL_CHANGE, 1.0, 0.5, 3.0);
        this.yoSignalDerivative.resetToZero();
        double derivative = this.yoSignalDerivative.getDerivative(1.5, 1.0);
        Assert.assertEquals(1.5, derivative, epsilon);
    }
}

