/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.TimestampedVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class TimestampedVelocityYoVariableTest {
    private YoDouble position;
    private YoDouble timestamp;
    private TimestampedVelocityYoVariable velocityYoVariable;

    @BeforeEach
    public void setUp() throws Exception {
        YoRegistry registry = new YoRegistry("testRegistry");
        this.position = new YoDouble("testPosition", registry);
        this.timestamp = new YoDouble("testTimestamp", registry);
        this.velocityYoVariable = new TimestampedVelocityYoVariable("testVelVar", "", this.position, this.timestamp, registry, 1.0E-9);
    }

    @Test
    public void testHasNotBeenUpdated() {
        double val = this.velocityYoVariable.getDoubleValue();
        Assert.assertEquals(0.0, val, 0.0);
    }

    @Test
    public void testHasBeenUpdatedOnce() {
        this.position.set(1.0);
        this.timestamp.set(2.0);
        this.velocityYoVariable.update();
        double val = this.velocityYoVariable.getDoubleValue();
        Assert.assertEquals(0.0, val, 0.0);
    }

    @Test
    public void testHasBeenUpdatedTwice() {
        this.velocityYoVariable.update();
        this.position.set(1.0);
        this.timestamp.set(2.0);
        this.velocityYoVariable.update();
        double val = this.velocityYoVariable.getDoubleValue();
        Assert.assertEquals(this.position.getDoubleValue() / this.timestamp.getDoubleValue(), val, 0.0);
    }

    @Test
    public void testHasBeenUpdatedThreeTimes() {
        this.velocityYoVariable.update();
        this.position.set(1.0);
        this.timestamp.set(2.0);
        this.velocityYoVariable.update();
        this.position.set(2.0);
        this.timestamp.set(3.0);
        this.velocityYoVariable.update();
        double val = this.velocityYoVariable.getDoubleValue();
        Assert.assertEquals(1.0, val, 0.0);
    }

    @Test
    public void testHasBeenUpdatedThreeTimesNoChange() {
        this.velocityYoVariable.update();
        this.position.set(1.0);
        this.timestamp.set(2.0);
        this.velocityYoVariable.update();
        this.timestamp.set(4.0);
        this.velocityYoVariable.update();
        double val = this.velocityYoVariable.getDoubleValue();
        Assert.assertEquals(0.5, val, 0.0);
    }
}

