/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.math.QuaternionCalculus;
import us.ihmc.robotics.math.trajectories.SimpleOrientationTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class QuaternionCalculusTest {
    private static final double EPSILON = 1.0E-10;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testLogAndExpAlgebra() throws Exception {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Vector4D qLog = new Vector4D();
            Quaternion vExp = new Quaternion();
            quaternionCalculus.log((QuaternionReadOnly)q, (Vector4DBasics)qLog);
            Vector3D v = new Vector3D(qLog.getX(), qLog.getY(), qLog.getZ());
            quaternionCalculus.exp((Vector3DReadOnly)v, (QuaternionBasics)vExp);
            Assertions.assertTrue((Math.abs(q.getX() - vExp.getX()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getY() - vExp.getY()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getZ() - vExp.getZ()) < 1.0E-9 ? 1 : 0) != 0);
            Assertions.assertTrue((Math.abs(q.getS() - vExp.getS()) < 1.0E-9 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConversionQDotToAngularVelocityBackAndForth() throws Exception {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double length = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3D expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                expectedAngularVelocity.negate();
            }
            Vector3D actualAngularVelocity = new Vector3D();
            Vector4D qDot = new Vector4D();
            quaternionCalculus.computeQDotInWorldFrame((QuaternionReadOnly)q, (Vector3DReadOnly)expectedAngularVelocity, (Vector4DBasics)qDot);
            quaternionCalculus.computeAngularVelocityInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-10);
        }
    }

    @Test
    public void testConversionQDDotToAngularAccelerationBackAndForth() throws Exception {
        Random random = new Random(651651961L);
        for (int i = 0; i < 10000; ++i) {
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            Quaternion q = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double length = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                angularVelocity.negate();
            }
            Vector3D expectedAngularAcceleration = EuclidCoreRandomTools.nextVector3D((Random)random, (double)length);
            if (random.nextBoolean()) {
                expectedAngularAcceleration.negate();
            }
            Vector3D actualAngularAcceleration = new Vector3D();
            Vector4D qDot = new Vector4D();
            Vector4D qDDot = new Vector4D();
            quaternionCalculus.computeQDotInWorldFrame((QuaternionReadOnly)q, (Vector3DReadOnly)angularVelocity, (Vector4DBasics)qDot);
            quaternionCalculus.computeQDDotInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)expectedAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInWorldFrame((QuaternionReadOnly)q, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)actualAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)angularVelocity, (Vector3DReadOnly)actualAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
            quaternionCalculus.computeQDDotInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DReadOnly)expectedAngularAcceleration, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAccelerationInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDDot, (Vector3DReadOnly)angularVelocity, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-10);
        }
    }

    @Test
    public void testVelocityFromFDAgainstTrajectory() throws Exception {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        SimpleOrientationTrajectoryGenerator traj = new SimpleOrientationTrajectoryGenerator("traj", ReferenceFrame.getWorldFrame(), new YoRegistry("null"));
        double trajectoryTime = 1.0;
        traj.setTrajectoryTime(trajectoryTime);
        Random random = new Random(65265L);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        traj.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        traj.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        traj.initialize();
        double dt = 1.0E-4;
        double dtForFD = 1.0E-6;
        FrameQuaternion orientation = new FrameQuaternion();
        FrameVector3D expectedAngularVelocity = new FrameVector3D();
        Quaternion q = new Quaternion();
        Vector4D qDot = new Vector4D();
        Quaternion qPrevious = new Quaternion();
        Quaternion qNext = new Quaternion();
        Vector3D actualAngularVelocity = new Vector3D();
        for (double time = dt; time <= trajectoryTime - dt; time += dt) {
            traj.compute(time);
            expectedAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)traj.getAngularVelocity());
            q.set((QuaternionReadOnly)traj.getOrientation());
            traj.compute(time - dtForFD);
            qPrevious.set((QuaternionReadOnly)traj.getOrientation());
            traj.compute(time + dtForFD);
            qNext.set((QuaternionReadOnly)traj.getOrientation());
            quaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qNext, dtForFD, (Vector4DBasics)qDot);
            quaternionCalculus.computeAngularVelocityInWorldFrame((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-8);
        }
    }

    @Test
    public void testFDSimpleCase() throws Exception {
        double dt;
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        Random random = new Random(65265L);
        double integrationTime = 1.0;
        double angleVelocity = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(Math.PI * 2)) / integrationTime;
        Vector3D expectedAngularVelocity = new Vector3D(angleVelocity, 0.0, 0.0);
        Vector3D expectedAngularAcceleration = new Vector3D();
        AxisAngle axisAnglePrevious = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        AxisAngle axisAngleCurrent = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        AxisAngle axisAngleNext = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        Quaternion qPrevious = new Quaternion();
        Quaternion qCurrent = new Quaternion();
        Quaternion qNext = new Quaternion();
        Vector4D qDot = new Vector4D();
        Vector4D qDDot = new Vector4D();
        Vector3D actualAngularVelocity = new Vector3D();
        Vector3D actualAngularAcceleration = new Vector3D();
        for (double time = dt = 1.0E-4; time < integrationTime; time += dt) {
            axisAnglePrevious.setAngle(AngleTools.trimAngleMinusPiToPi((double)(angleVelocity * (time - dt))) - Math.PI);
            qPrevious.set((Orientation3DReadOnly)axisAnglePrevious);
            axisAngleCurrent.setAngle(AngleTools.trimAngleMinusPiToPi((double)(angleVelocity * time)) - Math.PI);
            qCurrent.set((Orientation3DReadOnly)axisAngleCurrent);
            axisAngleNext.setAngle(AngleTools.trimAngleMinusPiToPi((double)(angleVelocity * (time + dt))) - Math.PI);
            qNext.set((Orientation3DReadOnly)axisAngleNext);
            quaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qNext, dt, (Vector4DBasics)qDot);
            quaternionCalculus.computeAngularVelocityInWorldFrame((QuaternionReadOnly)qCurrent, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
            quaternionCalculus.computeQDDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qCurrent, (QuaternionReadOnly)qNext, dt, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAcceleration((QuaternionReadOnly)qCurrent, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            boolean sameVelocity = expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, 1.0E-7);
            if (!sameVelocity) {
                System.out.println("Expected angular velocity: " + expectedAngularVelocity);
                System.out.println("Actual   angular velocity: " + actualAngularVelocity);
            }
            Assertions.assertTrue((boolean)sameVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-7);
        }
    }

    @Test
    public void testAccelerationFromFDAgainstTrajectory() throws Exception {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        SimpleOrientationTrajectoryGenerator traj = new SimpleOrientationTrajectoryGenerator("traj", ReferenceFrame.getWorldFrame(), new YoRegistry("null"));
        double trajectoryTime = 1.0;
        traj.setTrajectoryTime(trajectoryTime);
        Random random = new Random(65265L);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        traj.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        traj.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        traj.initialize();
        double dt = 1.0E-4;
        double dtForFD = 1.0E-4;
        FrameQuaternion orientation = new FrameQuaternion();
        FrameVector3D expectedAngularAcceleration = new FrameVector3D();
        Quaternion q = new Quaternion();
        Vector4D qDot = new Vector4D();
        Vector4D qDDot = new Vector4D();
        Quaternion qPrevious = new Quaternion();
        Quaternion qNext = new Quaternion();
        Vector3D actualAngularAcceleration = new Vector3D();
        for (double time = dt; time <= trajectoryTime - dt; time += dt) {
            traj.compute(time);
            expectedAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)traj.getAngularAcceleration());
            q.set((QuaternionReadOnly)traj.getOrientation());
            traj.compute(time - dtForFD);
            qPrevious.set((QuaternionReadOnly)traj.getOrientation());
            traj.compute(time + dtForFD);
            qNext.set((QuaternionReadOnly)traj.getOrientation());
            quaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)qNext, dtForFD, (Vector4DBasics)qDot);
            quaternionCalculus.computeQDDotByFiniteDifferenceCentral((QuaternionReadOnly)qPrevious, (QuaternionReadOnly)q, (QuaternionReadOnly)qNext, dtForFD, (Vector4DBasics)qDDot);
            quaternionCalculus.computeAngularAcceleration((QuaternionReadOnly)q, (Vector4DReadOnly)qDot, (Vector4DReadOnly)qDDot, (Vector3DBasics)actualAngularAcceleration);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularAcceleration, (EuclidGeometry)actualAngularAcceleration, (double)1.0E-5);
        }
    }

    @Test
    public void testInterpolateAgainstQuat4d() throws Exception {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        Random random = new Random(6546545L);
        Quaternion q0 = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion q1 = EuclidCoreRandomTools.nextQuaternion((Random)random);
        Quaternion expectedQInterpolated = new Quaternion();
        Quaternion actualQInterpolated = new Quaternion();
        for (double alpha = 0.0; alpha <= 1.0; alpha += 1.0E-6) {
            expectedQInterpolated.interpolate((QuaternionReadOnly)q0, (QuaternionReadOnly)q1, alpha);
            quaternionCalculus.interpolate(alpha, (QuaternionReadOnly)q0, (QuaternionReadOnly)q1, (QuaternionBasics)actualQInterpolated);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedQInterpolated, (EuclidGeometry)actualQInterpolated, (double)1.0E-10);
        }
    }
}

