/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.math.FastFourierTransform;

public class FastFourierTransformTest {
    @Test
    public void testBitReverse() {
        FastFourierTransform fft = FastFourierTransform.getFourierTransformer();
        Assert.assertTrue(fft.bitReverse(0, 3) == 0);
        Assert.assertTrue(fft.bitReverse(1, 3) == 4);
        Assert.assertTrue(fft.bitReverse(2, 3) == 2);
        Assert.assertTrue(fft.bitReverse(3, 3) == 6);
        Assert.assertTrue(fft.bitReverse(4, 3) == 1);
        Assert.assertTrue(fft.bitReverse(5, 3) == 5);
        Assert.assertTrue(fft.bitReverse(6, 3) == 3);
        Assert.assertTrue(fft.bitReverse(7, 3) == 7);
    }

    @Test
    public void testFourierTransform() {
        int i;
        double[] testArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
        FastFourierTransform fft = new FastFourierTransform(8);
        fft.setCoefficients(testArray);
        ComplexNumber[] result = fft.getForwardTransform();
        fft.setCoefficients(result);
        result = fft.getInverseTransform();
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue(MathTools.epsilonCompare((double)result[i].real(), (double)1.0, (double)1.0E-9));
        }
        for (i = 5; i < result.length; ++i) {
            Assert.assertTrue(MathTools.epsilonCompare((double)result[i].real(), (double)0.0, (double)1.0E-9));
        }
    }

    @Test
    public void testFourierTransform2() {
        double[] testArray1 = new double[]{1.0, 1.0};
        double[] testArray2 = new double[]{1.0, 1.0, 1.0};
        FastFourierTransform fft = new FastFourierTransform(4);
        fft.setCoefficients(testArray1);
        ComplexNumber[] result1 = fft.getForwardTransform();
        ComplexNumber[] saveVals = new ComplexNumber[4];
        for (int i = 0; i < 4; ++i) {
            saveVals[i] = new ComplexNumber(result1[i]);
        }
        fft.setCoefficients(testArray2);
        ComplexNumber[] result2 = fft.getForwardTransform();
        for (int i = 0; i < result1.length; ++i) {
            saveVals[i].timesAndStore(result2[i]);
        }
        fft.setCoefficients(saveVals);
        result1 = fft.getInverseTransform();
        Assert.assertTrue(MathTools.epsilonCompare((double)result1[0].real(), (double)1.0, (double)1.0E-9));
        Assert.assertTrue(MathTools.epsilonCompare((double)result1[1].real(), (double)2.0, (double)1.0E-9));
        Assert.assertTrue(MathTools.epsilonCompare((double)result1[2].real(), (double)2.0, (double)1.0E-9));
        Assert.assertTrue(MathTools.epsilonCompare((double)result1[3].real(), (double)1.0, (double)1.0E-9));
    }
}

