/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.math.NumberUtils;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.lists.YoPreallocatedList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoPreallocatedListTest {
    @Test
    public void testConstructor() {
        YoPreallocatedList list = new YoPreallocatedList(YoDouble.class, "Test", 10, new YoRegistry("Test"));
        Assert.assertTrue(list.isEmpty());
        Assert.assertTrue(list.size() == 0);
        Assert.assertTrue(list.getLast() == null);
    }

    @Test
    public void testAddAndGet() {
        int i;
        YoDouble lastObject;
        int i2;
        YoPreallocatedList list = new YoPreallocatedList(YoDouble.class, "Test", 20, new YoRegistry("Test"));
        ArrayList<YoDouble> expectedList = new ArrayList<YoDouble>();
        int finalSize = 10;
        for (i2 = 0; i2 < finalSize; ++i2) {
            lastObject = (YoDouble)list.add();
            expectedList.add(lastObject);
        }
        Assert.assertFalse(list.isEmpty());
        Assert.assertTrue(list.size() == finalSize);
        for (i2 = 0; i2 < finalSize; ++i2) {
            Assert.assertTrue(list.get(i2) == expectedList.get(i2));
        }
        Assert.assertTrue(list.getLast() == expectedList.get(finalSize - 1));
        try {
            list.get(finalSize);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException i3) {
            // empty catch block
        }
        list.clear();
        expectedList.clear();
        Assert.assertTrue(list.getLast() == null);
        finalSize = 8;
        for (i = 0; i < finalSize; ++i) {
            lastObject = (YoDouble)list.add();
            expectedList.add(lastObject);
        }
        Assert.assertFalse(list.isEmpty());
        Assert.assertTrue(list.size() == finalSize);
        for (i = 0; i < finalSize; ++i) {
            Assert.assertTrue(list.get(i) == expectedList.get(i));
        }
        Assert.assertTrue(list.getLast() == expectedList.get(finalSize - 1));
        list.clear();
        expectedList.clear();
        Assert.assertTrue(list.getLast() == null);
        finalSize = 20;
        for (i = 0; i < finalSize; ++i) {
            lastObject = (YoDouble)list.add();
            expectedList.add(lastObject);
        }
        Assert.assertFalse(list.isEmpty());
        Assert.assertTrue(list.size() == finalSize);
        for (i = 0; i < finalSize; ++i) {
            Assert.assertTrue(list.get(i) == expectedList.get(i));
        }
        Assert.assertTrue(list.getLast() == expectedList.get(finalSize - 1));
    }

    @Test
    public void testRemove() {
        int i;
        YoPreallocatedList list = new YoPreallocatedList(YoInteger.class, "Test", 10, new YoRegistry("Test"));
        int currentSize = 10;
        while (list.size() < currentSize) {
            ((YoInteger)list.add()).set(10 + list.size());
        }
        ArrayList<YoInteger> expectedList = new ArrayList<YoInteger>();
        for (int i2 = 0; i2 < currentSize; ++i2) {
            expectedList.add((YoInteger)list.get(i2));
        }
        int indexOfRemovedObject = 3;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assert.assertTrue(list.size() == --currentSize);
        for (i = 0; i < currentSize; ++i) {
            Assert.assertTrue(list.get(i) == expectedList.get(i));
        }
        indexOfRemovedObject = currentSize - 1;
        list.remove(indexOfRemovedObject);
        expectedList.remove(indexOfRemovedObject);
        Assert.assertTrue(list.size() == --currentSize);
        for (i = 0; i < currentSize; ++i) {
            Assert.assertTrue(list.get(i) == expectedList.get(i));
        }
        try {
            list.remove(currentSize);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSwap() {
        Random rand = new Random(541964L);
        YoPreallocatedList list = new YoPreallocatedList(YoInteger.class, "Test", 10, new YoRegistry("Test"));
        int currentSize = 10;
        while (list.size() < currentSize) {
            ((YoInteger)list.add()).set(10 + list.size());
        }
        ArrayList<YoInteger> expectedList = new ArrayList<YoInteger>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add((YoInteger)list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int indexA = rand.nextInt(currentSize);
            int indexB = rand.nextInt(currentSize);
            list.swap(indexA, indexB);
            Collections.swap(expectedList, indexA, indexB);
            Assert.assertTrue(list.size() == currentSize);
            for (int i = 0; i < currentSize; ++i) {
                Assert.assertTrue(list.get(i) == expectedList.get(i));
            }
        }
        try {
            list.swap(0, currentSize);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.swap(currentSize, 0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSort() {
        YoPreallocatedList list = new YoPreallocatedList(YoInteger.class, "Test", 10, new YoRegistry("Test"));
        ((YoInteger)list.add()).set(-3);
        ((YoInteger)list.add()).set(20);
        ((YoInteger)list.add()).set(-10);
        ((YoInteger)list.add()).set(19);
        ((YoInteger)list.add()).set(50);
        list.sort((o1, o2) -> NumberUtils.compare((int)o1.getIntegerValue(), (int)o2.getIntegerValue()));
        Assert.assertTrue(((YoInteger)list.get(0)).getValue() == -10);
        Assert.assertTrue(((YoInteger)list.get(1)).getValue() == -3);
        Assert.assertTrue(((YoInteger)list.get(2)).getValue() == 19);
        Assert.assertTrue(((YoInteger)list.get(3)).getValue() == 20);
        Assert.assertTrue(((YoInteger)list.get(4)).getValue() == 50);
    }

    @Test
    public void testRemoveIndex() {
        int size = 10;
        YoPreallocatedList list = new YoPreallocatedList(YoInteger.class, "Test", size, new YoRegistry("Test"));
        for (int i = 0; i < size; ++i) {
            ((YoInteger)list.add()).set(i);
        }
        Assert.assertTrue(((YoInteger)list.remove(8)).getValue() == 8);
        Assert.assertTrue(list.size() == size - 1);
        Assert.assertTrue(((YoInteger)list.remove(4)).getValue() == 4);
        Assert.assertTrue(list.size() == size - 2);
        Assert.assertTrue(((YoInteger)list.remove(2)).getValue() == 2);
        Assert.assertTrue(list.size() == size - 3);
        Assert.assertTrue(((YoInteger)list.remove(size - 4)).getValue() == size - 1);
        Assert.assertTrue(list.size() == size - 4);
    }

    @Test
    public void testUnsupportedOperations() {
        int size = 5;
        YoRegistry testRegistry = new YoRegistry("Test");
        YoDouble testDouble = new YoDouble("Test", testRegistry);
        YoPreallocatedList list = new YoPreallocatedList(YoDouble.class, "Test", 10, testRegistry);
        for (int i = 0; i < size; ++i) {
            ((YoDouble)list.add()).set((double)i);
        }
        try {
            list.set(0, (Object)testDouble);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.add((Object)testDouble);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.add(0, (Object)testDouble);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.addAll(new HashSet());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.replaceAll(UnaryOperator.identity());
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.iterator();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.listIterator();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.listIterator(0);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            list.subList(0, 1);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

