/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class TransferFunctionMatrixTest {
    private TransferFunction simpleDecayOne;
    private TransferFunction secondOrderResponseOne;
    private TransferFunction simpleDecayTwo;
    private TransferFunction secondOrderResponseTwo;
    private TransferFunctionMatrix transferFunctionMatrix;

    @BeforeEach
    public void setUp() throws Exception {
        this.secondOrderResponseOne = TransferFunction.constructSecondOrderTransferFunction((double)1.0, (double)10.0, (double)0.3);
        this.simpleDecayOne = new TransferFunction(new double[]{1.0}, new double[]{1.0, -3.0});
        this.secondOrderResponseTwo = TransferFunction.constructSecondOrderTransferFunction((double)2.0, (double)20.0, (double)2.0);
        this.simpleDecayTwo = new TransferFunction(new double[]{1.0}, new double[]{1.0, -10.0});
        TransferFunction[][] transferFunctions = new TransferFunction[][]{{this.simpleDecayOne, this.secondOrderResponseOne}, {this.simpleDecayTwo, this.secondOrderResponseTwo}};
        this.transferFunctionMatrix = new TransferFunctionMatrix((TransferFunction[][])transferFunctions);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.simpleDecayOne = null;
        this.secondOrderResponseOne = null;
        this.simpleDecayTwo = null;
        this.secondOrderResponseTwo = null;
        this.transferFunctionMatrix = null;
    }

    @Test
    public void testGet() {
        this.verifyEpsilonEqual(this.simpleDecayOne, this.transferFunctionMatrix.get(0, 0), 1.0E-7);
    }

    private void verifyEpsilonEqual(TransferFunction expectedTransferFunction, TransferFunction actualTransferFunction, double epsilon) {
        this.verifyEpsilonEqual(expectedTransferFunction.getNumeratorCoefficients(), actualTransferFunction.getNumeratorCoefficients(), epsilon);
        this.verifyEpsilonEqual(expectedTransferFunction.getDenominatorCoefficients(), actualTransferFunction.getDenominatorCoefficients(), epsilon);
    }

    private void verifyEpsilonEqual(double[] expected, double[] actual, double epsilon) {
        Assert.assertEquals(expected.length, actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals(expected[i], actual[i], epsilon);
        }
    }

    @Test
    public void testPremultiply() {
        Matrix matrixC = new Matrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        TransferFunctionMatrix newTransferFunctionMatrix = this.transferFunctionMatrix.preMultiply(matrixC);
        Assert.assertTrue(newTransferFunctionMatrix.epsilonEquals(this.transferFunctionMatrix, 1.0E-7));
        matrixC = new Matrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 0.0}});
        newTransferFunctionMatrix = this.transferFunctionMatrix.preMultiply(matrixC);
        TransferFunction[][] transferFunctions = new TransferFunction[][]{{this.simpleDecayOne, this.secondOrderResponseOne}, {TransferFunction.constructZeroTransferFunction(), TransferFunction.constructZeroTransferFunction()}};
        this.transferFunctionMatrix = new TransferFunctionMatrix((TransferFunction[][])transferFunctions);
        Assert.assertTrue(newTransferFunctionMatrix.epsilonEquals(this.transferFunctionMatrix, 1.0E-7));
    }

    @Test
    public void testPreMultiplyException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            int rows = this.transferFunctionMatrix.getRows();
            int columns = this.transferFunctionMatrix.getColumns();
            Matrix testMatrix = Matrix.random((int)rows, (int)(columns - 1));
            this.transferFunctionMatrix.preMultiply(testMatrix);
        });
    }

    @Test
    public void testTimes() {
        Matrix matrixC = new Matrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        TransferFunctionMatrix newTransferFunctionMatrix = this.transferFunctionMatrix.times(matrixC);
        Assert.assertTrue(newTransferFunctionMatrix.epsilonEquals(this.transferFunctionMatrix, 1.0E-7));
        matrixC = new Matrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 0.0}});
        newTransferFunctionMatrix = this.transferFunctionMatrix.times(matrixC);
        TransferFunction[][] transferFunctions = new TransferFunction[][]{{this.simpleDecayOne, TransferFunction.constructZeroTransferFunction()}, {this.simpleDecayTwo, TransferFunction.constructZeroTransferFunction()}};
        this.transferFunctionMatrix = new TransferFunctionMatrix((TransferFunction[][])transferFunctions);
        Assert.assertTrue(newTransferFunctionMatrix.epsilonEquals(this.transferFunctionMatrix, 1.0E-7));
    }

    @Test
    public void testTimesException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            int rows = this.transferFunctionMatrix.getRows();
            int columns = this.transferFunctionMatrix.getColumns();
            Matrix testMatrix = Matrix.random((int)(rows - 1), (int)columns);
            this.transferFunctionMatrix.times(testMatrix);
        });
    }

    @Test
    public void testPlusDouble() {
        Matrix testMatrix = Matrix.random((int)this.transferFunctionMatrix.getRows(), (int)this.transferFunctionMatrix.getRows());
        TransferFunctionMatrix result = this.transferFunctionMatrix.plus(testMatrix);
        for (int m = 0; m < testMatrix.getRowDimension(); ++m) {
            for (int n = 0; n < testMatrix.getColumnDimension(); ++n) {
                TransferFunction resultTF = result.get(m, n);
                TransferFunction originalTF = this.transferFunctionMatrix.get(m, n);
                ObsoletePolynomial originalNumeratorCopy = new ObsoletePolynomial(originalTF.getNumeratorCoefficients());
                ObsoletePolynomial originalDenominatorCopy = new ObsoletePolynomial(originalTF.getDenominatorCoefficients());
                double matrixValue = testMatrix.get(m, n);
                if (originalNumeratorCopy.equalsZero()) {
                    Assert.assertTrue(resultTF.getNumeratorCoefficients()[0] == matrixValue);
                    Assert.assertEquals(1L, resultTF.getNumeratorCoefficients().length);
                    continue;
                }
                TransferFunction productTF = new TransferFunction(originalDenominatorCopy.times(matrixValue).plus(originalNumeratorCopy), originalNumeratorCopy);
                TransferFunction expectedTF = productTF.times(originalTF);
                Assert.assertTrue(expectedTF.epsilonEquals(resultTF, 1.0E-5));
            }
        }
    }

    @Test
    public void testPlusDoubleException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            Matrix testMatrix = new Matrix((double[][])new double[][]{{2.0, 5.0}});
            this.transferFunctionMatrix.plus(testMatrix);
        });
    }

    @Test
    public void testPlusTransferFunctionDouble() {
        TransferFunction[][] transferFunctions = new TransferFunction[][]{{this.secondOrderResponseTwo, this.simpleDecayTwo}, {this.secondOrderResponseOne, this.simpleDecayOne}};
        TransferFunctionMatrix testMatrix = new TransferFunctionMatrix((TransferFunction[][])transferFunctions);
        TransferFunctionMatrix result = this.transferFunctionMatrix.plus(testMatrix);
        for (int m = 0; m < testMatrix.getRows(); ++m) {
            for (int n = 0; n < testMatrix.getColumns(); ++n) {
                TransferFunction resultTF = result.get(m, n);
                TransferFunction originalTFOne = this.transferFunctionMatrix.get(m, n);
                ObsoletePolynomial originalNumeratorOneCopy = new ObsoletePolynomial(originalTFOne.getNumeratorCoefficients());
                ObsoletePolynomial originalDenominatorOneCopy = new ObsoletePolynomial(originalTFOne.getDenominatorCoefficients());
                TransferFunction originalTFTwo = testMatrix.get(m, n);
                ObsoletePolynomial originalNumeratorTwoCopy = new ObsoletePolynomial(originalTFTwo.getNumeratorCoefficients());
                ObsoletePolynomial originalDenominatorTwoCopy = new ObsoletePolynomial(originalTFTwo.getDenominatorCoefficients());
                if (originalNumeratorOneCopy.equalsZero()) {
                    Assert.assertTrue(originalTFTwo.epsilonEquals(resultTF, 1.0E-5));
                    continue;
                }
                TransferFunction productTF = new TransferFunction(originalNumeratorTwoCopy.times(originalDenominatorOneCopy), originalNumeratorOneCopy.times(originalDenominatorTwoCopy));
                productTF = productTF.plus(1.0);
                TransferFunction expectedTF = productTF.times(originalTFOne);
                Assert.assertTrue(expectedTF.epsilonEquals(resultTF, 1.0E-5));
            }
        }
    }

    @Test
    public void testPlusTransferFunctionException() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            TransferFunctionMatrix testMatrix = new TransferFunctionMatrix((TransferFunction[][])new TransferFunction[][]{{this.secondOrderResponseOne, this.secondOrderResponseTwo}});
            this.transferFunctionMatrix.plus(testMatrix);
        });
    }
}

