/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.DynamicSystemsTestHelpers;
import us.ihmc.robotics.linearDynamicSystems.SingleRealMode;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class SingleRealModeTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testDifferentLengths() {
        double eigenvalue = -2.0;
        double[] leftEigenvectorV = new double[]{1.0, 2.0};
        double[] rightEigenvectorW = new double[]{1.0};
        try {
            SingleRealMode singleRealMode = new SingleRealMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDotEqualsOne() {
        double eigenvalue = -2.0;
        double[] leftEigenvectorV = new double[]{1.0, 2.0};
        double[] rightEigenvectorW = new double[]{1.0, 3.0};
        try {
            SingleRealMode singleRealMode = new SingleRealMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConstructTransferFunctionMatrixSISO() {
        double eigenvalue = -2.0;
        double[] leftEigenvectorV = new double[]{1.0};
        double[] rightEigenvectorW = new double[]{1.0};
        SingleRealMode singleRealMode = new SingleRealMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
        Assert.assertEquals(eigenvalue, singleRealMode.getEigenvalue(), 1.0E-7);
        TransferFunctionMatrix transferFunctionMatrix = singleRealMode.constructTransferFunctionMatrix();
        Assert.assertEquals(1L, transferFunctionMatrix.getColumns());
        Assert.assertEquals(1L, transferFunctionMatrix.getRows());
        TransferFunction transferFunction = transferFunctionMatrix.get(0, 0);
        ObsoletePolynomial numeratorPolynomial = transferFunction.getNumeratorPolynomial();
        ObsoletePolynomial denominatorPolynomial = transferFunction.getDenominatorPolynomial();
        double[] numeratorCoefficients = numeratorPolynomial.getCoefficients();
        double[] denominatorCoefficients = denominatorPolynomial.getCoefficients();
        DynamicSystemsTestHelpers.assertEpsilonEquals(new double[]{1.0}, numeratorCoefficients, 1.0E-7);
        DynamicSystemsTestHelpers.assertEpsilonEquals(new double[]{1.0, -eigenvalue}, denominatorCoefficients, 1.0E-7);
    }

    @Test
    public void testConstructTransferFunctionMatrixMIMO() {
        double eigenvalue = -5.0;
        double[] leftEigenvectorV = new double[]{1.0, 2.0};
        double[] rightEigenvectorW = new double[]{0.5, 0.25};
        SingleRealMode singleRealMode = new SingleRealMode(eigenvalue, leftEigenvectorV, rightEigenvectorW);
        Assert.assertEquals(eigenvalue, singleRealMode.getEigenvalue(), 1.0E-7);
        TransferFunctionMatrix transferFunctionMatrix = singleRealMode.constructTransferFunctionMatrix();
        Assert.assertEquals(2L, transferFunctionMatrix.getColumns());
        Assert.assertEquals(2L, transferFunctionMatrix.getRows());
        double[] expectedDenominator = new double[]{1.0, -eigenvalue};
        double[][] expectedNumeratorConstants = new double[][]{{0.5, 0.25}, {1.0, 0.5}};
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                TransferFunction transferFunction = transferFunctionMatrix.get(i, j);
                ObsoletePolynomial numeratorPolynomial = transferFunction.getNumeratorPolynomial();
                ObsoletePolynomial denominatorPolynomial = transferFunction.getDenominatorPolynomial();
                double[] numeratorCoefficients = numeratorPolynomial.getCoefficients();
                double[] denominatorCoefficients = denominatorPolynomial.getCoefficients();
                DynamicSystemsTestHelpers.assertEpsilonEquals(new double[]{expectedNumeratorConstants[i][j]}, numeratorCoefficients, 1.0E-7);
                DynamicSystemsTestHelpers.assertEpsilonEquals(expectedDenominator, denominatorCoefficients, 1.0E-7);
            }
        }
    }
}

