/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTitleAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class MatlabChart {
    Font font = JFreeChart.DEFAULT_TITLE_FONT;
    JFreeChart chart;
    LegendTitle legend;
    ArrayList<Color> colors = new ArrayList();
    ArrayList<Stroke> strokes = new ArrayList();
    XYSeriesCollection dataset = new XYSeriesCollection();

    public void displayInJFrame() {
        this.displayInJFrame(false);
    }

    public void displayInJFrame(boolean waitUntilDone) {
        JFrame jFrame = new JFrame();
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        chartPanel.setBackground(Color.white);
        jFrame.add((Component)chartPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
        if (waitUntilDone) {
            final CountDownLatch latch = new CountDownLatch(1);
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void plot(double[] x, double[] y, String spec, float lineWidth, String title) {
        XYSeries series = new XYSeries((Comparable)((Object)title));
        for (int i = 0; i < x.length; ++i) {
            series.add(x[i], y[i]);
        }
        this.dataset.addSeries(series);
        this.FindColor(spec, lineWidth);
    }

    public void RenderPlot() {
        JFreeChart chart = null;
        if (this.dataset != null && this.dataset.getSeriesCount() > 0) {
            chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        } else {
            System.out.println(" [!] First create a chart and add data to it. The plot is empty now!");
        }
        XYPlot plot = chart.getXYPlot();
        for (int i = 0; i < this.colors.size(); ++i) {
            plot.getRenderer().setSeriesPaint(i, (Paint)this.colors.get(i));
            plot.getRenderer().setSeriesStroke(i, this.strokes.get(i));
        }
        ((NumberAxis)plot.getDomainAxis()).setAutoRangeIncludesZero(false);
        ((NumberAxis)plot.getRangeAxis()).setAutoRangeIncludesZero(false);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        this.legend = chart.getLegend();
        chart.removeLegend();
        this.chart = chart;
    }

    public void CheckExists() {
        if (this.chart == null) {
            throw new IllegalArgumentException("First plot something in the chart before you modify it.");
        }
    }

    public void font(String name, int fontSize) {
        this.CheckExists();
        this.font = new Font(name, 0, fontSize);
        this.chart.getTitle().setFont(this.font);
        this.chart.getXYPlot().getDomainAxis().setLabelFont(this.font);
        this.chart.getXYPlot().getDomainAxis().setTickLabelFont(this.font);
        this.chart.getXYPlot().getRangeAxis().setLabelFont(this.font);
        this.chart.getXYPlot().getRangeAxis().setTickLabelFont(this.font);
        this.legend.setItemFont(this.font);
    }

    public void title(String title) {
        this.CheckExists();
        this.chart.setTitle(title);
    }

    public void xlim(double l, double u) {
        this.CheckExists();
        this.chart.getXYPlot().getDomainAxis().setRange(l, u);
    }

    public void ylim(double l, double u) {
        this.CheckExists();
        this.chart.getXYPlot().getRangeAxis().setRange(l, u);
    }

    public void xlabel(String label) {
        this.CheckExists();
        this.chart.getXYPlot().getDomainAxis().setLabel(label);
    }

    public void ylabel(String label) {
        this.CheckExists();
        this.chart.getXYPlot().getRangeAxis().setLabel(label);
    }

    public void legend(String position) {
        this.CheckExists();
        this.legend.setItemFont(this.font);
        this.legend.setBackgroundPaint((Paint)Color.WHITE);
        this.legend.setFrame((BlockFrame)new BlockBorder((Paint)Color.BLACK));
        if (position.toLowerCase().equals("northoutside")) {
            this.legend.setPosition(RectangleEdge.TOP);
            this.chart.addLegend(this.legend);
        } else if (position.toLowerCase().equals("eastoutside")) {
            this.legend.setPosition(RectangleEdge.RIGHT);
            this.chart.addLegend(this.legend);
        } else if (position.toLowerCase().equals("southoutside")) {
            this.legend.setPosition(RectangleEdge.BOTTOM);
            this.chart.addLegend(this.legend);
        } else if (position.toLowerCase().equals("westoutside")) {
            this.legend.setPosition(RectangleEdge.LEFT);
            this.chart.addLegend(this.legend);
        } else if (position.toLowerCase().equals("north")) {
            this.legend.setPosition(RectangleEdge.TOP);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.5, 0.98, (Title)this.legend, RectangleAnchor.TOP);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("northeast")) {
            this.legend.setPosition(RectangleEdge.TOP);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.98, 0.98, (Title)this.legend, RectangleAnchor.TOP_RIGHT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("east")) {
            this.legend.setPosition(RectangleEdge.RIGHT);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.98, 0.5, (Title)this.legend, RectangleAnchor.RIGHT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("southeast")) {
            this.legend.setPosition(RectangleEdge.BOTTOM);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.98, 0.02, (Title)this.legend, RectangleAnchor.BOTTOM_RIGHT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("south")) {
            this.legend.setPosition(RectangleEdge.BOTTOM);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.5, 0.02, (Title)this.legend, RectangleAnchor.BOTTOM);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("southwest")) {
            this.legend.setPosition(RectangleEdge.BOTTOM);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.02, 0.02, (Title)this.legend, RectangleAnchor.BOTTOM_LEFT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("west")) {
            this.legend.setPosition(RectangleEdge.LEFT);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.02, 0.5, (Title)this.legend, RectangleAnchor.LEFT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        } else if (position.toLowerCase().equals("northwest")) {
            this.legend.setPosition(RectangleEdge.TOP);
            XYTitleAnnotation ta = new XYTitleAnnotation(0.02, 0.98, (Title)this.legend, RectangleAnchor.TOP_LEFT);
            this.chart.getXYPlot().addAnnotation((XYAnnotation)ta);
        }
    }

    public void grid(String xAxis, String yAxis) {
        this.CheckExists();
        if (xAxis.equalsIgnoreCase("on")) {
            this.chart.getXYPlot().setDomainGridlinesVisible(true);
            this.chart.getXYPlot().setDomainMinorGridlinesVisible(true);
            this.chart.getXYPlot().setDomainGridlinePaint((Paint)Color.GRAY);
        } else {
            this.chart.getXYPlot().setDomainGridlinesVisible(false);
            this.chart.getXYPlot().setDomainMinorGridlinesVisible(false);
        }
        if (yAxis.equalsIgnoreCase("on")) {
            this.chart.getXYPlot().setRangeGridlinesVisible(true);
            this.chart.getXYPlot().setRangeMinorGridlinesVisible(true);
            this.chart.getXYPlot().setRangeGridlinePaint((Paint)Color.GRAY);
        } else {
            this.chart.getXYPlot().setRangeGridlinesVisible(false);
            this.chart.getXYPlot().setRangeMinorGridlinesVisible(false);
        }
    }

    public void saveas(String fileName, int width, int height) {
        this.CheckExists();
        File file = new File(fileName);
        System.out.println("Saving chart to " + file.getAbsolutePath());
        try {
            ChartUtilities.saveChartAsJPEG((File)file, (JFreeChart)this.chart, (int)width, (int)height);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void FindColor(String spec, float lineWidth) {
        float[] dash = new float[]{5.0f};
        float[] dot = new float[]{lineWidth};
        Color color = Color.RED;
        BasicStroke stroke = new BasicStroke(lineWidth);
        if (spec.contains("-")) {
            stroke = new BasicStroke(lineWidth);
        } else if (spec.contains(":")) {
            stroke = new BasicStroke(lineWidth, 0, 0, 10.0f, dash, 0.0f);
        } else if (spec.contains(".")) {
            stroke = new BasicStroke(lineWidth, 0, 0, 2.0f, dot, 0.0f);
        }
        if (spec.contains("y")) {
            color = Color.YELLOW;
        } else if (spec.contains("m")) {
            color = Color.MAGENTA;
        } else if (spec.contains("c")) {
            color = Color.CYAN;
        } else if (spec.contains("r")) {
            color = Color.RED;
        } else if (spec.contains("g")) {
            color = Color.GREEN;
        } else if (spec.contains("b")) {
            color = Color.BLUE;
        } else if (spec.contains("k")) {
            color = Color.BLACK;
        }
        this.colors.add(color);
        this.strokes.add(stroke);
    }

    public static void main(String[] args) {
        double[] x = new double[100];
        x[0] = 1.0;
        double[] y1 = new double[100];
        y1[0] = 200.0;
        double[] y2 = new double[100];
        y2[0] = 300.0;
        for (int i = 1; i < x.length; ++i) {
            x[i] = i + 1;
            y1[i] = y1[i - 1] + Math.random() * 10.0 - 4.0;
            y2[i] = y2[i - 1] + Math.random() * 10.0 - 6.0;
        }
        MatlabChart fig = new MatlabChart();
        fig.plot(x, y1, "-r", 2.0f, "AAPL");
        fig.plot(x, y2, ":k", 3.0f, "BAC");
        fig.RenderPlot();
        fig.title("Stock 1 vs. Stock 2");
        fig.xlim(10.0, 100.0);
        fig.ylim(200.0, 300.0);
        fig.xlabel("Days");
        fig.ylabel("Price");
        fig.grid("on", "on");
        fig.legend("northeast");
        fig.font("Helvetica", 15);
        fig.displayInJFrame();
    }
}

