/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.DynamicSystemsTestHelpers;
import us.ihmc.robotics.linearDynamicSystems.EigenvalueDecomposer;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class DoubleMassSpringOscillatorTest {
    private static final boolean VERBOSE = true;

    @Test
    public void testDecomposerGotEigenvaluesRight() {
        double[][] simulatedDataTwo;
        double[][] simulatedDataOne;
        Matrix matrixA = new Matrix((double[][])new double[][]{{0.0, 1.0, 0.0, 0.0}, {-2.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {1.0, 0.0, -2.0, 0.0}});
        Matrix matrixB = new Matrix((double[][])new double[][]{{0.0}, {1.0}, {0.0}, {0.0}});
        DynamicSystemsTestHelpers.printMatrix("Double Mass Spring. \n\nA Matrix:", matrixA);
        DynamicSystemsTestHelpers.printMatrix("\nB Matrix:", matrixB);
        EigenvalueDecomposer eigenvalueDecomposerA = new EigenvalueDecomposer(matrixA);
        ComplexNumber[] eigenvaluesFromDecomposer = eigenvalueDecomposerA.getEigenvalues();
        DynamicSystemsTestHelpers.printComplexArray("\nEigenvalues:", eigenvaluesFromDecomposer);
        ComplexNumber[] expectedEigenvalues = new ComplexNumber[]{new ComplexNumber(0.0, Math.sqrt(3.0)), new ComplexNumber(0.0, -Math.sqrt(3.0)), new ComplexNumber(0.0, Math.sqrt(1.0)), new ComplexNumber(0.0, -Math.sqrt(1.0))};
        DynamicSystemsTestHelpers.assertEpsilonEquals(expectedEigenvalues, eigenvaluesFromDecomposer, 1.0E-7);
        ComplexNumber[][] leftEigenvectorV = eigenvalueDecomposerA.getLeftEigenvectors();
        DynamicSystemsTestHelpers.printComplexArray("\nLeft Eigenvectors", leftEigenvectorV);
        ComplexNumber[][] rightEigenvectorW = eigenvalueDecomposerA.getRightEigenvectors();
        DynamicSystemsTestHelpers.printComplexArray("\nRight Eigenvectors", rightEigenvectorW);
        ArrayList realModes = eigenvalueDecomposerA.getRealModes();
        DynamicSystemsTestHelpers.printRealModeArray("\nReal Modes:", realModes);
        ArrayList complexConjugateModes = eigenvalueDecomposerA.getComplexConjugateModes();
        DynamicSystemsTestHelpers.printComplexConjugateModeArray("\nComplex Conjugate Modes:", complexConjugateModes);
        LinearDynamicSystem system = new LinearDynamicSystem(matrixA, matrixB, null, null);
        TransferFunctionMatrix transferFunctionMatrix = system.getTransferFunctionMatrix();
        System.out.println("\nTransfer Function Matrix:");
        System.out.println(transferFunctionMatrix);
        DynamicSystemsTestHelpers.checkLeftAndRightEigenvectors(leftEigenvectorV, rightEigenvectorW);
        TransferFunction transferFunction = transferFunctionMatrix.get(0, 0);
        ObsoletePolynomial denominatorPolynomial = transferFunction.getDenominatorPolynomial();
        ObsoletePolynomial numeratorPolynomial = transferFunction.getNumeratorPolynomial();
        Assert.assertTrue(denominatorPolynomial.epsilonEquals(new ObsoletePolynomial(new double[]{1.0, 0.0, 4.0, 0.0, 3.0}), 1.0E-7));
        Assert.assertTrue(numeratorPolynomial.epsilonEquals(new ObsoletePolynomial(new double[]{1.0, 0.0, 2.0}), 1.0E-7));
        double stepSize = 0.001;
        int numTicks = (int)(2.0 / stepSize);
        double[] initialConditionsOne = new double[]{0.1, 0.0, -0.1, 0.0};
        for (double[] dataPoint : simulatedDataOne = system.simulateInitialConditions(initialConditionsOne, stepSize, numTicks)) {
            Assert.assertEquals(dataPoint[0], -dataPoint[2], 1.0E-7);
        }
        double[] initialConditionsTwo = new double[]{0.1, 0.0, 0.1, 0.0};
        for (double[] dataPoint : simulatedDataTwo = system.simulateInitialConditions(initialConditionsTwo, stepSize, numTicks)) {
            Assert.assertEquals(dataPoint[0], dataPoint[2], 1.0E-7);
        }
        double[] initialConditionsCombined = new double[]{0.2, 0.0, 0.0, 0.0};
        double[][] simulatedDataCombined = system.simulateInitialConditions(initialConditionsCombined, stepSize, numTicks);
        for (int i = 0; i < simulatedDataCombined.length; ++i) {
            double[] dataPointCombined = simulatedDataCombined[i];
            double[] dataPointOne = simulatedDataOne[i];
            double[] dataPointTwo = simulatedDataTwo[i];
            for (int j = 0; j < dataPointCombined.length; ++j) {
                Assert.assertEquals(dataPointCombined[j], dataPointOne[j] + dataPointTwo[j], 1.0E-7);
            }
        }
    }
}

