/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.linearAlgebra.DampedLeastSquaresNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.QRNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.SVDNullspaceCalculator;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class NullspaceCalculatorTimingTest {
    @Test
    public void testRemoveNullspaceComponent() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        ExecutionTimer svdTimer = new ExecutionTimer("svdTimer", registry);
        ExecutionTimer leastSquaresTimer = new ExecutionTimer("leastSquarestTimer", registry);
        ExecutionTimer qrTimer = new ExecutionTimer("qrTimer", registry);
        SVDNullspaceCalculator svdCalculator = new SVDNullspaceCalculator(100, true);
        QRNullspaceCalculator qrCalculator = new QRNullspaceCalculator(100);
        DampedLeastSquaresNullspaceCalculator leastSquaresCalculator = new DampedLeastSquaresNullspaceCalculator(100, 0.0);
        Random random = new Random(10L);
        double[] Jvalues = RandomNumbers.nextDoubleArray((Random)random, (int)200, (double)10.0);
        double[] Avalues = RandomNumbers.nextDoubleArray((Random)random, (int)100, (double)10.0);
        for (int i = 0; i < 10000; ++i) {
            DMatrixRMaj J = new DMatrixRMaj(10, 20, false, Jvalues);
            DMatrixRMaj A = new DMatrixRMaj(5, 20, false, Avalues);
            DMatrixRMaj A_projected1 = new DMatrixRMaj(5, 20, false, Avalues);
            DMatrixRMaj A_projected2 = new DMatrixRMaj(5, 20, false, Avalues);
            DMatrixRMaj A_projected3 = new DMatrixRMaj(5, 20, false, Avalues);
            svdTimer.startMeasurement();
            svdCalculator.projectOntoNullspace(A, J, A_projected1);
            svdTimer.stopMeasurement();
            leastSquaresTimer.startMeasurement();
            leastSquaresCalculator.projectOntoNullspace(A, J, A_projected2);
            leastSquaresTimer.stopMeasurement();
            qrTimer.startMeasurement();
            qrCalculator.projectOntoNullspace(A, J, A_projected3);
            qrTimer.stopMeasurement();
            for (int j = 0; j < A_projected1.getNumElements(); ++j) {
                Assert.assertEquals(A_projected1.get(j), A_projected2.get(j), 1.0E-5);
                Assert.assertEquals(A_projected1.get(j), A_projected3.get(j), 1.0E-5);
            }
        }
        PrintTools.info((String)("SVD average time : " + svdTimer.getAverageTime()));
        PrintTools.info((String)("Least Squares average time : " + leastSquaresTimer.getAverageTime()));
        PrintTools.info((String)("QR average time : " + qrTimer.getAverageTime()));
    }
}

