/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import Jama.Matrix;
import java.util.Random;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.linearAlgebra.MatrixStatistics;

public class MatrixStatisticsTest {
    private static final int ITERATIONS = 100;
    private static final double MAXDOUBLE = 100000.0;
    private static final int MAXROWS = 15;
    private static final int MAXCOLUMNS = 15;
    private static final double DELTA = 0.001;
    private Random random;

    @BeforeEach
    public void setUp() {
        this.random = new Random();
    }

    public int randomDimension(int maximum) {
        if (maximum == 1) {
            return 1;
        }
        return this.random.nextInt(maximum - 1) + 1;
    }

    public double randomDouble() {
        return this.random.nextDouble() * 100000.0 * 2.0 - 100000.0;
    }

    @Test
    public void testIndecesOfMaxElement() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns);
            int[] indices = MatrixStatistics.indecesOfMaxElement((Matrix)matrix);
            Assert.assertEquals(0L, indices[0]);
            Assert.assertEquals(0L, indices[1]);
            int rowMaxValue = this.randomDimension(rows) - 1;
            int columnMaxValue = this.randomDimension(columns) - 1;
            double maxValue = Math.abs(this.randomDouble());
            matrix.set(rowMaxValue, columnMaxValue, maxValue);
            indices = MatrixStatistics.indecesOfMaxElement((Matrix)matrix);
            Assert.assertEquals(rowMaxValue, indices[0]);
            Assert.assertEquals(columnMaxValue, indices[1]);
        }
    }

    @Test
    public void testGetCovarianceMatrix() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns, 0.0);
            double[] averageColumn = new double[rows];
            for (int m = 0; m < rows; ++m) {
                averageColumn[m] = 0.0;
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    int n2 = m;
                    averageColumn[n2] = averageColumn[n2] + value / (double)columns;
                    matrix.set(m, n, value);
                }
            }
            Matrix covarianceTest = new Matrix(rows, rows, 0.0);
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < rows; ++n) {
                    double covariance = 0.0;
                    for (int o = 0; o < columns; ++o) {
                        covariance += (matrix.get(m, o) - averageColumn[m]) * (matrix.get(n, o) - averageColumn[n]) / (double)columns;
                    }
                    covarianceTest.set(m, n, covariance);
                }
            }
            Matrix covarianceMatrix = MatrixStatistics.getCovarianceMatrix((Matrix)matrix);
            Assert.assertEquals(covarianceTest.getRowDimension(), covarianceMatrix.getRowDimension());
            Assert.assertEquals(covarianceTest.getColumnDimension(), covarianceMatrix.getColumnDimension());
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < rows; ++n) {
                    Assert.assertEquals(covarianceMatrix.get(m, n), covarianceMatrix.get(n, m), 0.001);
                    Assert.assertEquals(covarianceTest.get(m, n), covarianceMatrix.get(m, n), 0.001);
                }
            }
        }
    }

    @Test
    public void testSubtractAverageColumnFromEachRow() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns, 0.0);
            double[] averages = new double[rows];
            for (int m = 0; m < rows; ++m) {
                averages[m] = 0.0;
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    int n2 = m;
                    averages[n2] = averages[n2] + value / (double)columns;
                    matrix.set(m, n, value);
                }
            }
            Matrix subtractedAverageMatrix = MatrixStatistics.subtractAverageColumnFromEachRow((Matrix)matrix);
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < columns; ++n) {
                    Assert.assertEquals(matrix.get(m, n) - averages[m], subtractedAverageMatrix.get(m, n), 0.001);
                }
            }
        }
    }

    @Test
    public void testSumAllElements() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            double sum = 0.0;
            Matrix matrix = new Matrix(rows, columns, 0.0);
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    sum += value;
                    matrix.set(m, n, value);
                }
            }
            Assert.assertEquals(sum, MatrixStatistics.sumAllElements((Matrix)matrix), 0.001);
        }
    }

    @Test
    public void testDivideEachRowByStdDevOfRow() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns, 0.0);
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    matrix.set(m, n, value);
                }
            }
            Matrix variances = MatrixStatistics.getVarianceOfEachRow((Matrix)matrix);
            Matrix dividedByStdDev = MatrixStatistics.divideEachRowByStdDevOfRow((Matrix)matrix);
            for (int m = 0; m < rows; ++m) {
                for (int n = 0; n < columns; ++n) {
                    Assert.assertEquals(matrix.get(m, n) / Math.sqrt(variances.get(m, 0)), dividedByStdDev.get(m, n), 0.001);
                }
            }
        }
    }

    @Test
    public void testGetVarianceOfEachRow() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns, 0.0);
            double[] rowSums = new double[rows];
            for (int m = 0; m < rows; ++m) {
                rowSums[m] = 0.0;
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    int n2 = m;
                    rowSums[n2] = rowSums[n2] + value;
                    matrix.set(m, n, value);
                }
            }
            Matrix variancesMatrix = MatrixStatistics.getVarianceOfEachRow((Matrix)matrix);
            double[][] internalMatrix = matrix.getArrayCopy();
            for (int m = 0; m < matrix.getRowDimension(); ++m) {
                double[] row = internalMatrix[m];
                double average = rowSums[m] / (double)columns;
                double variance = 0.0;
                for (int n = 0; n < row.length; ++n) {
                    variance += MathTools.square((double)(row[n] - average)) / (double)columns;
                }
                Assert.assertEquals(variance, variancesMatrix.get(m, 0), 0.001);
            }
        }
    }

    @Test
    public void testGetAverageColumnVector() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            int columns = this.randomDimension(15);
            Matrix matrix = new Matrix(rows, columns, 0.0);
            double[] rowAverages = new double[rows];
            for (int m = 0; m < rows; ++m) {
                rowAverages[m] = 0.0;
                for (int n = 0; n < columns; ++n) {
                    double value = this.randomDouble();
                    int n2 = m;
                    rowAverages[n2] = rowAverages[n2] + value / (double)columns;
                    matrix.set(m, n, value);
                }
            }
            Matrix averageColumnVector = MatrixStatistics.getAverageColumnVector((Matrix)matrix);
            for (int m = 0; m < rows; ++m) {
                Assert.assertEquals(rowAverages[m], averageColumnVector.get(m, 0), 0.001);
            }
        }
    }

    @Test
    public void testCreateColumnVectorIntDouble() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            double value = this.randomDouble();
            Matrix matrix = MatrixStatistics.createColumnVector((int)rows, (double)value);
            Assert.assertEquals(rows, matrix.getRowDimension());
            Assert.assertEquals(1L, matrix.getColumnDimension());
            for (int m = 0; m < rows; ++m) {
                Assert.assertEquals(value, matrix.get(m, 0), 0.001);
            }
        }
    }

    @Test
    public void testCreateRowVectorIntDouble() {
        for (int i = 0; i < 100; ++i) {
            int columns = this.randomDimension(15);
            double value = this.randomDouble();
            Matrix matrix = MatrixStatistics.createRowVector((int)columns, (double)value);
            Assert.assertEquals(1L, matrix.getRowDimension());
            Assert.assertEquals(columns, matrix.getColumnDimension());
            for (int n = 0; n < columns; ++n) {
                Assert.assertEquals(value, matrix.get(0, n), 0.001);
            }
        }
    }

    @Test
    public void testCreateColumnVectorInt() {
        for (int i = 0; i < 100; ++i) {
            int rows = this.randomDimension(15);
            Matrix matrix = MatrixStatistics.createColumnVector((int)rows);
            Assert.assertEquals(rows, matrix.getRowDimension());
            Assert.assertEquals(1L, matrix.getColumnDimension());
            for (int m = 0; m < rows; ++m) {
                Assert.assertEquals(0.0, matrix.get(m, 0), 0.001);
            }
        }
    }

    @Test
    public void testCreateRowVectorInt() {
        for (int i = 0; i < 100; ++i) {
            int columns = this.randomDimension(15);
            Matrix matrix = MatrixStatistics.createRowVector((int)columns);
            Assert.assertEquals(1L, matrix.getRowDimension());
            Assert.assertEquals(columns, matrix.getColumnDimension());
            for (int n = 0; n < columns; ++n) {
                Assert.assertEquals(0.0, matrix.get(0, n), 0.001);
            }
        }
    }

    @Disabled
    @Test
    public void testGetRowNumber() {
        Assert.fail("Not yet implemented");
    }

    @Disabled
    @Test
    public void testGetColumnNumber() {
        Assert.fail("Not yet implemented");
    }
}

