/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.linearAlgebra.DampedNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.DampedNullspaceCalculatorTest;
import us.ihmc.robotics.linearAlgebra.DampedQRNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.NullspaceCalculator;

public class DampedQRNullspaceCalculatorTest
extends DampedNullspaceCalculatorTest {
    @Override
    public DampedNullspaceCalculator getDampedNullspaceProjectorCalculator() {
        return new DampedQRNullspaceCalculator(10, 0.0);
    }

    @Override
    public NullspaceCalculator getNullspaceProjectorCalculator() {
        return this.getDampedNullspaceProjectorCalculator();
    }

    public static void matrixEquals(DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        for (int i = 0; i < expected.getNumElements(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i), epsilon);
        }
    }

    private static DMatrixRMaj createMatrix(int size) {
        DMatrixRMaj upperDiagonal = new DMatrixRMaj(size, size);
        double value = 1.0;
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                upperDiagonal.set(i, j, value);
                value += 1.0;
            }
        }
        return upperDiagonal;
    }

    @Test
    public void testInnerProductMultiply() {
        for (int size = 2; size < 20; ++size) {
            DMatrixRMaj upperDiagonal = DampedQRNullspaceCalculatorTest.createMatrix(size);
            DMatrixRMaj expected = new DMatrixRMaj(size, size);
            CommonOps_DDRM.multTransA((DMatrix1Row)upperDiagonal, (DMatrix1Row)upperDiagonal, (DMatrix1Row)expected);
            DMatrixRMaj actual = new DMatrixRMaj(size, size);
            DampedQRNullspaceCalculator.inner_small_upper_diagonal((DMatrix1Row)upperDiagonal, (DMatrix1Row)actual);
            DampedQRNullspaceCalculatorTest.matrixEquals(expected, actual, 1.0E-7);
        }
    }
}

