/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.lidar;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.lidar.LidarScan;
import us.ihmc.robotics.lidar.LidarScanParameters;

public class AbstractLidarScanTest {
    Random rand = new Random(1098L);
    private static final double eps = 1.0E-7;

    @Test
    public void testIdentityScan() {
        int numPoints = 100;
        LidarScanParameters params = new LidarScanParameters(numPoints, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        float[] ranges = new float[numPoints];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = this.rand.nextFloat();
        }
        LidarScan lidarScan = new LidarScan(params, new RigidBodyTransform(), new RigidBodyTransform(), ranges);
        for (int i = 0; i < ranges.length; ++i) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D((double)ranges[i], 0.0, 0.0), (EuclidGeometry)lidarScan.getPoint(i), (double)1.0E-7);
        }
    }

    @Test
    public void testSimpleScanRotating() {
        int numPoints = 100;
        LidarScanParameters params = new LidarScanParameters(numPoints, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        RigidBodyTransform startTransform = new RigidBodyTransform();
        RigidBodyTransform endTransform = new RigidBodyTransform();
        float[] ranges = new float[numPoints];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = this.rand.nextFloat();
        }
        LidarScan lidarScan = new LidarScan(params, startTransform, endTransform, ranges);
        double sweepPerStep = (params.sweepYawMax - params.sweepYawMin) / (float)(params.pointsPerSweep - 1);
        for (int i = 0; i < ranges.length; ++i) {
            Point3D p = new Point3D((double)ranges[i], 0.0, 0.0);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.setRotationYawAndZeroTranslation((double)params.sweepYawMin + (double)i * sweepPerStep);
            transform.transform((Point3DBasics)p);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)p, (EuclidGeometry)lidarScan.getPoint(i), (double)1.0E-7);
        }
    }

    @Test
    public void testInterpolationWhileRotating() {
        int numPoints = 100;
        double sweepMin = -1.0;
        double sweepMax = 1.1;
        LidarScanParameters params = new LidarScanParameters(numPoints, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        RigidBodyTransform startTransform = new RigidBodyTransform();
        RigidBodyTransform endTransform = new RigidBodyTransform();
        startTransform.setRotationYawAndZeroTranslation(sweepMin);
        endTransform.setRotationYawAndZeroTranslation(sweepMax);
        float[] ranges = new float[numPoints];
        for (int i = 0; i < ranges.length; ++i) {
            ranges[i] = this.rand.nextFloat();
        }
        LidarScan lidarScan = new LidarScan(params, startTransform, endTransform, ranges);
        double sweepPerStep = (sweepMax - sweepMin) / (double)(numPoints - 1);
        for (int i = 0; i < ranges.length; ++i) {
            Point3D p = new Point3D((double)ranges[i], 0.0, 0.0);
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.setRotationYawAndZeroTranslation(sweepMin + (double)i * sweepPerStep);
            transform.transform((Point3DBasics)p);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)p, (EuclidGeometry)lidarScan.getPoint(i), (double)1.0E-7);
        }
    }

    public RigidBodyTransform randomTransform() {
        Quaternion rotate = new Quaternion(this.rand.nextDouble(), this.rand.nextDouble(), this.rand.nextDouble(), this.rand.nextDouble());
        Vector3D translate = new Vector3D(this.rand.nextDouble(), this.rand.nextDouble(), this.rand.nextDouble());
        return new RigidBodyTransform((Orientation3DReadOnly)rotate, (Tuple3DReadOnly)translate);
    }

    @Test
    public void testLineSegment() {
    }

    @Test
    public void testRay() {
    }
}

