/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.kinematics;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.kinematics.TimeStampedTransform3D;

public class TimeStampedTransform3DTest {
    private static final double EPSILON = 1.0E-15;

    @Test
    public void testEmptyConstructor() {
        TimeStampedTransform3D toBeTested = new TimeStampedTransform3D();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        long expectedTimestamp = 0L;
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimestamp, toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
    }

    @Test
    public void testConstructor() {
        Random random = new Random(3213620L);
        RigidBodyTransform expectedTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        long expectedTimestamp = RandomNumbers.nextInt((Random)random, (int)132, (int)51568418);
        TimeStampedTransform3D toBeTested = new TimeStampedTransform3D(expectedTransform, expectedTimestamp);
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimestamp, toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
        Assert.assertTrue("TimestampedTransform should only copy the given transform into an internal variable", expectedTransform != toBeTested.getTransform3D());
    }

    @Test
    public void testSetters() {
        TimeStampedTransform3D toBeTested = new TimeStampedTransform3D();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        long expectedTimestamp = 0L;
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimestamp, toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
        Random random = new Random(3213620L);
        expectedTimestamp = RandomNumbers.nextInt((Random)random, (int)132, (int)51568418);
        toBeTested.setTimeStamp(expectedTimestamp);
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimestamp, toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
        expectedTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        toBeTested.setTransform3D(expectedTransform);
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimestamp, toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
        expectedTimestamp = RandomNumbers.nextInt((Random)random, (int)132, (int)51568418);
        expectedTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        TimeStampedTransform3D expectedTimeStampedTransform = new TimeStampedTransform3D(expectedTransform, expectedTimestamp);
        toBeTested.set(expectedTimeStampedTransform);
        Assert.assertEquals("Timestamp is different from what was expected", expectedTimeStampedTransform.getTimeStamp(), toBeTested.getTimeStamp());
        Assert.assertTrue("Transform is different from what was expected", expectedTimeStampedTransform.getTransform3D().epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
    }

    @Test
    public void testGetTransform() {
        TimeStampedTransform3D toBeTested = new TimeStampedTransform3D();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        toBeTested.getTransform3D().set(expectedTransform);
        Assert.assertTrue("Transform is different from what was expected", expectedTransform.epsilonEquals((EuclidGeometry)toBeTested.getTransform3D(), 1.0E-15));
    }
}

