/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.SphericalLinearResolutionProvider;

public class SphericalLinearResolutionProviderTest {
    private static final double eps = 1.0E-7;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void test() {
        double minRes = 0.05;
        double maxRes = 0.5;
        SphericalLinearResolutionProvider resolutionProvider = new SphericalLinearResolutionProvider(new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0), new OneDimensionalBounds(Double.valueOf(1.0), Double.valueOf(10.0)), minRes, maxRes);
        double[] ds = new double[]{0.0, 0.0, 0.0};
        Assert.assertEquals(minRes, resolutionProvider.getResolution(ds), 1.0E-7);
        double[] ds1 = new double[]{1.0, 0.0, 0.0};
        Assert.assertEquals(minRes, resolutionProvider.getResolution(ds1), 1.0E-7);
        double[] ds2 = new double[]{10.0, 0.0, 0.0};
        Assert.assertEquals(maxRes, resolutionProvider.getResolution(ds2), 1.0E-7);
        double[] ds3 = new double[]{100.0, 0.0, 0.0};
        Assert.assertEquals(maxRes, resolutionProvider.getResolution(ds3), 1.0E-7);
        double[] ds4 = new double[]{5.5, 0.0, 0.0};
        Assert.assertEquals((maxRes + minRes) * 0.5, resolutionProvider.getResolution(ds4), 1.0E-7);
    }
}

