/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTree;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTreeStaticTestingUtilities;
import us.ihmc.robotics.hyperCubeTree.HyperVolume;
import us.ihmc.robotics.hyperCubeTree.LineSegmentSearchVolume;
import us.ihmc.robotics.hyperCubeTree.Octree;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;

public class OctreeTest {
    private static final String[] axes = new String[]{"x", "y", "z"};

    @Test
    public void testSimplePutGetOctree() {
        Octree tree = this.setupUnitCubeOctree(0.5);
        tree.put(new double[]{0.0, 0.0, 0.0}, (Object)true);
        Assertions.assertEquals((Object)true, (Object)tree.getRootNode().getLeaf().getValue());
        Assertions.assertEquals((Object)false, (Object)tree.getRootNode().hasChildren());
        tree.put(new double[]{0.0, 0.0, 0.0}, (Object)true);
        Assertions.assertEquals((Object)true, (Object)tree.getRootNode().hasChildren());
        Assertions.assertEquals((Object)true, (Object)tree.get(new double[]{0.0, 0.0, 0.0}).getValue());
        Assertions.assertEquals((int)8, (int)tree.listAllLeafNodes().size());
        Assertions.assertEquals((int)1, (int)tree.listAllLeaves().size());
        tree.put(new double[]{0.0, 0.0, 0.0}, (Object)false);
        Assertions.assertEquals((Object)true, (Object)tree.getRootNode().hasChildren());
        Assertions.assertEquals((Object)false, (Object)tree.get(new double[]{0.0, 0.0, 0.0}).getValue());
        Assertions.assertNull((Object)tree.get(new double[]{1.0, 0.0, 0.0}));
        Assertions.assertEquals((int)8, (int)tree.listAllLeafNodes().size());
        Assertions.assertEquals((int)1, (int)tree.listAllLeaves().size());
        tree.put(new double[]{1.0, 0.0, 0.0}, (Object)false);
        Assertions.assertEquals((Object)true, (Object)tree.getRootNode().hasChildren());
        Assertions.assertEquals((Object)false, (Object)tree.get(new double[]{1.0, 0.0, 0.0}).getValue());
        Assertions.assertNull((Object)tree.get(new double[]{0.0, 1.0, 0.0}));
        Assertions.assertNull((Object)tree.get(new double[]{0.0, 0.0, 1.0}));
        Assertions.assertEquals((int)8, (int)tree.listAllLeafNodes().size());
        Assertions.assertEquals((int)2, (int)tree.listAllLeaves().size());
    }

    @Test
    public void test3DPutGetRemoveTwoLevel() {
        Octree tree = this.setupUnitCubeOctree(0.25);
        double d1 = 0.125;
        double d2 = 0.375;
        double d3 = 0.625;
        OctreeTest.reportLeafCount(0, tree);
        tree.put(new double[]{d1, d1, d1}, (Object)true);
        tree.put(new double[]{d1, d1, d1}, (Object)true);
        tree.put(new double[]{d1, d2, d1}, (Object)true);
        tree.put(new double[]{d1, d1, d2}, (Object)true);
        tree.put(new double[]{d1, d2, d2}, (Object)true);
        tree.put(new double[]{d2, d1, d1}, (Object)true);
        tree.put(new double[]{d2, d2, d1}, (Object)true);
        tree.put(new double[]{d2, d1, d2}, (Object)true);
        tree.put(new double[]{d2, d2, d2}, (Object)true);
        OctreeTest.reportLeafCount(8, tree);
        tree.put(new double[]{d1, d3, d3}, (Object)false);
        OctreeTest.reportLeafCount(9, tree);
        tree.put(new double[]{d1, d3, d1}, (Object)false);
        tree.put(new double[]{d1, d1, d3}, (Object)false);
        OctreeTest.reportLeafCount(11, tree);
        Assertions.assertTrue((boolean)((Boolean)tree.get(new double[]{d1, d1, d1}).getValue()));
        Assertions.assertFalse((boolean)((Boolean)tree.get(new double[]{d1, d3, d3}).getValue()));
        Assertions.assertFalse((boolean)((Boolean)tree.get(new double[]{d1, d3, d1}).getValue()));
        Assertions.assertFalse((boolean)((Boolean)tree.get(new double[]{d1, d1, d3}).getValue()));
        HyperCubeLeaf lastRemainingTrueNode = tree.get(new double[]{d2, d2, d2});
        tree.remove(lastRemainingTrueNode);
        OctreeTest.reportLeafCount(4, tree);
    }

    @Test
    public void testOctreeInternalBoarders() {
        Octree tree = this.setupUnitCubeOctree(0.25);
        tree.put(new double[]{0.0, 0.0, 0.0}, (Object)false);
        tree.put(new double[]{0.5, 0.5, 0.5}, (Object)true);
        tree.put(new double[]{0.5, 0.5, 0.5}, (Object)true);
        tree.put(new double[]{0.0, 0.0, 0.0}, (Object)false);
        Assertions.assertEquals((int)2, (int)tree.listAllLeaves().size());
    }

    @Test
    public void testOctreeLineSearch() {
        Octree tree = this.createStandardTestOctree();
        OctreeTest.reportLeafCount(35, tree);
        List nodes = OctreeTest.getNodesIntersectingLine(tree, new Point3D(0.0, 0.0, 0.0), new Point3D(1.0, 1.0, 0.0));
        Assertions.assertEquals((int)4, (int)nodes.size());
        nodes = OctreeTest.getNodesIntersectingLine(tree, new Point3D(0.0, 0.0, 0.0), new Point3D(0.0, 0.0, 0.0));
        Assertions.assertEquals((int)1, (int)nodes.size());
        nodes = OctreeTest.getNodesIntersectingLine(tree, new Point3D(1.0, 0.0, 0.0), new Point3D(1.0, 0.0, 1.0));
        Assertions.assertEquals((int)3, (int)nodes.size());
        nodes = OctreeTest.getNodesIntersectingLine(tree, new Point3D(0.9, 0.1, 0.9), new Point3D(0.9, 0.9, 0.9));
        Assertions.assertEquals((int)4, (int)nodes.size());
    }

    @Test
    public void testPrint() {
        Octree tree = this.createStandardTestOctree();
        System.out.println(tree.toString());
    }

    @Test
    public void testPutLidarInOctree() {
        Octree tree = this.createStandardTestOctree();
        Assertions.assertNull((Object)tree.get(new double[]{0.0, 0.0, 0.0}));
        Assertions.assertNull((Object)tree.get(new double[]{0.375, 0.0, 0.0}));
        tree.putLidarAtGraduallyMoreAccurateResolution(new Point3D(0.0, 0.0, 0.0), new Point3D(0.375, 0.0, 0.0));
        Assertions.assertEquals((Object)true, (Object)tree.get(new double[]{0.0, 0.0, 0.0}).getValue());
        Assertions.assertEquals((Object)true, (Object)tree.get(new double[]{0.375, 0.0, 0.0}).getValue());
        tree.putLidarAtGraduallyMoreAccurateResolution(new Point3D(0.0, 0.0, 0.0), new Point3D(0.375, 0.0, 0.0));
        Assertions.assertEquals((Object)false, (Object)tree.get(new double[]{0.0, 0.0, 0.0}).getValue());
        Assertions.assertEquals((Object)true, (Object)tree.get(new double[]{0.375, 0.0, 0.0}).getValue());
    }

    @Test
    public void testShootOctreeIntoSphereWithLidarBullets() {
        long time = System.currentTimeMillis();
        Octree tree = this.setupUnitCubeOctree(1.25E-5);
        HyperCubeTreeStaticTestingUtilities.shootTreeIntoSphere((Octree)tree, (double)0.4, (double)10.5, (double)0.45, (double)0.45, (double)0.45, (int)10000);
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        System.out.println("Octree has " + tree.listAllLeaves().size() + " leaves");
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
    }

    private Octree createStandardTestOctree() {
        Octree tree = this.setupUnitCubeOctree(0.25);
        OctreeTest.reportLeafCount(0, tree);
        double d1 = 0.125;
        double d2 = 0.375;
        double d3 = 0.625;
        double d4 = 0.875;
        HyperCubeTreeStaticTestingUtilities.fillOctreeDefaultTest((HyperCubeTree)tree, (double)d1, (double)d2, (double)d3, (double)d4);
        return tree;
    }

    private static <T, D> List<RecursableHyperTreeNode<T, D>> getNodesIntersectingLine(HyperCubeTree<T, D> tree, Point3D startPoint, Point3D endPoint) {
        LineSegment3D lineSegment = new LineSegment3D((Point3DReadOnly)startPoint, (Point3DReadOnly)endPoint);
        LineSegmentSearchVolume hyperVolume = new LineSegmentSearchVolume(lineSegment);
        List nodes = tree.getHyperVolumeIntersection((HyperVolume)hyperVolume);
        return nodes;
    }

    private static <T, D> void reportLeafCount(int expected, HyperCubeTree<T, D> tree) {
        int numberOfLeaves = tree.listAllLeaves().size();
        System.out.println("node has this many leaves: " + numberOfLeaves);
        Assertions.assertEquals((int)expected, (int)numberOfLeaves);
    }

    private Octree setupUnitCubeOctree(double resolution) {
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[3];
        for (int i = 0; i < 3; ++i) {
            bounds[i] = new OneDimensionalBounds(Double.valueOf(0.0), Double.valueOf(1.0));
        }
        Octree tree = new Octree(bounds, resolution);
        return tree;
    }
}

