/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.TransformTools;

public class TransformToolsTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testRotate() {
        RigidBodyTransform transform = new RigidBodyTransform();
        TransformTools.appendRotation((RigidBodyTransform)transform, (double)0.7853981633974483, (Axis3D)Axis3D.X);
        RigidBodyTransform transform2 = new RigidBodyTransform();
        transform2.setRotationRollAndZeroTranslation(0.7853981633974483);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)transform, (EuclidGeometry)transform2, (double)1.0E-7);
        transform = new RigidBodyTransform();
        TransformTools.appendRotation((RigidBodyTransform)transform, (double)2.356194490192345, (Axis3D)Axis3D.Y);
        transform2 = new RigidBodyTransform();
        transform2.setRotationPitchAndZeroTranslation(2.356194490192345);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)transform, (EuclidGeometry)transform2, (double)1.0E-7);
        transform = new RigidBodyTransform();
        TransformTools.appendRotation((RigidBodyTransform)transform, (double)-1.5707963267948966, (Axis3D)Axis3D.Z);
        transform2 = new RigidBodyTransform();
        transform2.setRotationYawAndZeroTranslation(-1.5707963267948966);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)transform, (EuclidGeometry)transform2, (double)1.0E-7);
    }

    @Test
    public void testGetTransformFromA1toA2Simple() {
        Vector3D vectorA1 = new Vector3D(-1.0, -2.0, -3.0);
        RigidBodyTransform transformFromWorldToA1 = new RigidBodyTransform();
        transformFromWorldToA1.getTranslation().set((Tuple3DReadOnly)vectorA1);
        Vector3D vectorA2 = new Vector3D((Tuple3DReadOnly)vectorA1);
        vectorA2.negate();
        RigidBodyTransform transformFromWorldToA2 = new RigidBodyTransform();
        transformFromWorldToA2.getTranslation().set((Tuple3DReadOnly)vectorA2);
        ReferenceFrame a1 = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)"a1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transformFromWorldToA1);
        ReferenceFrame a2 = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)"a2", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transformFromWorldToA2);
        RigidBodyTransform transformA2toA1 = TransformTools.getTransformFromA2toA1((RigidBodyTransform)transformFromWorldToA1, (RigidBodyTransform)transformFromWorldToA2);
        Point3D a2Origin = new Point3D();
        transformA2toA1.transform((Point3DBasics)a2Origin);
        FramePoint3D a2OriginFramePoint = new FramePoint3D(a2);
        a2OriginFramePoint.changeFrame(a1);
        a2Origin.epsilonEquals((EuclidGeometry)a2OriginFramePoint, 1.0E-9);
    }

    @Test
    public void testGetTransformFromA1toA2Random() {
        DMatrixRMaj matrix = new DMatrixRMaj(4, 4);
        Random random = new Random(111L);
        this.createRandomTransformationMatrix(matrix, random);
        RigidBodyTransform transformFromWorldToA1 = new RigidBodyTransform((DMatrix)matrix);
        this.createRandomTransformationMatrix(matrix, random);
        RigidBodyTransform transformFromWorldToA2 = new RigidBodyTransform((DMatrix)matrix);
        ReferenceFrame a1 = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)"a1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transformFromWorldToA1);
        ReferenceFrame a2 = ReferenceFrameTools.constructFrameWithUnchangingTransformFromParent((String)"a2", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)transformFromWorldToA2);
        RigidBodyTransform transformA2toA1 = TransformTools.getTransformFromA2toA1((RigidBodyTransform)transformFromWorldToA1, (RigidBodyTransform)transformFromWorldToA2);
        Point3D a2Origin = new Point3D();
        transformA2toA1.transform((Point3DBasics)a2Origin);
        FramePoint3D a2OriginFramePoint = new FramePoint3D(a2);
        a2OriginFramePoint.changeFrame(a1);
        a2Origin.epsilonEquals((EuclidGeometry)a2OriginFramePoint, 1.0E-9);
    }

    @Test
    public void testgetTransformDifference() {
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        Random random = new Random();
        int numberOfTests = 1000;
        for (int i = 0; i < numberOfTests; ++i) {
            double angle = -Math.PI + Math.PI * 2 * random.nextDouble();
            Vector3D vector3d = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
            vector3d.normalize();
            AxisAngle axisAngle = new AxisAngle((Vector3DReadOnly)vector3d, angle);
            double vectorScale = 10.0;
            Vector3D vector3dTranlation = new Vector3D(-vectorScale + 2.0 * vectorScale * random.nextDouble(), -vectorScale + 2.0 * vectorScale * random.nextDouble(), -vectorScale + 2.0 * vectorScale * random.nextDouble());
            rigidBodyTransform.set((Orientation3DReadOnly)axisAngle, (Tuple3DReadOnly)vector3dTranlation);
            double angleFromTransform = TransformTools.getMagnitudeOfAngleOfRotation((RigidBodyTransform)rigidBodyTransform);
            Assert.assertEquals(Math.abs(angle), angleFromTransform, 1.0E-9);
            double translation = TransformTools.getMagnitudeOfTranslation((RigidBodyTransform)rigidBodyTransform);
            Assert.assertEquals(vector3dTranlation.length(), translation, 1.0E-9);
            double radiusOfRotation = random.nextDouble();
            double magnitudeOfTransform = TransformTools.getSizeOfTransformWithRotationScaled((RigidBodyTransform)rigidBodyTransform, (double)radiusOfRotation);
            Assert.assertEquals(vector3dTranlation.length() + Math.abs(angle) * radiusOfRotation, magnitudeOfTransform, 1.0E-9);
        }
    }

    @Test
    public void testgetTransformDifferenceBetweenTwoTransforms() {
        Random random = new Random();
        int numberOfTests = 1000;
        for (int i = 0; i < numberOfTests; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(4, 4);
            this.createRandomTransformationMatrix(matrix, random);
            RigidBodyTransform transformFromWorldToA1 = new RigidBodyTransform((DMatrix)matrix);
            this.createRandomTransformationMatrix(matrix, random);
            RigidBodyTransform transformFromWorldToA2 = new RigidBodyTransform((DMatrix)matrix);
            double radiusOfRotation = random.nextDouble();
            double magnitudeOfTransform1 = TransformTools.getSizeOfTransformBetweenTwoWithRotationScaled((RigidBodyTransform)transformFromWorldToA1, (RigidBodyTransform)transformFromWorldToA2, (double)radiusOfRotation);
            RigidBodyTransform transformA2toA1 = TransformTools.getTransformFromA2toA1((RigidBodyTransform)transformFromWorldToA1, (RigidBodyTransform)transformFromWorldToA2);
            double magnitudeOfTransform2 = TransformTools.getSizeOfTransformWithRotationScaled((RigidBodyTransform)transformA2toA1, (double)radiusOfRotation);
            Assert.assertEquals(magnitudeOfTransform1, magnitudeOfTransform2, 1.0E-9);
        }
    }

    private void createRandomTransformationMatrix(DMatrixRMaj matrix, Random random) {
        RotationMatrix rotX = new RotationMatrix();
        RotationMatrix rotY = new RotationMatrix();
        RotationMatrix rotZ = new RotationMatrix();
        Vector3D trans = new Vector3D();
        this.randomizeVector(random, trans);
        this.createRandomRotationMatrixX(random, rotX);
        this.createRandomRotationMatrixY(random, rotY);
        this.createRandomRotationMatrixZ(random, rotZ);
        rotX.multiply((RotationMatrixReadOnly)rotY);
        rotX.multiply((RotationMatrixReadOnly)rotZ);
        matrix.set(0, 0, rotX.getM00());
        matrix.set(0, 1, rotX.getM01());
        matrix.set(0, 2, rotX.getM02());
        matrix.set(0, 3, trans.getX());
        matrix.set(1, 0, rotX.getM10());
        matrix.set(1, 1, rotX.getM11());
        matrix.set(1, 2, rotX.getM12());
        matrix.set(1, 3, trans.getY());
        matrix.set(2, 0, rotX.getM20());
        matrix.set(2, 1, rotX.getM21());
        matrix.set(2, 2, rotX.getM22());
        matrix.set(2, 3, trans.getZ());
        matrix.set(3, 0, 0.0);
        matrix.set(3, 1, 0.0);
        matrix.set(3, 2, 0.0);
        matrix.set(3, 3, 1.0);
    }

    private void createRandomRotationMatrixX(Random random, RotationMatrix matrix) {
        double theta = random.nextDouble();
        matrix.setToRollOrientation(theta);
    }

    private void createRandomRotationMatrixY(Random random, RotationMatrix matrix) {
        double theta = random.nextDouble();
        matrix.setToPitchOrientation(theta);
    }

    private void createRandomRotationMatrixZ(Random random, RotationMatrix matrix) {
        double theta = random.nextDouble();
        matrix.setToYawOrientation(theta);
    }

    private void randomizeVector(Random random, Vector3D vector) {
        vector.setX(random.nextDouble());
        vector.setY(random.nextDouble());
        vector.setZ(random.nextDouble());
    }
}

