/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTestTools;

public class PlanarRegionTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testIntersections() {
        ArrayList<ConvexPolygon2D> polygonsRegion1 = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon11 = new ConvexPolygon2D();
        polygon11.addVertex(0.0, 0.0);
        polygon11.addVertex(2.0, 0.0);
        polygon11.addVertex(2.0, 0.5);
        polygon11.addVertex(0.0, 0.5);
        polygon11.update();
        polygonsRegion1.add(polygon11);
        ConvexPolygon2D polygon12 = new ConvexPolygon2D();
        polygon12.addVertex(1.0, 0.0);
        polygon12.addVertex(2.0, 0.0);
        polygon12.addVertex(2.0, -1.5);
        polygon12.addVertex(1.0, -1.5);
        polygon12.update();
        polygonsRegion1.add(polygon12);
        RigidBodyTransform transform1 = new RigidBodyTransform();
        PlanarRegion region1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, polygonsRegion1);
        ArrayList<ConvexPolygon2D> polygonsRegion2 = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon21 = new ConvexPolygon2D();
        polygon21.addVertex(-1.0, 0.1);
        polygon21.addVertex(1.0, 0.1);
        polygon21.addVertex(1.0, -0.1);
        polygon21.addVertex(-1.0, -0.1);
        polygon21.update();
        polygonsRegion2.add(polygon21);
        ConvexPolygon2D polygon22 = new ConvexPolygon2D();
        polygon22.addVertex(1.5, 0.1);
        polygon22.addVertex(2.0, 0.1);
        polygon22.addVertex(2.0, -0.1);
        polygon22.addVertex(1.5, -0.1);
        polygon22.update();
        polygonsRegion2.add(polygon22);
        RigidBodyTransform transform2 = new RigidBodyTransform();
        transform2.getTranslation().set(0.5, 0.0, 0.0);
        transform2.appendYawRotation(-0.7853981633974483);
        transform2.appendRollRotation(1.5707963267948966);
        PlanarRegion region2 = new PlanarRegion((RigidBodyTransformReadOnly)transform2, polygonsRegion2);
        List intersections = region1.intersect(region2);
        ArrayList<LineSegment3D> expectedIntersections = new ArrayList<LineSegment3D>();
        expectedIntersections.add(new LineSegment3D((Point3DReadOnly)new Point3D(0.0, 0.5, 0.0), (Point3DReadOnly)new Point3D(0.5, 0.0, 0.0)));
        expectedIntersections.add(new LineSegment3D((Point3DReadOnly)new Point3D(1.0, -0.5, 0.0), (Point3DReadOnly)new Point3D(0.5 + 1.0 / Math.sqrt(2.0), -1.0 / Math.sqrt(2.0), 0.0)));
        expectedIntersections.add(new LineSegment3D((Point3DReadOnly)new Point3D(0.5 + 1.5 / Math.sqrt(2.0), -1.5 / Math.sqrt(2.0), 0.0), (Point3DReadOnly)new Point3D(0.5 + 2.0 / Math.sqrt(2.0), -2.0 / Math.sqrt(2.0), 0.0)));
        Assert.assertEquals(expectedIntersections.size(), intersections.size());
        for (LineSegment3D intersection : intersections) {
            boolean foundMatch = false;
            for (LineSegment3D expectedIntersection : expectedIntersections) {
                if (intersection.getDirection(false).dot((Tuple3DReadOnly)expectedIntersection.getDirection(false)) < 0.0) {
                    expectedIntersection.flipDirection();
                }
                if (!intersection.epsilonEquals((EuclidGeometry)expectedIntersection, 1.0E-10)) continue;
                foundMatch = true;
            }
            Assert.assertTrue(foundMatch);
        }
    }

    @Test
    public void testIsPointInWorld2DInside() {
        Random random = new Random(1776L);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        Point3D regionTranslation = new Point3D();
        Point3D pointAbove = new Point3D();
        Point3D pointBelow = new Point3D();
        Vector3D regionNormal = new Vector3D();
        for (int i = 0; i < 10000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)1, (double)10.0, (int)5);
            planarRegion.getTransformToWorld(transformToWorld);
            Point2DReadOnly centroid = planarRegion.getLastConvexPolygon().getCentroid();
            regionTranslation.set(centroid.getX(), centroid.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)regionTranslation);
            regionTranslation.setZ(planarRegion.getPlaneZGivenXY(regionTranslation.getX(), regionTranslation.getY()));
            planarRegion.getNormal((Vector3DBasics)regionNormal);
            regionNormal.normalize();
            regionNormal.scale(1.0E-6);
            pointAbove.add((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            pointBelow.sub((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            Assertions.assertTrue((boolean)planarRegion.isPointInWorld2DInside((Point3DReadOnly)pointAbove));
            Assertions.assertTrue((boolean)planarRegion.isPointInWorld2DInside((Point3DReadOnly)pointBelow));
        }
    }

    @Test
    public void testIsPointOn() {
        Random random = new Random(1776L);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        Point3D regionTranslation = new Point3D();
        Point3D pointAbove = new Point3D();
        Point3D pointBelow = new Point3D();
        Vector3D regionNormal = new Vector3D();
        for (int i = 0; i < 10000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)1, (double)10.0, (int)5);
            planarRegion.getTransformToWorld(transformToWorld);
            Point2DReadOnly centroid = planarRegion.getLastConvexPolygon().getCentroid();
            regionTranslation.set(centroid.getX(), centroid.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)regionTranslation);
            regionTranslation.setZ(planarRegion.getPlaneZGivenXY(regionTranslation.getX(), regionTranslation.getY()));
            planarRegion.getNormal((Vector3DBasics)regionNormal);
            regionNormal.normalize();
            regionNormal.scale(1.0E-6);
            pointAbove.add((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            pointBelow.sub((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            Assertions.assertTrue((boolean)planarRegion.isPointOnOrSlightlyAbove((Point3DReadOnly)pointAbove, 1.0E-5));
            Assertions.assertFalse((boolean)planarRegion.isPointOnOrSlightlyAbove((Point3DReadOnly)pointBelow, 1.0E-5));
        }
    }

    @Test
    public void testIsPointOnOrSlightlyBelow() {
        Random random = new Random(1776L);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        Point3D regionTranslation = new Point3D();
        Point3D pointAbove = new Point3D();
        Point3D pointBelow = new Point3D();
        Vector3D regionNormal = new Vector3D();
        for (int i = 0; i < 10000; ++i) {
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)1, (double)10.0, (int)5);
            planarRegion.getTransformToWorld(transformToWorld);
            Point2DReadOnly centroid = planarRegion.getLastConvexPolygon().getCentroid();
            regionTranslation.set(centroid.getX(), centroid.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)regionTranslation);
            regionTranslation.setZ(planarRegion.getPlaneZGivenXY(regionTranslation.getX(), regionTranslation.getY()));
            planarRegion.getNormal((Vector3DBasics)regionNormal);
            regionNormal.normalize();
            regionNormal.scale(1.0E-6);
            pointAbove.add((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            pointBelow.sub((Tuple3DReadOnly)regionTranslation, (Tuple3DReadOnly)regionNormal);
            Assertions.assertTrue((boolean)planarRegion.isPointOnOrSlightlyBelow((Point3DReadOnly)pointBelow, 1.0E-5));
            Assertions.assertFalse((boolean)planarRegion.isPointOnOrSlightlyBelow((Point3DReadOnly)pointAbove, 1.0E-5));
        }
    }

    @Test
    public void testCreationOfBoundingBoxWithAllPointsGreaterThanOrigin() {
        double zLocationOfPlanarRegion = 2.0;
        Point3D minPoint = new Point3D(1.0, 1.0, 2.0);
        Point3D maxPoint = new Point3D(2.0, 2.0, 2.0);
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(minPoint.getX(), minPoint.getY());
        polygon1.addVertex(maxPoint.getX(), minPoint.getY());
        polygon1.addVertex(minPoint.getX(), maxPoint.getY());
        polygon1.addVertex(maxPoint.getX(), maxPoint.getY());
        regionConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        regionTransform.appendTranslation(0.0, 0.0, 2.0);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        planarRegion.getTransformToWorld(transformToWorld);
        this.assertThatAllPolygonVerticesAreInBoundingBox(regionConvexPolygons, planarRegion, boundingBox3dInWorld);
        Assertions.assertEquals((Object)minPoint, (Object)boundingBox3dInWorld.getMinPoint());
        Assertions.assertEquals((Object)maxPoint, (Object)boundingBox3dInWorld.getMaxPoint());
    }

    @Test
    public void testCreationOfBoundingBoxWithAllPointsLessThanOrigin() {
        double zLocationOfPlanarRegion = -2.0;
        Point3D maxPoint = new Point3D(-1.0, -1.0, -2.0);
        Point3D minPoint = new Point3D(-2.0, -2.0, -2.0);
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(minPoint.getX(), minPoint.getY());
        polygon1.addVertex(maxPoint.getX(), minPoint.getY());
        polygon1.addVertex(minPoint.getX(), maxPoint.getY());
        polygon1.addVertex(maxPoint.getX(), maxPoint.getY());
        regionConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        regionTransform.appendTranslation(0.0, 0.0, -2.0);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        planarRegion.getTransformToWorld(transformToWorld);
        this.assertThatAllPolygonVerticesAreInBoundingBox(regionConvexPolygons, planarRegion, boundingBox3dInWorld);
        Assertions.assertEquals((Object)minPoint, (Object)boundingBox3dInWorld.getMinPoint());
        Assertions.assertEquals((Object)maxPoint, (Object)boundingBox3dInWorld.getMaxPoint());
    }

    @Test
    public void testCreationOfBoundingBoxWithMinimumLessThanOriginAndMaximumGreaterThanOrigin() {
        Point3D maxPoint = new Point3D(2.0, 2.0, 0.0);
        Point3D minPoint = new Point3D(-2.0, -2.0, 0.0);
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(minPoint.getX(), minPoint.getY());
        polygon1.addVertex(maxPoint.getX(), minPoint.getY());
        polygon1.addVertex(minPoint.getX(), maxPoint.getY());
        polygon1.addVertex(maxPoint.getX(), maxPoint.getY());
        regionConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        planarRegion.getTransformToWorld(transformToWorld);
        this.assertThatAllPolygonVerticesAreInBoundingBox(regionConvexPolygons, planarRegion, boundingBox3dInWorld);
        Assertions.assertEquals((Object)minPoint, (Object)boundingBox3dInWorld.getMinPoint());
        Assertions.assertEquals((Object)maxPoint, (Object)boundingBox3dInWorld.getMaxPoint());
    }

    @Test
    public void testBoundingBoxForLShapedPlanarRegionWithIdentifyTransform() {
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(-1.0, 1.0);
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(3.0, 1.0);
        polygon2.addVertex(3.0, -1.0);
        polygon2.addVertex(1.0, -1.0);
        polygon2.addVertex(1.0, 1.0);
        ConvexPolygon2D polygon3 = new ConvexPolygon2D();
        polygon3.addVertex(1.0, 3.0);
        polygon3.addVertex(1.0, 1.0);
        polygon3.addVertex(-1.0, 1.0);
        polygon3.addVertex(-1.0, 3.0);
        regionConvexPolygons.add(polygon1);
        regionConvexPolygons.add(polygon2);
        regionConvexPolygons.add(polygon3);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        planarRegion.getTransformToWorld(transformToWorld);
        this.assertThatAllPolygonVerticesAreInBoundingBox(regionConvexPolygons, planarRegion, boundingBox3dInWorld);
    }

    @Test
    public void testGetPolygonIntersectionsWhenSnapped() {
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.setRotationEulerAndZeroTranslation(0.1, 0.2, 0.3);
        transform.getTranslation().set(1.2, 3.4, 5.6);
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(0.2, 0.2);
        convexPolygon.addVertex(0.2, -0.2);
        convexPolygon.addVertex(-0.2, -0.2);
        convexPolygon.addVertex(-0.2, 0.2);
        convexPolygon.update();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)convexPolygon);
        ConvexPolygon2D polygonToSnap = new ConvexPolygon2D();
        polygonToSnap.addVertex(0.1, 0.1);
        polygonToSnap.addVertex(0.1, -0.1);
        polygonToSnap.addVertex(-0.1, -0.1);
        polygonToSnap.addVertex(-0.1, 0.1);
        polygonToSnap.update();
        RigidBodyTransform snappingTransform = new RigidBodyTransform();
        snappingTransform.setRotationEulerAndZeroTranslation(0.1, 0.2, 0.3);
        snappingTransform.getTranslation().set(1.2, 3.4, 5.6);
        double intersectionArea = planarRegion.getPolygonIntersectionAreaWhenSnapped(polygonToSnap, snappingTransform);
        Assertions.assertEquals((double)0.04, (double)intersectionArea, (double)1.0E-7);
    }

    @Test
    public void testWithLShapedPlanarRegionWithRandomTransform() {
        Random random = new Random(42L);
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(-1.0, 1.0);
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(3.0, 1.0);
        polygon2.addVertex(3.0, -1.0);
        polygon2.addVertex(1.0, -1.0);
        polygon2.addVertex(1.0, 1.0);
        ConvexPolygon2D polygon3 = new ConvexPolygon2D();
        polygon3.addVertex(1.0, 3.0);
        polygon3.addVertex(1.0, 1.0);
        polygon3.addVertex(-1.0, 1.0);
        polygon3.addVertex(-1.0, 3.0);
        regionConvexPolygons.add(polygon1);
        regionConvexPolygons.add(polygon2);
        regionConvexPolygons.add(polygon3);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        for (int iteration = 0; iteration < 10; ++iteration) {
            Quaternion orientation = EuclidCoreRandomTools.nextQuaternion((Random)random, (double)Math.toRadians(45.0));
            Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random, (double)10.0);
            RigidBodyTransform regionTransform = new RigidBodyTransform((Orientation3DReadOnly)orientation, (Tuple3DReadOnly)translation);
            ReferenceFrame localFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"local", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)regionTransform);
            PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
            Assertions.assertEquals((int)3, (int)planarRegion.getNumberOfConvexPolygons(), (String)"Wrong number of convex polygons in the region.");
            for (int i = 0; i < 3; ++i) {
                Assertions.assertTrue((boolean)((ConvexPolygon2D)regionConvexPolygons.get(i)).epsilonEquals((EuclidGeometry)planarRegion.getConvexPolygon(i), 1.0E-10), (String)"Unexpected region polygon.");
            }
            Vector3D expectedNormal = new Vector3D(0.0, 0.0, 1.0);
            regionTransform.transform((Vector3DBasics)expectedNormal);
            Vector3D actualNormal = new Vector3D();
            planarRegion.getNormal((Vector3DBasics)actualNormal);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((String)"Wrong region normal.", (Vector3DReadOnly)expectedNormal, (Vector3DReadOnly)actualNormal, (double)1.0E-10);
            Point3D expectedOrigin = new Point3D();
            regionTransform.transform((Point3DBasics)expectedOrigin);
            Point3D actualOrigin = new Point3D();
            planarRegion.getPointInRegion((Point3DBasics)actualOrigin);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)"Wrong region origin.", (Point3DReadOnly)expectedOrigin, (Point3DReadOnly)actualOrigin, (double)1.0E-10);
            RigidBodyTransform actualTransform = new RigidBodyTransform();
            planarRegion.getTransformToWorld(actualTransform);
            Assertions.assertTrue((boolean)regionTransform.epsilonEquals((EuclidGeometry)actualTransform, 1.0E-10), (String)"Wrong region transform to world.");
            FramePoint2D point2d = new FramePoint2D();
            point2d.setIncludingFrame(localFrame, 0.0, 0.0);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 2.0, 0.0);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 0.0, 2.0);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 2.0, 2.0);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
            FramePoint3D point3d = new FramePoint3D();
            double maximumOrthogonalDistance = 0.001;
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, 0.0);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, 0.0);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, 0.0);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 2.0, 0.0);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, -0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, -0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, -0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, -1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, -1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, -1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, 0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, 0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, 0.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, 1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, 1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, 1.5 * maximumOrthogonalDistance);
            point3d.changeFrame(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
            point2d.setIncludingFrame(localFrame, 0.0, 0.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(point2d.getX(), point2d.getY()));
            point2d.setIncludingFrame(localFrame, 2.0, 0.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(point2d.getX(), point2d.getY()));
            point2d.setIncludingFrame(localFrame, 0.0, 2.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(point2d.getX(), point2d.getY()));
            point2d.setIncludingFrame(localFrame, 2.0, 2.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(point2d.getX(), point2d.getY()));
            point2d.setIncludingFrame(localFrame, 0.0, 0.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 2.0, 0.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 0.0, 2.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
            point2d.setIncludingFrame(localFrame, 2.0, 2.0);
            point2d.changeFrameAndProjectToXYPlane(worldFrame);
            Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
            point3d.setIncludingFrame(localFrame, 0.0, 0.0, 0.0);
            point3d.changeFrame(worldFrame);
            point3d.setZ(Double.POSITIVE_INFINITY);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
            point3d.setIncludingFrame(localFrame, 2.0, 0.0, 0.0);
            point3d.changeFrame(worldFrame);
            point3d.setZ(Double.POSITIVE_INFINITY);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
            point3d.setIncludingFrame(localFrame, 0.0, 2.0, 0.0);
            point3d.changeFrame(worldFrame);
            point3d.setZ(Double.POSITIVE_INFINITY);
            Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
            point3d.setIncludingFrame(localFrame, 2.0, 2.0, 0.0);
            point3d.changeFrame(worldFrame);
            point3d.setZ(Double.POSITIVE_INFINITY);
            Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
            ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
            convexPolygon.addVertex(0.2, 0.2);
            convexPolygon.addVertex(0.2, -0.2);
            convexPolygon.addVertex(-0.2, -0.2);
            convexPolygon.addVertex(-0.2, 0.2);
            convexPolygon.update();
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)convexPolygon)));
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(2.0, 0.0, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(0.0, 2.0, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertFalse((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(2.0, 2.0, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertFalse((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(1.21, 1.21, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(1.09, 1.09, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(1.21, 1.09, (ConvexPolygon2DReadOnly)convexPolygon))));
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionTest.transformConvexPolygon(regionTransform, (ConvexPolygon2DReadOnly)PlanarRegionTest.translateConvexPolygon(1.09, 1.21, (ConvexPolygon2DReadOnly)convexPolygon))));
            BoundingBox3D boundingBox3dInWorld = planarRegion.getBoundingBox3dInWorld();
            RigidBodyTransform transformToWorld = new RigidBodyTransform();
            planarRegion.getTransformToWorld(transformToWorld);
            for (ConvexPolygon2D convexPolygon2d : regionConvexPolygons) {
                ConvexPolygon2D convexPolygon2dInWorld = new ConvexPolygon2D((Vertex2DSupplier)convexPolygon2d);
                convexPolygon2dInWorld.applyTransform((Transform)transformToWorld, false);
                for (int i = 0; i < convexPolygon2dInWorld.getNumberOfVertices(); ++i) {
                    Point2DReadOnly vertex = convexPolygon2dInWorld.getVertex(i);
                    double planeZGivenXY = planarRegion.getPlaneZGivenXY(vertex.getX(), vertex.getY());
                    Assertions.assertTrue((boolean)boundingBox3dInWorld.isInsideEpsilon(vertex.getX(), vertex.getY(), planeZGivenXY, 1.0E-15), (String)("Polygon vertex is not inside computed bounding box.\nVertex: " + vertex + "\nPlane z at vertex: " + planeZGivenXY + "\nBounding Box: " + boundingBox3dInWorld));
                }
            }
        }
    }

    @Test
    public void testGetPlaneZGivenXY() {
        ConvexPolygon2D convexPolygon2d = new ConvexPolygon2D();
        convexPolygon2d.addVertex(1.0, 1.0);
        convexPolygon2d.addVertex(-1.0, 1.0);
        convexPolygon2d.addVertex(-1.0, -1.0);
        convexPolygon2d.addVertex(1.0, -1.0);
        convexPolygon2d.update();
        ArrayList<ConvexPolygon2D> polygonList = new ArrayList<ConvexPolygon2D>();
        polygonList.add(convexPolygon2d);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        double xWorld = 0.0;
        double yWorld = 0.0;
        double planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        Assertions.assertEquals((double)0.0, (double)planeZGivenXY, (double)1.0E-7);
        transformToWorld.getTranslation().set(1.0, 2.0, 3.0);
        planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        Assertions.assertEquals((double)3.0, (double)planeZGivenXY, (double)1.0E-7);
        double angle = 0.7853981633974483;
        transformToWorld.setRotationEulerAndZeroTranslation(0.0, angle, 0.0);
        planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        xWorld = 1.3;
        planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        Assertions.assertEquals((double)(-xWorld * Math.tan(angle)), (double)planeZGivenXY, (double)1.0E-7);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), 1.0E-7));
        angle = 1.5697963267948967;
        transformToWorld.setRotationEulerAndZeroTranslation(0.0, angle, 0.0);
        planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        xWorld = 1.3;
        planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        Assertions.assertEquals((double)(-xWorld * Math.tan(angle)), (double)planeZGivenXY, (double)1.0E-7);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), 1.0E-7));
        angle = 1.4707963267948965;
        transformToWorld.setRotationEulerAndZeroTranslation(0.0, angle, 0.0);
        planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        xWorld = 1.3;
        planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        double tangent = Math.tan(angle);
        boolean planeZGivenXYIsNaN = Double.isNaN(planeZGivenXY);
        boolean valueMatchesComputed = Math.abs(planeZGivenXY - -tangent * xWorld) < 1.0E-7;
        Assertions.assertFalse((boolean)planeZGivenXYIsNaN);
        Assertions.assertTrue((boolean)valueMatchesComputed);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), 1.0E-7));
        transformToWorld.set(new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
        planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        xWorld = 1.3;
        planeZGivenXY = planarRegion.getPlaneZGivenXY(xWorld, yWorld);
        planeZGivenXYIsNaN = Double.isNaN(planeZGivenXY);
        valueMatchesComputed = Math.abs(planeZGivenXY - -tangent * xWorld) < 1.0E-7;
        Assertions.assertTrue((boolean)planeZGivenXYIsNaN);
        Assertions.assertFalse((boolean)valueMatchesComputed);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), 1.0E-7));
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)new Point3D(0.0, 0.0, 0.5), 1.0E-7));
    }

    @Test
    public void testCopy() {
        Random random = new Random(1738L);
        for (int i = 0; i < 10000; ++i) {
            PlanarRegion planarRegion1 = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)1, (double)5.0, (int)8);
            PlanarRegionTestTools.assertPlanarRegionsGeometricallyEqual(planarRegion1, planarRegion1.copy(), 1.0E-8);
        }
    }

    @Test
    public void testGetSupportingVertex() {
        Random random = new Random(3290L);
        ConvexPolygon2D convexPolygon2d = new ConvexPolygon2D();
        convexPolygon2d.addVertex(1.0, 1.0);
        convexPolygon2d.addVertex(-1.0, 1.0);
        convexPolygon2d.addVertex(-1.0, -1.0);
        convexPolygon2d.addVertex(1.0, -1.0);
        convexPolygon2d.update();
        ArrayList<ConvexPolygon2D> polygonList = new ArrayList<ConvexPolygon2D>();
        polygonList.add(convexPolygon2d);
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, polygonList);
        Assertions.assertTrue((boolean)planarRegion.getSupportingVertex((Vector3DReadOnly)new Vector3D(1.0, 1.0, 0.0)).epsilonEquals((EuclidGeometry)new Point3D(1.0, 1.0, 0.0), 1.0E-10));
        Assertions.assertTrue((boolean)planarRegion.getSupportingVertex((Vector3DReadOnly)new Vector3D(-1.0, 1.0, 0.0)).epsilonEquals((EuclidGeometry)new Point3D(-1.0, 1.0, 0.0), 1.0E-10));
        Assertions.assertTrue((boolean)planarRegion.getSupportingVertex((Vector3DReadOnly)new Vector3D(-1.0, -1.0, 0.0)).epsilonEquals((EuclidGeometry)new Point3D(-1.0, -1.0, 0.0), 1.0E-10));
        Assertions.assertTrue((boolean)planarRegion.getSupportingVertex((Vector3DReadOnly)new Vector3D(1.0, -1.0, 0.0)).epsilonEquals((EuclidGeometry)new Point3D(1.0, -1.0, 0.0), 1.0E-10));
        for (int i = 0; i < 10000; ++i) {
            planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)1, (double)5.0, (int)8);
            planarRegion.getTransformToWorld(transformToWorld);
            List convexHullVertices = planarRegion.getConvexHull().getPolygonVerticesView().stream().map(Point3D::new).peek(arg_0 -> ((RigidBodyTransform)transformToWorld).transform(arg_0)).collect(Collectors.toList());
            Vector3D supportDirection = new Vector3D();
            supportDirection.set((Tuple3DReadOnly)Axis3D.X);
            Point3DReadOnly expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().max(Comparator.comparingDouble(Point3D::getX)).get();
            Point3DReadOnly actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.X);
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().min(Comparator.comparingDouble(Point3D::getX)).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Y);
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().max(Comparator.comparingDouble(Point3D::getY)).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.Y);
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().min(Comparator.comparingDouble(Point3D::getY)).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.set((Tuple3DReadOnly)Axis3D.Z);
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().max(Comparator.comparingDouble(Point3D::getZ)).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection.setAndNegate((Tuple3DReadOnly)Axis3D.Z);
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().min(Comparator.comparingDouble(Point3D::getZ)).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
            supportDirection = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D orthogonalDirection = new Vector3D();
            Vector3D supportDirectionInPlane = new Vector3D();
            orthogonalDirection.cross((Tuple3DReadOnly)planarRegion.getNormal(), (Tuple3DReadOnly)supportDirection);
            supportDirectionInPlane.cross((Tuple3DReadOnly)orthogonalDirection, (Tuple3DReadOnly)planarRegion.getNormal());
            supportDirectionInPlane.normalize();
            supportDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0));
            Line3D line = new Line3D();
            line.getDirection().set((Tuple3DReadOnly)orthogonalDirection);
            line.translate(20.0 * supportDirectionInPlane.getX(), 20.0 * supportDirectionInPlane.getY(), 20.0 * supportDirectionInPlane.getZ());
            expectedSupportVertex = (Point3DReadOnly)convexHullVertices.stream().min(Comparator.comparingDouble(arg_0 -> ((Line3D)line).distance(arg_0))).get();
            actualSupportVertex = planarRegion.getSupportingVertex((Vector3DReadOnly)supportDirection);
            Assertions.assertTrue((boolean)expectedSupportVertex.equals((EuclidGeometry)actualSupportVertex), (String)("iteration #" + i + " expected:\n" + expectedSupportVertex + "was:\n" + actualSupportVertex));
        }
    }

    @Test
    public void testConcaveHullGeneration() {
        int i;
        ConvexPolygon2D convexPolygon0 = new ConvexPolygon2D();
        convexPolygon0.addVertex(0.0, 0.0);
        convexPolygon0.addVertex(1.0, 1.0);
        convexPolygon0.addVertex(1.0, -1.0);
        convexPolygon0.update();
        ConvexPolygon2D convexPolygon1 = new ConvexPolygon2D();
        convexPolygon1.addVertex(0.0, 0.0);
        convexPolygon1.addVertex(-1.1, 1.0);
        convexPolygon1.addVertex(-1.0, -1.0);
        convexPolygon1.update();
        ArrayList<ConvexPolygon2D> polygonList = new ArrayList<ConvexPolygon2D>();
        polygonList.add(convexPolygon0);
        polygonList.add(convexPolygon1);
        PlanarRegion twoTriangleRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        List concaveHull = twoTriangleRegion.getConcaveHull();
        Assertions.assertEquals((int)twoTriangleRegion.getConcaveHullSize(), (int)6);
        double epsilon = 1.0E-10;
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(0)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(0), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(1)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(1), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(2)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(1), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(3)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(2), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(4)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(0), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(5)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(2), epsilon));
        ConvexPolygon2D convexPolygon2 = new ConvexPolygon2D();
        convexPolygon2.addVertex(0.0, 0.0);
        convexPolygon2.addVertex(1.0, -1.0);
        convexPolygon2.addVertex(-1.0, -1.0);
        convexPolygon2.update();
        polygonList.add(convexPolygon2);
        PlanarRegion threeTriangleRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        concaveHull = threeTriangleRegion.getConcaveHull();
        Assertions.assertEquals((int)threeTriangleRegion.getConcaveHullSize(), (int)5);
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(0)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(0), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(1)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(1), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(2)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(1), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(3)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(2), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(4)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(2), epsilon));
        ConvexPolygon2D convexPolygon3 = new ConvexPolygon2D();
        convexPolygon3.addVertex(0.0, 0.0);
        convexPolygon3.addVertex(-1.1, 1.0);
        convexPolygon3.addVertex(1.0, 1.0);
        convexPolygon3.update();
        polygonList.add(convexPolygon3);
        PlanarRegion fourTriangleRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        concaveHull = fourTriangleRegion.getConcaveHull();
        Assertions.assertEquals((int)fourTriangleRegion.getConcaveHullSize(), (int)4);
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(0)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(0), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(1)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(1), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(2)).epsilonEquals((EuclidGeometry)convexPolygon0.getVertex(2), epsilon));
        Assertions.assertTrue((boolean)((Point2DReadOnly)concaveHull.get(3)).epsilonEquals((EuclidGeometry)convexPolygon1.getVertex(2), epsilon));
        Random random = new Random(12390L);
        int numberOfPoints = 3600;
        double minRadius = 0.1;
        double maxRadius = 2.0;
        double centerX = 0.2;
        double centerY = -1.3;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D(-2.01 + centerX, 0.0 + centerY));
        for (i = 1; i < numberOfPoints; ++i) {
            double radius = EuclidCoreRandomTools.nextDouble((Random)random, (double)minRadius, (double)maxRadius);
            double theta = Math.PI - Math.PI * 2 * (double)i / (double)numberOfPoints;
            double px = centerX + radius * Math.cos(theta);
            double py = centerY + radius * Math.sin(theta);
            points.add(new Point2D(px, py));
        }
        polygonList.clear();
        for (i = 0; i < numberOfPoints; ++i) {
            ConvexPolygon2D triangle = new ConvexPolygon2D();
            triangle.addVertex((Point2DReadOnly)new Point2D(centerX, centerY));
            triangle.addVertex((Point2DReadOnly)points.get(i));
            triangle.addVertex((Point2DReadOnly)points.get((i + 1) % numberOfPoints));
            triangle.update();
            polygonList.add(triangle);
        }
        PlanarRegion region = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        concaveHull = region.getConcaveHull();
        Assertions.assertEquals((int)concaveHull.size(), (int)points.size());
        for (int i2 = 0; i2 < points.size(); ++i2) {
            Assertions.assertTrue((boolean)((Point2D)points.get(i2)).epsilonEquals((EuclidGeometry)concaveHull.get(i2), epsilon));
        }
        ConvexPolygon2D unitSquare = new ConvexPolygon2D();
        unitSquare.addVertex(-0.5, -0.5);
        unitSquare.addVertex(-0.5, 0.5);
        unitSquare.addVertex(0.5, 0.5);
        unitSquare.addVertex(0.5, -0.5);
        unitSquare.update();
        ConvexPolygon2D bottomLeftSquare = new ConvexPolygon2D();
        bottomLeftSquare.addVertex(-0.6, -0.5);
        bottomLeftSquare.addVertex(-0.5, 0.5);
        bottomLeftSquare.addVertex(0.5, 0.5);
        bottomLeftSquare.addVertex(0.5, -0.5);
        bottomLeftSquare.update();
        polygonList.clear();
        for (int i3 = -1; i3 <= 1; ++i3) {
            for (int j = -1; j <= 1; ++j) {
                ConvexPolygon2D polygon = i3 == -1 && j == -1 ? bottomLeftSquare : unitSquare;
                polygonList.add(new ConvexPolygon2D((Vertex2DSupplier)PlanarRegionTest.translateConvexPolygon(i3, j, (ConvexPolygon2DReadOnly)polygon)));
            }
        }
        region = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        Assertions.assertEquals((int)region.getConcaveHullSize(), (int)12);
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(0)).epsilonEquals((EuclidGeometry)new Point2D(-1.6, -1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(1)).epsilonEquals((EuclidGeometry)new Point2D(-1.5, -0.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(2)).epsilonEquals((EuclidGeometry)new Point2D(-1.5, 0.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(3)).epsilonEquals((EuclidGeometry)new Point2D(-1.5, 1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(4)).epsilonEquals((EuclidGeometry)new Point2D(-0.5, 1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(5)).epsilonEquals((EuclidGeometry)new Point2D(0.5, 1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(6)).epsilonEquals((EuclidGeometry)new Point2D(1.5, 1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(7)).epsilonEquals((EuclidGeometry)new Point2D(1.5, 0.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(8)).epsilonEquals((EuclidGeometry)new Point2D(1.5, -0.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(9)).epsilonEquals((EuclidGeometry)new Point2D(1.5, -1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(10)).epsilonEquals((EuclidGeometry)new Point2D(0.5, -1.5), epsilon));
        Assertions.assertTrue((boolean)((Point2D)region.getConcaveHull().get(11)).epsilonEquals((EuclidGeometry)new Point2D(-0.5, -1.5), epsilon));
        convexPolygon0 = new ConvexPolygon2D();
        convexPolygon1 = new ConvexPolygon2D();
        convexPolygon2 = new ConvexPolygon2D();
        convexPolygon3 = new ConvexPolygon2D();
        ConvexPolygon2D convexPolygon4 = new ConvexPolygon2D();
        ConvexPolygon2D convexPolygon5 = new ConvexPolygon2D();
        ConvexPolygon2D convexPolygon6 = new ConvexPolygon2D();
        convexPolygon0.addVertex(5.0, 9.0);
        convexPolygon0.addVertex(6.0, 8.0);
        convexPolygon0.addVertex(6.0, 10.0);
        convexPolygon0.addVertex(7.0, 10.0);
        convexPolygon0.addVertex(8.0, 8.0);
        convexPolygon0.addVertex(8.0, 9.0);
        convexPolygon1.addVertex(5.0, 9.0);
        convexPolygon1.addVertex(5.5, 6.0);
        convexPolygon1.addVertex(6.0, 8.0);
        convexPolygon2.addVertex(6.0, 4.0);
        convexPolygon2.addVertex(5.5, 6.0);
        convexPolygon2.addVertex(6.0, 8.0);
        convexPolygon2.addVertex(7.0, 2.0);
        convexPolygon2.addVertex(8.0, 1.0);
        convexPolygon2.addVertex(8.5, 4.0);
        convexPolygon2.addVertex(8.0, 8.0);
        convexPolygon3.addVertex(8.0, 1.0);
        convexPolygon3.addVertex(8.5, 4.0);
        convexPolygon3.addVertex(9.0, 2.0);
        convexPolygon3.addVertex(9.0, 6.0);
        convexPolygon4.addVertex(3.0, 4.0);
        convexPolygon4.addVertex(6.0, 4.0);
        convexPolygon4.addVertex(5.5, 6.0);
        convexPolygon5.addVertex(3.0, 4.0);
        convexPolygon5.addVertex(4.0, 3.0);
        convexPolygon5.addVertex(6.0, 4.0);
        convexPolygon6.addVertex(3.0, 4.0);
        convexPolygon6.addVertex(4.0, 0.0);
        convexPolygon6.addVertex(4.0, 3.0);
        convexPolygon0.update();
        convexPolygon1.update();
        convexPolygon2.update();
        convexPolygon3.update();
        convexPolygon4.update();
        convexPolygon5.update();
        convexPolygon6.update();
        polygonList.clear();
        polygonList.add(convexPolygon0);
        polygonList.add(convexPolygon1);
        polygonList.add(convexPolygon2);
        polygonList.add(convexPolygon3);
        polygonList.add(convexPolygon4);
        polygonList.add(convexPolygon5);
        polygonList.add(convexPolygon6);
        region = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), polygonList);
        Assertions.assertEquals((int)region.getConcaveHull().size(), (int)15);
        ((Point2D)region.getConcaveHull().get(0)).epsilonEquals((EuclidGeometry)new Point2D(3.0, 4.0), epsilon);
        ((Point2D)region.getConcaveHull().get(1)).epsilonEquals((EuclidGeometry)new Point2D(5.5, 6.0), epsilon);
        ((Point2D)region.getConcaveHull().get(2)).epsilonEquals((EuclidGeometry)new Point2D(5.0, 9.0), epsilon);
        ((Point2D)region.getConcaveHull().get(3)).epsilonEquals((EuclidGeometry)new Point2D(6.0, 10.0), epsilon);
        ((Point2D)region.getConcaveHull().get(4)).epsilonEquals((EuclidGeometry)new Point2D(7.0, 10.0), epsilon);
        ((Point2D)region.getConcaveHull().get(5)).epsilonEquals((EuclidGeometry)new Point2D(8.0, 9.0), epsilon);
        ((Point2D)region.getConcaveHull().get(6)).epsilonEquals((EuclidGeometry)new Point2D(8.0, 8.0), epsilon);
        ((Point2D)region.getConcaveHull().get(7)).epsilonEquals((EuclidGeometry)new Point2D(8.5, 4.0), epsilon);
        ((Point2D)region.getConcaveHull().get(8)).epsilonEquals((EuclidGeometry)new Point2D(9.0, 6.0), epsilon);
        ((Point2D)region.getConcaveHull().get(9)).epsilonEquals((EuclidGeometry)new Point2D(9.0, 2.0), epsilon);
        ((Point2D)region.getConcaveHull().get(10)).epsilonEquals((EuclidGeometry)new Point2D(8.0, 1.0), epsilon);
        ((Point2D)region.getConcaveHull().get(11)).epsilonEquals((EuclidGeometry)new Point2D(7.0, 2.0), epsilon);
        ((Point2D)region.getConcaveHull().get(12)).epsilonEquals((EuclidGeometry)new Point2D(6.0, 4.0), epsilon);
        ((Point2D)region.getConcaveHull().get(13)).epsilonEquals((EuclidGeometry)new Point2D(4.0, 3.0), epsilon);
        ((Point2D)region.getConcaveHull().get(14)).epsilonEquals((EuclidGeometry)new Point2D(4.0, 0.0), epsilon);
    }

    @Test
    public void testSplitUpConcaveHullThrowsError() {
        ConvexPolygon2D convexPolygon0 = new ConvexPolygon2D();
        convexPolygon0.addVertex(5.0, 5.0);
        convexPolygon0.addVertex(6.0, 6.0);
        convexPolygon0.addVertex(6.0, 4.0);
        convexPolygon0.update();
        ConvexPolygon2D convexPolygon1 = new ConvexPolygon2D();
        convexPolygon1.addVertex(0.0, 0.0);
        convexPolygon1.addVertex(-1.1, 1.0);
        convexPolygon1.addVertex(-1.0, -1.0);
        convexPolygon1.update();
        ArrayList<ConvexPolygon2D> polygonList = new ArrayList<ConvexPolygon2D>();
        polygonList.add(convexPolygon0);
        polygonList.add(convexPolygon1);
        Assertions.assertThrows(RuntimeException.class, () -> {
            PlanarRegion twoTriangleRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (List)polygonList);
            twoTriangleRegion.checkConcaveHullIsNotSeparated();
        });
    }

    static ConvexPolygon2DBasics translateConvexPolygon(double xTranslation, double yTranslation, ConvexPolygon2DReadOnly convexPolygon) {
        Vector2D translation = new Vector2D(xTranslation, yTranslation);
        return convexPolygon.translateCopy((Tuple2DReadOnly)translation);
    }

    private static ConvexPolygon2D transformConvexPolygon(RigidBodyTransform transform, ConvexPolygon2DReadOnly convexPolygon2D) {
        ConvexPolygon2D transformedConvexPolygon = new ConvexPolygon2D((Vertex2DSupplier)convexPolygon2D);
        transformedConvexPolygon.applyTransform((Transform)transform, false);
        return transformedConvexPolygon;
    }

    private void assertThatAllPolygonVerticesAreInBoundingBox(List<ConvexPolygon2D> regionConvexPolygons, PlanarRegion planarRegion, BoundingBox3D boundingBox3dInWorld) {
        for (ConvexPolygon2D convexPolygon2dInWorld : regionConvexPolygons) {
            for (int i = 0; i < convexPolygon2dInWorld.getNumberOfVertices(); ++i) {
                Point2DReadOnly vertex = convexPolygon2dInWorld.getVertex(i);
                double planeZGivenXY = planarRegion.getPlaneZGivenXY(vertex.getX(), vertex.getY());
                Assertions.assertTrue((boolean)boundingBox3dInWorld.isInsideInclusive(vertex.getX(), vertex.getY(), planeZGivenXY), (String)("Polygon vertex is not inside computed bounding box.\nVertex: " + vertex + "\nPlane z at vertex: " + planeZGivenXY + "\nBounding Box: " + boundingBox3dInWorld));
            }
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(PlanarRegion.class, PlanarRegionTest.class);
    }
}

