/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;

public class AngleToolsTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConstructor() throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Assert.assertEquals(1L, AngleTools.class.getDeclaredConstructors().length);
        Constructor constructor = AngleTools.class.getDeclaredConstructor(new Class[0]);
        Assert.assertTrue(Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
    }

    @Test
    public void testComputeAngleDifferenceMinusTwoPiToZero() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = -4.71238898038469;
        double actualReturn = AngleTools.computeAngleDifferenceMinusTwoPiToZero((double)angleA, (double)angleB);
        Assert.assertEquals(expectedReturn, actualReturn, Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.computeAngleDifferenceMinusTwoPiToZero((double)angleA, (double)(angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0)));
            Assert.assertTrue(ret <= 0.0);
            Assert.assertTrue(ret >= Math.PI * -2);
        }
    }

    @Test
    public void testComputeAngleDifferenceMinusPiToPi() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = 1.5707963267948966;
        double actualReturn = AngleTools.computeAngleDifferenceMinusPiToPi((double)angleA, (double)angleB);
        Assert.assertEquals(expectedReturn, actualReturn, Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.computeAngleDifferenceMinusPiToPi((double)angleA, (double)(angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0)));
            Assert.assertTrue(ret <= Math.PI);
            Assert.assertTrue(ret >= -Math.PI);
        }
    }

    @Test
    public void testComputeAngleDifferenceMinusPiToPiUsingTrim() {
        Random random = new Random(123456L);
        double angleA = Math.PI;
        double angleB = 1.5707963267948966;
        double expectedReturn = 1.5707963267948966;
        double actualReturn = AngleTools.trimAngleMinusPiToPi((double)(angleA - angleB));
        Assert.assertEquals(expectedReturn, actualReturn, Double.MIN_VALUE);
        for (int i = 0; i < 25; ++i) {
            angleA = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            double ret = AngleTools.trimAngleMinusPiToPi((double)(angleA - (angleB = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0))));
            Assert.assertTrue(ret <= Math.PI);
            Assert.assertTrue(ret >= -Math.PI);
        }
    }

    @Test
    public void testFindClosestNinetyDegreeYaw() {
        double yawInRadians = -1.2566370614359172;
        int expectedReturn = 3;
        int actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assert.assertEquals(expectedReturn, actualReturn);
        yawInRadians = 1.8849555921538759;
        expectedReturn = 1;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assert.assertEquals(expectedReturn, actualReturn);
        yawInRadians = 2.827433388230814;
        expectedReturn = 2;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assert.assertEquals(expectedReturn, actualReturn);
        yawInRadians = 7.5398223686155035;
        expectedReturn = 1;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assert.assertEquals(expectedReturn, actualReturn);
        yawInRadians = Math.PI * 4;
        expectedReturn = 0;
        actualReturn = AngleTools.findClosestNinetyDegreeYaw((double)yawInRadians);
        Assert.assertEquals(expectedReturn, actualReturn);
    }

    @Test
    public void testGenerateRandomAngle() {
        Random random = new Random(0L);
        for (int i = 0; i < 25; ++i) {
            double randomAngle = AngleTools.generateRandomAngle((Random)random);
            Assert.assertTrue(randomAngle <= Math.PI * 2);
            Assert.assertTrue(randomAngle >= Math.PI * -2);
        }
    }

    @Test
    public void testGenerateArrayOfTestAngles() {
        double[] anglesWithoutZeroOrPlusMinusPi = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)false, (boolean)false);
        int i = 0;
        for (double angle : anglesWithoutZeroOrPlusMinusPi) {
            Assert.assertTrue("array index = " + i, angle != 0.0);
            Assert.assertTrue("array index = " + i, angle != Math.PI);
            Assert.assertTrue("array index = " + i, angle != -Math.PI);
            Assert.assertTrue("array index = " + i, angle != Math.PI * 2);
            Assert.assertTrue("array index = " + i, angle != Math.PI * -2);
            ++i;
        }
        double[] anglesWithoutZero = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)false, (boolean)true);
        int numberOfAnglesEqualToPlusPI = 0;
        int numberOfAnglesEqualToMinusPI = 0;
        i = 0;
        for (double angle : anglesWithoutZero) {
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            Assert.assertTrue("array index = " + i, angle != 0.0);
            Assert.assertTrue("array index = " + i, angle != Math.PI * 2);
            Assert.assertTrue("array index = " + i, angle != Math.PI * -2);
            ++i;
        }
        Assert.assertEquals("Should have found one angle equal to +PI!", 1L, numberOfAnglesEqualToPlusPI);
        Assert.assertEquals("Should have found one angle equal to -PI!", 1L, numberOfAnglesEqualToMinusPI);
        double[] anglesWithoutPlusMinusPi = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)true, (boolean)false);
        int numberOfAnglesEqualToZero = 0;
        i = 0;
        for (double angle : anglesWithoutPlusMinusPi) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            Assert.assertTrue("array index = " + i, angle != Math.PI);
            Assert.assertTrue("array index = " + i, angle != -Math.PI);
            Assert.assertTrue("array index = " + i, angle != Math.PI * 2);
            Assert.assertTrue("array index = " + i, angle != Math.PI * -2);
            ++i;
        }
        Assert.assertEquals("Should have found one angle equal to 0.0!", 1L, numberOfAnglesEqualToZero);
        double[] allAnglesExceptPlusMinus2PI = AngleTools.generateArrayOfTestAngles((int)100, (double)0.1, (boolean)true, (boolean)true);
        i = 0;
        numberOfAnglesEqualToZero = 0;
        numberOfAnglesEqualToPlusPI = 0;
        numberOfAnglesEqualToMinusPI = 0;
        for (double angle : allAnglesExceptPlusMinus2PI) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            Assert.assertTrue("array index = " + i, angle != Math.PI * 2);
            Assert.assertTrue("array index = " + i, angle != Math.PI * -2);
            ++i;
        }
        Assert.assertEquals("Should have found one angle equal to 0.0!", 1L, numberOfAnglesEqualToZero);
        Assert.assertEquals("Should have found one angle equal to +PI!", 1L, numberOfAnglesEqualToPlusPI);
        Assert.assertEquals("Should have found one angle equal to -PI!", 1L, numberOfAnglesEqualToMinusPI);
        double[] allAnglesIncludingPlusMinus2PI = AngleTools.generateArrayOfTestAngles((int)100, (double)0.0, (boolean)true, (boolean)true);
        i = 0;
        numberOfAnglesEqualToZero = 0;
        numberOfAnglesEqualToPlusPI = 0;
        numberOfAnglesEqualToMinusPI = 0;
        int numberOfAnglesEqualToPlus2PI = 0;
        int numberOfAnglesEqualToMinus2PI = 0;
        for (double angle : allAnglesIncludingPlusMinus2PI) {
            if (angle == 0.0) {
                ++numberOfAnglesEqualToZero;
            }
            if (angle == Math.PI) {
                ++numberOfAnglesEqualToPlusPI;
            }
            if (angle == -Math.PI) {
                ++numberOfAnglesEqualToMinusPI;
            }
            if (angle == Math.PI * 2) {
                ++numberOfAnglesEqualToPlus2PI;
            }
            if (angle == Math.PI * -2) {
                ++numberOfAnglesEqualToMinus2PI;
            }
            ++i;
        }
        Assert.assertEquals("Should have found one angle equal to 0.0!", 1L, numberOfAnglesEqualToZero);
        Assert.assertEquals("Should have found one angle equal to +PI!", 1L, numberOfAnglesEqualToPlusPI);
        Assert.assertEquals("Should have found one angle equal to -PI!", 1L, numberOfAnglesEqualToMinusPI);
        Assert.assertEquals("Should have found one angle equal to +2PI!", 1L, numberOfAnglesEqualToPlus2PI);
        Assert.assertEquals("Should have found one angle equal to -2PI!", 1L, numberOfAnglesEqualToMinus2PI);
    }

    @Test
    public void testShiftAngleToStartOfRange() {
        double angleToShift = 0.5;
        double startOfAngleRange = Math.PI;
        double expectedReturn = 6.783185307179586;
        double actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        angleToShift = 12.0;
        startOfAngleRange = 1.5707963267948966;
        expectedReturn = 5.716814692820414;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        angleToShift = 0.8;
        startOfAngleRange = -0.7853981633974483;
        expectedReturn = 0.8;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)startOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
    }

    @Test
    public void testShiftAngleToStartOfRangeUnitless() {
        double range;
        double endOfAngleRange = range = Math.pow(2.0, 13.0);
        double angleToShift = 1.6 * range;
        double expectedReturn = 0.6 * range;
        double actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        angleToShift = -0.4 * range;
        expectedReturn = 0.6 * range;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        angleToShift = 0.4 * range;
        expectedReturn = 0.4 * range;
        actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
        Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        int iters = 1000;
        Random random = new Random();
        for (int i = 0; i < iters; ++i) {
            double ratio = -6.0 + 12.0 * random.nextDouble();
            expectedReturn = angleToShift = ratio * range;
            if (angleToShift < 0.0) {
                expectedReturn = angleToShift + Math.ceil(-angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            if (angleToShift >= endOfAngleRange) {
                expectedReturn = angleToShift - Math.floor(angleToShift / endOfAngleRange) * endOfAngleRange;
            }
            actualReturn = AngleTools.shiftAngleToStartOfRange((double)angleToShift, (double)0.0, (double)endOfAngleRange);
            Assert.assertEquals(expectedReturn, actualReturn, 1.0E-12);
        }
    }

    @Test
    public void testTrimAngleMinusPiToPi() {
        Random random = new Random(0L);
        for (int i = 0; i < 25; ++i) {
            double randomAngle = RandomNumbers.nextDouble((Random)random, (double)-128.0, (double)128.0);
            Assert.assertTrue((randomAngle = AngleTools.trimAngleMinusPiToPi((double)randomAngle)) <= Math.PI);
            Assert.assertTrue(randomAngle >= -Math.PI);
        }
    }

    @Test
    public void testComputeAngleAverage() {
        double angleA = Math.PI;
        double angleB = 6.583185307179586;
        double expected = 1.7207963267948965;
        double actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        angleB = Math.PI;
        angleA = 6.583185307179586;
        expected = 1.7207963267948965;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        angleA = 0.3;
        angleB = Math.PI;
        expected = 1.7207963267948965;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        angleA = 2.8415926535897933;
        angleB = -3.041592653589793;
        expected = 3.041592653589793;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        angleB = 2.8415926535897933;
        angleA = -3.041592653589793;
        expected = 3.041592653589793;
        actual = AngleTools.computeAngleAverage((double)angleA, (double)angleB);
        Assert.assertEquals(expected, actual, 1.0E-12);
    }

    @Test
    public void testAngleMinusPiToPi() {
        Vector2D vectorA = new Vector2D(0.0, 1.0);
        Vector2D vectorB = new Vector2D(1.0, 0.0);
        double expected = -1.5707963267948966;
        double actual = AngleTools.angleMinusPiToPi((Vector2DReadOnly)vectorA, (Vector2DReadOnly)vectorB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        vectorA = new Vector2D(0.0, 1.0);
        vectorB = new Vector2D(-1.0, 0.0);
        expected = 1.5707963267948966;
        actual = AngleTools.angleMinusPiToPi((Vector2DReadOnly)vectorA, (Vector2DReadOnly)vectorB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        vectorA = new Vector2D(1.0, 1.0);
        vectorB = new Vector2D(-1.0, 0.0);
        expected = 2.356194490192345;
        actual = AngleTools.angleMinusPiToPi((Vector2DReadOnly)vectorA, (Vector2DReadOnly)vectorB);
        Assert.assertEquals(expected, actual, 1.0E-12);
        vectorA = new Vector2D(0.0, 1.0);
        vectorB = new Vector2D(0.0, 0.0);
        expected = AngleTools.angleMinusPiToPi((Vector2DReadOnly)vectorA, (Vector2DReadOnly)vectorB);
        Assert.assertTrue(Double.isNaN(expected));
    }

    @Test
    public void testAngleFromZeroToTwoPi() {
        Assert.assertEquals("not equal", 0.0, AngleTools.angleFromZeroToTwoPi((double)0.0, (double)0.0), 1.0E-7);
        Assert.assertEquals("not equal", 0.7853981633974483, AngleTools.angleFromZeroToTwoPi((double)1.0, (double)1.0), 1.0E-7);
        Assert.assertEquals("not equal", 5.497787143782138, AngleTools.angleFromZeroToTwoPi((double)1.0, (double)-1.0), 1.0E-7);
    }

    @Test
    public void testCalculateHeading() {
        FramePose2D start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        FramePoint2D end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 1.0, 1.0);
        double heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, 45.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 1.0, 0.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, 0.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 0.0, 0.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, 0.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 0.0, 1.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, 90.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 0.0, -1.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, -90.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), -1.0, -1.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, -135.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), -1.0, 0.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, -180.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), 1.0, -1.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, -45.0, 1.0E-7);
        start = new FramePose2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)new Point2D(0.0, 0.0), 0.0);
        end = new FramePoint2D(ReferenceFrame.getWorldFrame(), -1.0, 1.0);
        heading = Math.toDegrees(AngleTools.calculateHeading((FramePose2DReadOnly)start, (FramePoint2DReadOnly)end, (double)0.0, (double)0.0));
        Assert.assertEquals(heading, 135.0, 1.0E-7);
    }
}

