/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.filters;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.math.filters.SecondOrderFilterType;
import us.ihmc.robotics.math.filters.SecondOrderFilteredYoVariable;
import us.ihmc.robotics.testing.JUnitTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SecondOrderFilteredYoVariableTest {
    YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());

    @Test
    public void testLowPassFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{3947.8417604357433, 7895.6835208714865, 3947.8417604357433};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoVariable filteredYoVariable = new SecondOrderFilteredYoVariable("lowPass", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilterType.LOW_PASS);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        JUnitTools.assertDoubleArrayEquals(b, bAssert, 1.0E-8);
        JUnitTools.assertDoubleArrayEquals(a, aAssert, 1.0E-8);
    }

    @Test
    public void testNotchFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{4003947.8417604356, -7992104.316479129, 4003947.8417604356};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoVariable filteredYoVariable = new SecondOrderFilteredYoVariable("notch", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilterType.NOTCH);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        JUnitTools.assertDoubleArrayEquals(b, bAssert, 1.0E-8);
        JUnitTools.assertDoubleArrayEquals(a, aAssert, 1.0E-8);
    }

    @Test
    public void testHighPassFilterCoefficients() {
        double dt = 0.001;
        double dampingRatio = 1.0;
        double naturalFrequencyInHz = 10.0;
        double[] bAssert = new double[]{4000000.0, -8000000.0, 4000000.0};
        double[] aAssert = new double[]{4255275.254047619, -7992104.316479129, 3752620.429473252};
        SecondOrderFilteredYoVariable filteredYoVariable = new SecondOrderFilteredYoVariable("highPass", this.registry, dt, naturalFrequencyInHz, dampingRatio, SecondOrderFilterType.HIGH_PASS);
        double[] b = new double[3];
        double[] a = new double[3];
        filteredYoVariable.getFilterCoefficients(b, a);
        JUnitTools.assertDoubleArrayEquals(b, bAssert, 1.0E-8);
        JUnitTools.assertDoubleArrayEquals(a, aAssert, 1.0E-8);
    }
}

