/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.dataStructures;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.AbstractHeightMapTest;
import us.ihmc.robotics.dataStructures.DataGridTools;
import us.ihmc.robotics.dataStructures.DoubleHashHeightMap;
import us.ihmc.robotics.dataStructures.HeightMapWithPoints;
import us.ihmc.robotics.geometry.InclusionFunction;
import us.ihmc.robotics.geometry.InsufficientDataException;

public class DoubleHashHeightMapTest
extends AbstractHeightMapTest {
    private static final int MAX_X = 500;
    private static final int NUMBER_OF_POINTS_TO_WRITE = 400000;
    private static final int NUMBER_OF_TIMES_TO_SAMPLE = 400;
    private static final int NUMBER_OF_SYNCHRONOUS_PAIRS = 8;
    private static final double RESOLUTION = 0.1;
    private static final double eps = 1.0E-7;
    private static final double NaN = Double.NaN;

    @Test
    public void testSinglePointOld() {
        double x = 1.0E-5;
        double y = 1.0E-5;
        int xIndex = 0;
        int yIndex = 0;
        double z = 5.25;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
        x = 1.0E-5;
        xIndex = 0;
        z = 4.0;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
        x = -1.0E-5;
        xIndex = 0;
        z = 4.0;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
        x = -28.00001;
        xIndex = -280;
        z = 2.0;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
        x = -28.00001;
        xIndex = -280;
        z = -21234.0;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
        y = -28.00001;
        yIndex = -280;
        this.assertSinglePointGridHandlesPoint(x, y, xIndex, yIndex, z);
    }

    @Test
    public void testGettingAreasOld() {
        double gridResolution = 1.0;
        DoubleHashHeightMap map = new DoubleHashHeightMap(gridResolution);
        DMatrixRMaj matrix = new DMatrixRMaj(7, 7);
        matrix.setData(new double[]{0.0, 0.0, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 8.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 8.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        DataGridTools.fillMapWithMatrixCentered((HeightMapWithPoints)map, (DMatrixRMaj)matrix, (double)gridResolution);
        List points = map.getAllPointsWithinArea(0.0, 0.0, 2.0, 2.0);
        System.out.println("DoubleHashHeightMapTest points" + points);
        Assert.assertEquals(9L, points.size());
        Assert.assertEquals(-1.0, ((Point3D)points.get(0)).getX(), 1.0E-7);
        Assert.assertEquals(-1.0, ((Point3D)points.get(1)).getX(), 1.0E-7);
        Assert.assertEquals(-1.0, ((Point3D)points.get(2)).getX(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(3)).getX(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(4)).getX(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(5)).getX(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(6)).getX(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(7)).getX(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(8)).getX(), 1.0E-7);
        Assert.assertEquals(-1.0, ((Point3D)points.get(0)).getY(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(1)).getY(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(2)).getY(), 1.0E-7);
        Assert.assertEquals(-1.0, ((Point3D)points.get(3)).getY(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(4)).getY(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(5)).getY(), 1.0E-7);
        Assert.assertEquals(-1.0, ((Point3D)points.get(6)).getY(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(7)).getY(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(8)).getY(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(0)).getZ(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(1)).getZ(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(2)).getZ(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(3)).getZ(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(4)).getZ(), 1.0E-7);
        Assert.assertEquals(1.0, ((Point3D)points.get(5)).getZ(), 1.0E-7);
        Assert.assertEquals(2.0, ((Point3D)points.get(6)).getZ(), 1.0E-7);
        Assert.assertEquals(2.0, ((Point3D)points.get(7)).getZ(), 1.0E-7);
        Assert.assertEquals(2.0, ((Point3D)points.get(8)).getZ(), 1.0E-7);
        map.clear();
        Assert.assertEquals(0.0, (double)map.getAllPointsWithinArea(0.0, 0.0, 2.0, 2.0).size(), 1.0E-7);
    }

    @Test
    public void testUnhandledPointsOld() {
        DoubleHashHeightMap simpleMap = new DoubleHashHeightMap(0.1);
        double x = 1.0E-5;
        double y = 1.0E-5;
        double z = 5.25;
        simpleMap.addPoint(x, y, z);
        y = 1.03001;
        z = 2.25;
        simpleMap.addPoint(x, y, z);
        y = 1.33001;
        simpleMap.addPoint(x, y, z);
        y = 2.33001;
        simpleMap.addPoint(x, y, z);
        y = 3.33001;
        simpleMap.addPoint(x, y, z);
        x = 3.00001;
        y = 1.00001;
        z = -50.25;
        simpleMap.addPoint(x, y, z);
        x = 2.00001;
        z = -24.25;
        simpleMap.addPoint(x, y, z);
        x = -22.00001;
        simpleMap.addPoint(x, y, z);
        Assert.assertFalse(simpleMap.containsPoint(-2345.34, 23453.459));
        Assert.assertEquals(Double.NaN, simpleMap.getHeightAtPoint(0.0, -1.0), 1.0E-7);
        Assert.assertEquals(Double.NaN, simpleMap.getHeightAtPoint(1.0, 1.0), 1.0E-7);
        this.testOverridingOrigin((HeightMapWithPoints)simpleMap);
    }

    @Test
    public void testGrabCellsOld() {
        DoubleHashHeightMap simpleMap = new DoubleHashHeightMap(0.1);
        simpleMap.addPoint(0.5, 0.0, 1.3);
        List points = simpleMap.getAllPointsWithinArea(0.0, 0.0, 1000.0, 1000.0);
        Assert.assertEquals(0.5, ((Point3D)points.get(0)).getX(), 1.0E-7);
        Assert.assertEquals(0.0, ((Point3D)points.get(0)).getY(), 1.0E-7);
        Assert.assertEquals(1.3, ((Point3D)points.get(0)).getZ(), 1.0E-7);
    }

    @Override
    public void assertSinglePointGridHandlesPoint(double x, double y, int xIndex, int yIndex, double z) {
        DoubleHashHeightMap simpleMap = new DoubleHashHeightMap(0.1);
        simpleMap.addPoint(x, y, z);
        Assert.assertTrue(simpleMap.containsPoint(x, y));
        Assert.assertTrue(simpleMap.containsPoint((double)xIndex * 0.1, (double)yIndex * 0.1));
        Assert.assertEquals(z, simpleMap.getHeightAtPoint(x, y), 1.0E-7);
        Assert.assertEquals(z, simpleMap.getHeightAtPoint((double)xIndex * 0.1, (double)yIndex * 0.1), 1.0E-7);
    }

    @Test
    public void rowModificationSynchronizationTestOld() {
        DoubleHashHeightMap simpleMap = new DoubleHashHeightMap(0.1);
        ExecutorService service = Executors.newCachedThreadPool();
        ArrayList<Future<String>> dataWriters = new ArrayList<Future<String>>();
        ArrayList<Future<String>> dataReaders = new ArrayList<Future<String>>();
        for (int i = 0; i < 8; ++i) {
            dataWriters.add(this.createWriterOld((HeightMapWithPoints)simpleMap, service));
            dataReaders.add(this.createReaderOld((HeightMapWithPoints)simpleMap, service));
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        for (int i = 0; i < 8; ++i) {
            this.handleFuture((Future)dataWriters.get(i));
            this.handleFuture((Future)dataReaders.get(i));
        }
    }

    @Override
    @Test
    public void testUnhandledPoints() {
        super.testUnhandledPoints();
    }

    public Future<String> createReaderOld(final HeightMapWithPoints simpleMap, ExecutorService service) {
        Future<String> dataInclusionFuture = service.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    for (int i = 0; i < 400; ++i) {
                        simpleMap.getAllPointsWithinArea(0.0, 0.0, 500.0, 400.0);
                    }
                }
                catch (Throwable e) {
                    return e.getMessage();
                }
                return "";
            }
        });
        return dataInclusionFuture;
    }

    public Future<String> createWriterOld(final HeightMapWithPoints simpleMap, ExecutorService service) {
        Future<String> dataInclusionFuture = service.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                Random gen = new Random(-8192376L);
                try {
                    for (int i = 0; i < 400000; ++i) {
                        simpleMap.addPoint((double)gen.nextInt(500), (double)gen.nextInt(10), 1.337);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return e.getMessage();
                }
                return "";
            }
        });
        return dataInclusionFuture;
    }

    @Override
    public void handleFuture(Future<String> dataInclusionFuture) {
        try {
            String resultString = dataInclusionFuture.get();
            Assert.assertTrue(dataInclusionFuture.isDone());
            Assert.assertTrue("result string not empty: is " + resultString, "".equals(resultString));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testKernelMaskingOld() throws InsufficientDataException {
        double b = 10000.0;
        double gridResolution = 0.01;
        DMatrixRMaj matrix = new DMatrixRMaj(11, 11);
        matrix.setData(new double[]{b, b, b, b, b, b, b, b, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, 0.0, 0.0, 0.0, 0.0, 0.0, b, b, b, b, b, b, b, b, b, b, b, b, b, b});
        DoubleHashHeightMap lidarMap = new DoubleHashHeightMap(gridResolution);
        DataGridTools.fillMapWithMatrixCentered((HeightMapWithPoints)lidarMap, (DMatrixRMaj)matrix, (double)gridResolution);
        List points = lidarMap.getAllPointsWithinArea(0.0, 0.0, 0.1, 0.1, (InclusionFunction)new InclusionFunction<Point3D>(){

            public boolean isIncluded(Point3D test) {
                return test.getZ() < 20.0;
            }
        });
        Assert.assertEquals(45L, points.size());
    }

    @Override
    public HeightMapWithPoints getHeightMap(double minX, double minY, double maxX, double maxY, double resolution) {
        return new DoubleHashHeightMap(resolution);
    }
}

