/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPIDGains;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoPIDGainsTest {
    @Test
    public void test() {
        YoPIDGains pidGains = new YoPIDGains("test", new YoRegistry("PIDGainsRegistry"));
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double kp = random.nextDouble() * 100.0;
            double kd = random.nextDouble() * 100.0;
            double ki = random.nextDouble() * 100.0;
            double maxAcc = random.nextDouble() * 100.0;
            double maxJerk = random.nextDouble() * 100.0;
            double maxIntegralError = random.nextDouble() * 100.0;
            double integratorLeakRatio = random.nextDouble();
            double zeta = random.nextDouble() * 100.0;
            pidGains.setKp(kp);
            pidGains.setKd(kd);
            pidGains.setKi(ki);
            pidGains.setMaximumFeedback(maxAcc);
            pidGains.setMaximumFeedbackRate(maxJerk);
            pidGains.setMaximumIntegralError(maxIntegralError);
            pidGains.setIntegralLeakRatio(integratorLeakRatio);
            pidGains.setZeta(zeta);
            Assert.assertEquals(kp, pidGains.getKp(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getKd(), 1.0E-6);
            Assert.assertEquals(kp, pidGains.getYoKp().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getYoKd().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(ki, pidGains.getYoKi().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getMaximumFeedback(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getMaximumFeedbackRate(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getYoMaximumFeedback().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getYoMaximumFeedbackRate().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(integratorLeakRatio, pidGains.getYoIntegralLeakRatio().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(zeta, pidGains.getZeta(), 1.0E-6);
        }
    }

    @Test
    public void testParameters_2() {
        YoPIDGains pidGains = new YoPIDGains("test", new YoRegistry("PIDGainsRegistry"));
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double kp = random.nextDouble() * 100.0;
            double kd = random.nextDouble() * 100.0;
            double ki = random.nextDouble() * 100.0;
            double maxAcc = random.nextDouble() * 100.0;
            double maxJerk = random.nextDouble() * 100.0;
            double maxIntegralError = random.nextDouble() * 100.0;
            double integratorLeakRatio = random.nextDouble();
            double zeta = random.nextDouble() * 100.0;
            pidGains.setPDGains(kp, zeta);
            pidGains.setKd(kd);
            pidGains.setKi(ki);
            pidGains.setMaximumFeedback(maxAcc);
            pidGains.setMaximumFeedbackRate(maxJerk);
            pidGains.setMaximumIntegralError(maxIntegralError);
            pidGains.setIntegralLeakRatio(integratorLeakRatio);
            Assert.assertEquals(kp, pidGains.getKp(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getKd(), 1.0E-6);
            Assert.assertEquals(kp, pidGains.getYoKp().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getYoKd().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(ki, pidGains.getYoKi().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getMaximumFeedback(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getMaximumFeedbackRate(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getYoMaximumFeedback().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getYoMaximumFeedbackRate().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(integratorLeakRatio, pidGains.getYoIntegralLeakRatio().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(zeta, pidGains.getZeta(), 1.0E-6);
        }
    }

    @Test
    public void testParameters_3() {
        YoPIDGains pidGains = new YoPIDGains("test", new YoRegistry("PIDGainsRegistry"));
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double kp = random.nextDouble() * 100.0;
            double kd = random.nextDouble() * 100.0;
            double ki = random.nextDouble() * 100.0;
            double maxAcc = random.nextDouble() * 100.0;
            double maxJerk = random.nextDouble() * 100.0;
            double maxIntegralError = random.nextDouble() * 100.0;
            double integratorLeakRatio = random.nextDouble();
            double zeta = random.nextDouble() * 100.0;
            pidGains.setPIDGains(kp, zeta, ki, maxIntegralError);
            pidGains.setKd(kd);
            pidGains.setMaximumFeedback(maxAcc);
            pidGains.setMaximumFeedbackRate(maxJerk);
            pidGains.setIntegralLeakRatio(integratorLeakRatio);
            Assert.assertEquals(kp, pidGains.getKp(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getKd(), 1.0E-6);
            Assert.assertEquals(kp, pidGains.getYoKp().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(kd, pidGains.getYoKd().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(ki, pidGains.getYoKi().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getMaximumFeedback(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getMaximumFeedbackRate(), 1.0E-6);
            Assert.assertEquals(maxAcc, pidGains.getYoMaximumFeedback().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxJerk, pidGains.getYoMaximumFeedbackRate().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(zeta, pidGains.getZeta(), 1.0E-6);
            Assert.assertEquals(integratorLeakRatio, pidGains.getYoIntegralLeakRatio().getDoubleValue(), 1.0E-6);
            Assert.assertEquals(maxIntegralError, pidGains.getYoMaxIntegralError().getDoubleValue(), 1.0E-6);
        }
    }

    @Test
    public void testClippingLeakRate() {
        YoPIDGains pidGains = new YoPIDGains("test", new YoRegistry("PIDGainsRegistry"));
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double integratorLeakRatio = random.nextDouble() * 100.0;
            pidGains.setIntegralLeakRatio(integratorLeakRatio);
            Assert.assertTrue(pidGains.getYoIntegralLeakRatio().getDoubleValue() <= 1.0);
            integratorLeakRatio = -random.nextDouble() * 100.0;
            pidGains.setIntegralLeakRatio(integratorLeakRatio);
            Assert.assertTrue(pidGains.getYoIntegralLeakRatio().getDoubleValue() >= 0.0);
        }
    }
}

