/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.MatrixMissingTools;

public class MatrixMissingToolsTest {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testSetDiagonalValues() {
        int iters = 100;
        DMatrixRMaj matrixToSet = new DMatrixRMaj(4, 7);
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            matrixToSet.setData(RandomNumbers.nextDoubleArray((Random)random, (int)28, (double)100.0));
            DMatrixRMaj originalMatrix = new DMatrixRMaj(matrixToSet);
            double value = RandomNumbers.nextDouble((Random)random, (double)10.0);
            MatrixMissingTools.setDiagonalValues((DMatrix1Row)matrixToSet, (double)value, (int)1, (int)3);
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 7; ++col) {
                    if (row == 1 && col == 3) {
                        Assertions.assertEquals((double)value, (double)matrixToSet.get(row, col), (double)1.0E-9);
                        continue;
                    }
                    if (row == 2 && col == 4) {
                        Assertions.assertEquals((double)value, (double)matrixToSet.get(row, col), (double)1.0E-9);
                        continue;
                    }
                    if (row == 3 && col == 5) {
                        Assertions.assertEquals((double)value, (double)matrixToSet.get(row, col), (double)1.0E-9);
                        continue;
                    }
                    Assertions.assertEquals((double)originalMatrix.get(row, col), (double)matrixToSet.get(row, col), (double)1.0E-9);
                }
            }
        }
    }

    @Test
    public void testNegateUnsafe() {
        DMatrixRMaj matrixToNegate = new DMatrixRMaj(0, 0);
        DMatrixRMaj negatedMatrix = new DMatrixRMaj(0, 0);
        int iters = 100;
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            int initializeRows = RandomNumbers.nextInt((Random)random, (int)100, (int)1000);
            int initializeCols = RandomNumbers.nextInt((Random)random, (int)100, (int)1000);
            matrixToNegate.set((DMatrixD1)RandomMatrices_DDRM.rectangle((int)initializeRows, (int)initializeCols, (Random)random));
            negatedMatrix.set((DMatrixD1)RandomMatrices_DDRM.rectangle((int)initializeRows, (int)initializeCols, (Random)random));
            int rows = RandomNumbers.nextInt((Random)random, (int)10, (int)500);
            int cols = RandomNumbers.nextInt((Random)random, (int)10, (int)500);
            DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)rows, (int)cols, (Random)random);
            matrixToNegate.set((DMatrixD1)randomMatrix);
            negatedMatrix.reshape(rows, cols);
            MatrixMissingTools.unsafe_changeSign((DMatrixRMaj)matrixToNegate, (DMatrixRMaj)negatedMatrix);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)randomMatrix);
            EjmlUnitTests.assertEquals((DMatrix)randomMatrix, (DMatrix)negatedMatrix, (double)1.0E-9);
        }
    }

    @Test
    public void testFast2x2Inverse() {
        int iters = 500;
        double epsilon = 1.0E-8;
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            DMatrixRMaj matrix = new DMatrixRMaj(2, 2);
            DMatrixRMaj matrixInverseExpected = new DMatrixRMaj(2, 2);
            DMatrixRMaj matrixInverse = new DMatrixRMaj(2, 2);
            matrix.setData(RandomNumbers.nextDoubleArray((Random)random, (int)4, (double)10.0));
            NativeCommonOps.invert((DMatrix1Row)matrix, (DMatrix1Row)matrixInverseExpected);
            MatrixMissingTools.fast2x2Inverse((DMatrixRMaj)matrix, (DMatrixRMaj)matrixInverse);
            MatrixTestTools.assertMatrixEquals((DMatrix)matrixInverseExpected, (DMatrix)matrixInverse, (double)epsilon);
        }
    }

    @Test
    public void testToSkewSymmetric() {
        int iters = 500;
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            Vector3D vectorA = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorB = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D vectorC = new Vector3D();
            vectorC.cross((Tuple3DReadOnly)vectorA, (Tuple3DReadOnly)vectorB);
            DMatrixRMaj vectorBVector = new DMatrixRMaj(3, 1);
            DMatrixRMaj vectorCVector = new DMatrixRMaj(3, 1);
            DMatrixRMaj vectorCActual = new DMatrixRMaj(3, 1);
            DMatrixRMaj skewVectorA = new DMatrixRMaj(3, 3);
            vectorB.get((DMatrix)vectorBVector);
            MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)vectorA, (DMatrixRMaj)skewVectorA);
            CommonOps_DDRM.mult((DMatrix1Row)skewVectorA, (DMatrix1Row)vectorBVector, (DMatrix1Row)vectorCVector);
            vectorC.get((DMatrix)vectorCActual);
            MatrixTestTools.assertMatrixEquals((DMatrix)vectorCActual, (DMatrix)vectorCVector, (double)1.0E-9);
        }
    }

    @Test
    public void testSetMatrixRows() {
        Random random = new Random(45348L);
        DMatrixRMaj src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        DMatrixRMaj dest = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        DMatrixRMaj srcCopy = new DMatrixRMaj(src);
        DMatrixRMaj destCopy = new DMatrixRMaj(dest);
        MatrixMissingTools.setMatrixRows((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)0);
        Assertions.assertArrayEquals((double[])srcCopy.getData(), (double[])src.getData(), (double)1.0E-9);
        Assertions.assertArrayEquals((double[])destCopy.getData(), (double[])dest.getData(), (double)1.0E-9);
        src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)8, (int)8, (Random)random);
        int numberOfRows = 5;
        try {
            MatrixMissingTools.setMatrixRows((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfRows);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)5, (int)10, (Random)random);
        numberOfRows = 10;
        try {
            MatrixMissingTools.setMatrixRows((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfRows);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        src = RandomMatrices_DDRM.rectangle((int)5, (int)10, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        numberOfRows = 10;
        try {
            MatrixMissingTools.setMatrixRows((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfRows);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetMatrixColumns() {
        Random random = new Random(1738L);
        DMatrixRMaj src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        DMatrixRMaj dest = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        DMatrixRMaj srcCopy = new DMatrixRMaj(src);
        DMatrixRMaj destCopy = new DMatrixRMaj(dest);
        MatrixMissingTools.setMatrixColumns((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)0);
        Assertions.assertArrayEquals((double[])srcCopy.getData(), (double[])src.getData(), (double)1.0E-9);
        Assertions.assertArrayEquals((double[])destCopy.getData(), (double[])dest.getData(), (double)1.0E-9);
        src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)8, (int)8, (Random)random);
        int numberOfColumns = 5;
        try {
            MatrixMissingTools.setMatrixColumns((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfColumns);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        src = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)10, (int)5, (Random)random);
        numberOfColumns = 10;
        try {
            MatrixMissingTools.setMatrixColumns((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfColumns);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        src = RandomMatrices_DDRM.rectangle((int)10, (int)5, (Random)random);
        dest = RandomMatrices_DDRM.rectangle((int)10, (int)10, (Random)random);
        numberOfColumns = 10;
        try {
            MatrixMissingTools.setMatrixColumns((DMatrix)src, (int)0, (DMatrix)dest, (int)0, (int)numberOfColumns);
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetSelectedMatrixDiagonals() {
        int[] indices;
        int indicesSize;
        DMatrixRMaj matrix;
        int columnSize;
        int rowSize;
        int i;
        Random random = new Random(1738L);
        int iters = 100;
        for (i = 0; i < iters; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = RandomMatrices_DDRM.diagonal((int)rowSize, (int)columnSize, (double)0.0, (double)1.0, (Random)random);
            indicesSize = Math.min(rowSize, columnSize);
            indices = new int[indicesSize];
            for (int j = 0; j < indicesSize; ++j) {
                indices[j] = random.nextInt(0, Math.min(rowSize, columnSize) - 1);
            }
            double value = random.nextDouble();
            MatrixMissingTools.setSelectedMatrixDiagonals((int[])indices, (double)value, (DMatrixRMaj)matrix);
            for (int index : indices) {
                Assertions.assertEquals((double)value, (double)matrix.get(index, index), (double)1.0E-9);
            }
        }
        for (i = 0; i < iters; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = RandomMatrices_DDRM.diagonal((int)rowSize, (int)columnSize, (double)0.0, (double)1.0, (Random)random);
            if (random.nextBoolean()) {
                indicesSize = 0;
                indices = new int[indicesSize];
                try {
                    MatrixMissingTools.setSelectedMatrixDiagonals((int[])indices, (double)random.nextDouble(), (DMatrixRMaj)matrix);
                    Assertions.fail((String)"Should have thrown exception");
                }
                catch (IllegalArgumentException value) {}
                continue;
            }
            indicesSize = Math.min(rowSize, columnSize) + 1;
            indices = new int[indicesSize];
            for (int j = 0; j < indicesSize; ++j) {
                indices[j] = random.nextInt(0, Math.min(rowSize, columnSize) - 1);
            }
            try {
                MatrixMissingTools.setSelectedMatrixDiagonals((int[])indices, (double)random.nextDouble(), (DMatrixRMaj)matrix);
                Assertions.fail((String)"Should have thrown exception");
                continue;
            }
            catch (IllegalArgumentException j) {
                // empty catch block
            }
        }
        for (i = 0; i < iters; ++i) {
            rowSize = random.nextInt(5, 10);
            columnSize = random.nextInt(5, 10);
            matrix = RandomMatrices_DDRM.diagonal((int)rowSize, (int)columnSize, (double)0.0, (double)1.0, (Random)random);
            indicesSize = Math.min(rowSize, columnSize);
            indices = new int[indicesSize];
            for (int j = 0; j < indicesSize; ++j) {
                indices[j] = random.nextInt(0, Math.min(rowSize, columnSize) - 1);
            }
            if (random.nextBoolean()) {
                indices[random.nextInt((int)0, (int)(indicesSize - 1))] = -random.nextInt(1, 10);
                try {
                    MatrixMissingTools.setSelectedMatrixDiagonals((int[])indices, (double)random.nextDouble(), (DMatrixRMaj)matrix);
                    Assertions.fail((String)"Should have thrown exception");
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            indices[random.nextInt((int)indicesSize)] = Math.max(rowSize, columnSize) + 1;
            try {
                MatrixMissingTools.setSelectedMatrixDiagonals((int[])indices, (double)random.nextDouble(), (DMatrixRMaj)matrix);
                Assertions.fail((String)"Should have thrown exception");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testPowerCalculation() {
        Random random = new Random(1738L);
        double error = 1.0E-5;
        int iters = 100;
        for (int i = 0; i < iters; ++i) {
            int matrixSize = random.nextInt(10);
            DMatrixRMaj matrix = RandomMatrices_DDRM.rectangle((int)matrixSize, (int)matrixSize, (Random)random);
            DMatrixRMaj matrixPowerTest = new DMatrixRMaj(matrixSize, matrixSize);
            int powerNumber = random.nextInt(1, 15);
            MatrixMissingTools.power((DMatrixRMaj)matrix, (int)powerNumber, (DMatrixRMaj)matrixPowerTest);
            DMatrixRMaj matrixResult = new DMatrixRMaj(matrixSize, matrixSize);
            DMatrixRMaj matrixIdentity = new DMatrixRMaj(matrixSize, matrixSize);
            CommonOps_DDRM.setIdentity((DMatrix1Row)matrixResult);
            CommonOps_DDRM.setIdentity((DMatrix1Row)matrixIdentity);
            MatrixMissingTools.power((DMatrixRMaj)matrixIdentity, (int)powerNumber, (DMatrixRMaj)matrixResult);
            MatrixTestTools.assertMatrixEquals((DMatrix)matrixIdentity, (DMatrix)matrixResult, (double)error);
            DMatrixRMaj matrixDiagonal = new DMatrixRMaj(matrixSize, matrixSize);
            DMatrixRMaj matrixDiagonalHand = new DMatrixRMaj(matrixSize, matrixSize);
            DMatrixRMaj matrixDiagonalResult = new DMatrixRMaj(matrixSize, matrixSize);
            CommonOps_DDRM.setIdentity((DMatrix1Row)matrixDiagonal);
            double diagonalTemp = 0.0;
            for (int j = 0; j < matrixSize; ++j) {
                matrixDiagonal.set(j, j, random.nextDouble(50.0));
                diagonalTemp = matrixDiagonal.get(j, j);
                for (int k = 1; k < powerNumber; ++k) {
                    diagonalTemp *= matrixDiagonal.get(j, j);
                }
                matrixDiagonalHand.set(j, j, diagonalTemp);
            }
            MatrixMissingTools.power((DMatrixRMaj)matrixDiagonal, (int)powerNumber, (DMatrixRMaj)matrixDiagonalResult);
            MatrixTestTools.assertMatrixEquals((DMatrix)matrixDiagonalHand, (DMatrix)matrixDiagonalResult, (double)error);
            DMatrixRMaj skewMatrix = new DMatrixRMaj(2, 2);
            double skewTempValue = random.nextDouble();
            skewMatrix.zero();
            skewMatrix.set(0, 1, skewTempValue);
            skewMatrix.set(1, 0, -skewTempValue);
            DMatrixRMaj skewMatrixHand = new DMatrixRMaj(2, 2);
            DMatrixRMaj skewMatrixResult = new DMatrixRMaj(2, 2);
            skewMatrixHand.zero();
            skewMatrixHand.set(0, 0, -skewTempValue * skewTempValue);
            skewMatrixHand.set(1, 1, -skewTempValue * skewTempValue);
            MatrixMissingTools.power((DMatrixRMaj)skewMatrix, (int)2, (DMatrixRMaj)skewMatrixResult);
            MatrixTestTools.assertMatrixEquals((DMatrix)skewMatrixHand, (DMatrix)skewMatrixResult, (double)error);
            skewMatrixHand.zero();
            skewMatrixHand.set(0, 1, -skewTempValue * skewTempValue * skewTempValue);
            skewMatrixHand.set(1, 0, skewTempValue * skewTempValue * skewTempValue);
            MatrixMissingTools.power((DMatrixRMaj)skewMatrix, (int)3, (DMatrixRMaj)skewMatrixResult);
            MatrixTestTools.assertMatrixEquals((DMatrix)skewMatrixHand, (DMatrix)skewMatrixResult, (double)error);
            skewMatrixHand.zero();
            skewMatrixHand.set(0, 0, skewTempValue * skewTempValue * skewTempValue * skewTempValue);
            skewMatrixHand.set(1, 1, skewTempValue * skewTempValue * skewTempValue * skewTempValue);
            MatrixMissingTools.power((DMatrixRMaj)skewMatrix, (int)4, (DMatrixRMaj)skewMatrixResult);
            MatrixTestTools.assertMatrixEquals((DMatrix)skewMatrixHand, (DMatrix)skewMatrixResult, (double)error);
        }
    }

    @Test
    public void testElementWiseLessThan() {
        Random random = new Random(41584L);
        int iters = 100;
        for (int i = 0; i < iters; ++i) {
            int j;
            int rowSize = random.nextInt(5, 10);
            int columnSize = random.nextInt(5, 10);
            DMatrixRMaj matrixLess = RandomMatrices_DDRM.rectangle((int)rowSize, (int)columnSize, (Random)random);
            DMatrixRMaj matrixMore = new DMatrixRMaj(rowSize, columnSize);
            for (j = 0; j < rowSize; ++j) {
                for (int k = 0; k < columnSize; ++k) {
                    matrixMore.set(j, k, matrixLess.get(j, k) + random.nextDouble(0.01, 0.05));
                }
            }
            Assertions.assertTrue((boolean)MatrixMissingTools.elementWiseLessThan((DMatrixRMaj)matrixLess, (DMatrixRMaj)matrixMore));
            Assertions.assertFalse((boolean)MatrixMissingTools.elementWiseLessThan((DMatrixRMaj)matrixMore, (DMatrixRMaj)matrixLess));
            for (j = 0; j < matrixLess.getNumElements(); ++j) {
                DMatrixRMaj matrixLessNotAll = new DMatrixRMaj(matrixLess);
                matrixLessNotAll.set(j, matrixMore.get(j) + 0.001);
                Assertions.assertFalse((boolean)MatrixMissingTools.elementWiseLessThan((DMatrixRMaj)matrixLess, (DMatrixRMaj)matrixLessNotAll));
            }
        }
        Assertions.assertThrows(IllegalArgumentException.class, () -> MatrixMissingTools.elementWiseLessThan((DMatrixRMaj)new DMatrixRMaj(1, 2), (DMatrixRMaj)new DMatrixRMaj(2, 2)));
    }
}

