/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.EuclidGeometryMissingTools;

public class EuclidGeometryMissingToolsTest {
    @Test
    public void testGetZOnPlane() {
        Point3D point = new Point3D(1.0, 2.0, -3.0);
        Vector3D normal = new Vector3D(0.2, 1.7, 0.4);
        Plane3D plane = new Plane3D((Point3DReadOnly)point, (Vector3DReadOnly)normal);
        double x = 2.33;
        double y = 1.97;
        double z = EuclidGeometryMissingTools.getZOnPlane((Point3DReadOnly)point, (Vector3DReadOnly)normal, (double)x, (double)y);
        Point3D testPoint = new Point3D(x, y, z);
        Assertions.assertTrue((plane.distance((Point3DReadOnly)testPoint) < 1.0E-10 ? 1 : 0) != 0);
        normal = new Vector3D(0.2, 1.7, 0.0);
        z = EuclidGeometryMissingTools.getZOnPlane((Point3DReadOnly)point, (Vector3DReadOnly)normal, (double)x, (double)y);
        Assertions.assertTrue((boolean)Double.isNaN(z));
    }
}

