/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.trajectories.ListOfPointsTrajectory;
import us.ihmc.robotics.trajectories.WaypointMotionGenerator;

public class WaypointMotionGeneratorTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testStraightLineMotion() {
        ArrayList<FramePoint3D> listOfPoints = new ArrayList<FramePoint3D>();
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D startPoint = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
        listOfPoints.add(startPoint);
        FramePoint3D endPoint = new FramePoint3D(referenceFrame, 1.0, 0.0, 0.0);
        listOfPoints.add(endPoint);
        ListOfPointsTrajectory listOfPointsTrajectory = new ListOfPointsTrajectory(listOfPoints);
        double moveDuration = 2.0;
        WaypointMotionGenerator waypointMotionGenerator = new WaypointMotionGenerator(listOfPointsTrajectory, moveDuration);
        FramePoint3D testPoint = waypointMotionGenerator.getCurrentDesiredPoint(0.0);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)startPoint), 1.0E-6);
        testPoint = waypointMotionGenerator.getCurrentDesiredPoint(-1.0);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)startPoint), 1.0E-6);
        testPoint = waypointMotionGenerator.getCurrentDesiredPoint(moveDuration);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)endPoint), 1.0E-6);
        testPoint = waypointMotionGenerator.getCurrentDesiredPoint(moveDuration + 1.0);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)endPoint), 1.0E-6);
        FramePoint3D midPoint = new FramePoint3D((FrameTuple3DReadOnly)startPoint);
        midPoint.add((FrameTuple3DReadOnly)endPoint);
        midPoint.scale(0.5);
        testPoint = waypointMotionGenerator.getCurrentDesiredPoint(moveDuration / 2.0);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)midPoint), 1.0E-6);
        FrameVector3D velocity = waypointMotionGenerator.getCurrentDesiredVelocity(0.0);
        Assert.assertEquals(0.0, velocity.length(), 1.0E-6);
        velocity = waypointMotionGenerator.getCurrentDesiredVelocity(moveDuration);
        Assert.assertEquals(0.0, velocity.length(), 1.0E-6);
        FrameVector3D acceleration = waypointMotionGenerator.getCurrentDesiredAcceleration(0.0);
        Assert.assertEquals(0.0, acceleration.length(), 0.01);
        acceleration = waypointMotionGenerator.getCurrentDesiredAcceleration(moveDuration);
        Assert.assertEquals(0.0, acceleration.length(), 0.01);
    }

    @Test
    public void testThreePointMotion() {
        ArrayList<FramePoint3D> listOfPoints = new ArrayList<FramePoint3D>();
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D startPoint = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
        listOfPoints.add(startPoint);
        FramePoint3D middlePoint = new FramePoint3D(referenceFrame, 1.0, 1.0, 0.0);
        listOfPoints.add(middlePoint);
        FramePoint3D endPoint = new FramePoint3D(referenceFrame, 2.0, 0.0, 0.0);
        listOfPoints.add(endPoint);
        ListOfPointsTrajectory listOfPointsTrajectory = new ListOfPointsTrajectory(listOfPoints);
        double moveDuration = 2.0;
        WaypointMotionGenerator waypointMotionGenerator = new WaypointMotionGenerator(listOfPointsTrajectory, moveDuration);
        FramePoint3D testPoint = waypointMotionGenerator.getCurrentDesiredPoint(moveDuration / 2.0);
        Assert.assertEquals(0.0, testPoint.distance((FramePoint3DReadOnly)middlePoint), 1.0E-6);
    }
}

