/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class TimeIntervalTest {
    @Test
    public void testAccessors() {
        double epsilon = 1.0E-6;
        TimeInterval timeInterval = new TimeInterval(0.0, 1.0);
        Assert.assertEquals(timeInterval.getStartTime(), 0.0, epsilon);
        Assert.assertEquals(timeInterval.getEndTime(), 1.0, epsilon);
        Assert.assertEquals(timeInterval.getDuration(), 1.0, epsilon);
        timeInterval.setInterval(2.0, 3.0);
        Assert.assertEquals(timeInterval.getStartTime(), 2.0, epsilon);
        Assert.assertEquals(timeInterval.getEndTime(), 3.0, epsilon);
        Assert.assertEquals(timeInterval.getDuration(), 1.0, epsilon);
        timeInterval.setStartTime(4.0);
        timeInterval.setEndTime(5.0);
        Assert.assertEquals(timeInterval.getStartTime(), 4.0, epsilon);
        Assert.assertEquals(timeInterval.getEndTime(), 5.0, epsilon);
        Assert.assertEquals(timeInterval.getDuration(), 1.0, epsilon);
        TimeInterval other = new TimeInterval(6.0, 7.0);
        timeInterval.set((TimeIntervalReadOnly)other);
        Assert.assertTrue(timeInterval.epsilonEquals((TimeIntervalReadOnly)other, epsilon));
    }

    @Test
    public void testShiftInterval() {
        double epsilon = 1.0E-6;
        TimeInterval timeInterval = new TimeInterval(0.0, 1.0);
        timeInterval.shiftInterval(10.0);
        Assert.assertEquals(timeInterval.getStartTime(), 10.0, epsilon);
        Assert.assertEquals(timeInterval.getEndTime(), 11.0, epsilon);
    }
}

