/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ExecutionTimerTest {
    private static final long RANDOM_SEED = 1976L;

    @Test
    public void test() {
        ExecutionTimer executionTimer = new ExecutionTimer("executionTimer", 0.0, new YoRegistry("testRegistry"));
        long max = 0L;
        Random random = new Random(1976L);
        for (int i = 0; i < 10; ++i) {
            long delay = (long)(random.nextDouble() * 50.0 + 50.0);
            if (delay > max) {
                max = delay;
            }
            executionTimer.startMeasurement();
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            executionTimer.stopMeasurement();
            Assert.assertEquals((double)delay, executionTimer.getCurrentTime().getDoubleValue() * 1000.0, 10.0);
        }
        Assert.assertEquals((double)max, executionTimer.getMaxTime().getDoubleValue() * 1000.0, 10.0);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(ExecutionTimer.class, ExecutionTimerTest.class);
    }
}

