/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.SimpleState;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.robotics.trajectories.providers.SettableDoubleProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimpleStateTest {
    @Test
    public void testSimpleStateMachine() {
        SettableDoubleProvider timeProvider = new SettableDoubleProvider();
        YoRegistry registry = new YoRegistry("SimpleStateMachine");
        StateMachine stateMachine = new StateMachine("SimpleStateMachine", "switchTime", StateList.class, (DoubleProvider)timeProvider, registry);
        SimpleState<StateList> stateStart = new SimpleState<StateList>(StateList.START, StateList.ONE){

            public void doAction() {
                if (this.getTimeInCurrentState() > 1.0) {
                    this.transitionToDefaultNextState();
                }
            }
        };
        stateMachine.addState((State)stateStart);
        SimpleState<StateList> stateOne = new SimpleState<StateList>(StateList.ONE, StateList.TWO){

            public void doAction() {
                if (this.getTimeInCurrentState() > 2.0) {
                    this.transitionToDefaultNextState();
                }
            }
        };
        stateMachine.addState((State)stateOne);
        SimpleState<StateList> stateTwo = new SimpleState<StateList>(StateList.TWO, StateList.END){

            public void doAction() {
                if (this.getTimeInCurrentState() > 3.0) {
                    this.transitionToDefaultNextState();
                }
            }
        };
        stateMachine.addState((State)stateTwo);
        SimpleState<StateList> stateEnd = new SimpleState<StateList>(StateList.END){

            public void doAction() {
            }
        };
        stateMachine.addState((State)stateEnd);
        Assert.assertEquals(stateStart, stateMachine.getCurrentState());
        stateMachine.setCurrentState((Enum)StateList.START);
        Assert.assertEquals(stateMachine.getCurrentState(), stateStart);
        while (timeProvider.getValue() < 10.0) {
            stateMachine.doAction();
            stateMachine.checkTransitionConditions();
            timeProvider.add(0.01);
        }
        Assert.assertEquals(stateMachine.getCurrentState(), stateEnd);
    }

    private static enum StateList {
        START,
        ONE,
        TWO,
        END;

    }
}

