/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FinishableStateTest {
    @Test
    public void testExampleStateMachineWithFinishableStates() {
        StateMachineFactory factory = new StateMachineFactory(StateEnum.class);
        ExampleFinishableState stateOne = new ExampleFinishableState(StateEnum.ONE);
        ExampleFinishableState stateTwo = new ExampleFinishableState(StateEnum.TWO);
        ExampleFinishableState stateThree = new ExampleFinishableState(StateEnum.THREE);
        factory.addStateAndDoneTransition((Enum)StateEnum.ONE, (State)stateOne, (Enum)StateEnum.TWO);
        factory.addStateAndDoneTransition((Enum)StateEnum.TWO, (State)stateTwo, (Enum)StateEnum.THREE);
        factory.addStateAndDoneTransition((Enum)StateEnum.THREE, (State)stateThree, (Enum)StateEnum.ONE);
        factory.setNamePrefix("example");
        factory.setRegistry(new YoRegistry("dummy"));
        StateMachine stateMachine = factory.build((Enum)StateEnum.ONE);
        stateMachine.doActionAndTransition();
        Assert.assertTrue(stateOne.inState);
        Assert.assertTrue(stateOne.didAction);
        Assert.assertFalse(stateOne.didTransitionOutOfAction);
        stateMachine.doActionAndTransition();
        Assert.assertEquals(stateMachine.getCurrentState(), stateOne);
        Assert.assertTrue(stateOne.didAction);
        Assert.assertFalse(stateOne.didTransitionOutOfAction);
        stateOne.setIsDone(true);
        stateMachine.doActionAndTransition();
        Assert.assertTrue(stateOne.didTransitionOutOfAction);
        Assert.assertTrue(stateTwo.inState);
        Assert.assertTrue(stateTwo.didAction);
        Assert.assertFalse(stateTwo.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), stateTwo);
        stateTwo.setIsDone(true);
        stateMachine.doActionAndTransition();
        Assert.assertTrue(stateTwo.didTransitionOutOfAction);
        Assert.assertTrue(stateThree.inState);
        Assert.assertTrue(stateThree.didAction);
        Assert.assertFalse(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), stateThree);
        stateMachine.doActionAndTransition();
        Assert.assertTrue(stateThree.inState);
        Assert.assertTrue(stateThree.didAction);
        Assert.assertFalse(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), stateThree);
        stateThree.setIsDone(true);
        stateMachine.doActionAndTransition();
        Assert.assertTrue(stateThree.didTransitionOutOfAction);
        Assert.assertEquals(stateMachine.getCurrentState(), stateOne);
    }

    private static enum StateEnum {
        ONE,
        TWO,
        THREE,
        FOUR;

    }

    private class ExampleFinishableState
    implements State {
        private boolean isDone = false;
        public boolean inState = false;
        public boolean didAction = false;
        public boolean didTransitionOutOfAction = false;

        public ExampleFinishableState(StateEnum stateEnum) {
        }

        public void setIsDone(boolean isDone) {
            this.isDone = isDone;
        }

        public boolean isDone(double timeInState) {
            return this.isDone;
        }

        public void doAction(double timeInState) {
            this.didAction = true;
        }

        public void onEntry() {
            this.inState = true;
        }

        public void onExit(double timeInState) {
            this.didTransitionOutOfAction = true;
            this.inState = false;
        }
    }
}

