/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;

public class SelectionMatrix3DTest {
    private static final int ITERATIONS = 1000;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testSettersGetters() throws Exception {
        Random random = new Random(123423L);
        SelectionMatrix3D selectionMatrix3D = new SelectionMatrix3D();
        Assert.assertNull(selectionMatrix3D.getSelectionFrame());
        Assert.assertTrue(selectionMatrix3D.isXSelected());
        Assert.assertTrue(selectionMatrix3D.isYSelected());
        Assert.assertTrue(selectionMatrix3D.isZSelected());
        for (int i = 0; i < 1000; ++i) {
            boolean xSelected = random.nextBoolean();
            boolean ySelected = random.nextBoolean();
            boolean zSelected = random.nextBoolean();
            selectionMatrix3D.setAxisSelection(xSelected, ySelected, zSelected);
            Assert.assertEquals(xSelected, selectionMatrix3D.isXSelected());
            Assert.assertEquals(ySelected, selectionMatrix3D.isYSelected());
            Assert.assertEquals(zSelected, selectionMatrix3D.isZSelected());
            xSelected = random.nextBoolean();
            ySelected = random.nextBoolean();
            zSelected = random.nextBoolean();
            selectionMatrix3D.selectXAxis(xSelected);
            selectionMatrix3D.selectYAxis(ySelected);
            selectionMatrix3D.selectZAxis(zSelected);
            Assert.assertEquals(xSelected, selectionMatrix3D.isXSelected());
            Assert.assertEquals(ySelected, selectionMatrix3D.isYSelected());
            Assert.assertEquals(zSelected, selectionMatrix3D.isZSelected());
            selectionMatrix3D.resetSelection();
            Assert.assertTrue(selectionMatrix3D.isXSelected());
            Assert.assertTrue(selectionMatrix3D.isYSelected());
            Assert.assertTrue(selectionMatrix3D.isZSelected());
            selectionMatrix3D.clearSelection();
            Assert.assertFalse(selectionMatrix3D.isXSelected());
            Assert.assertFalse(selectionMatrix3D.isYSelected());
            Assert.assertFalse(selectionMatrix3D.isZSelected());
            Assert.assertNull(selectionMatrix3D.getSelectionFrame());
            ReferenceFrame randomFrame = EuclidFrameRandomTools.nextReferenceFrame((String)("blop" + i), (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            selectionMatrix3D.setSelectionFrame(randomFrame);
            Assert.assertTrue(randomFrame == selectionMatrix3D.getSelectionFrame());
            selectionMatrix3D.clearSelectionFrame();
            Assert.assertNull(selectionMatrix3D.getSelectionFrame());
            selectionMatrix3D.setSelectionFrame(randomFrame);
            selectionMatrix3D.clearSelection();
            Assert.assertNull(selectionMatrix3D.getSelectionFrame());
            selectionMatrix3D.setSelectionFrame(randomFrame);
            selectionMatrix3D.resetSelection();
            Assert.assertNull(selectionMatrix3D.getSelectionFrame());
        }
    }

    @Test
    public void testApplySelection() {
        Random random = new Random(2342L);
        SelectionMatrix3D selectionMatrix3D = new SelectionMatrix3D();
        FrameMatrix3D frameMatrix3D = new FrameMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 1000; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame vectorFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    FrameVector3D originalVector = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)vectorFrame);
                    FrameVector3D expectedVector = new FrameVector3D((FrameTuple3DReadOnly)originalVector);
                    FrameVector3D actualVector = new FrameVector3D((FrameTuple3DReadOnly)originalVector);
                    boolean xSelected = random.nextBoolean();
                    boolean ySelected = random.nextBoolean();
                    boolean zSelected = random.nextBoolean();
                    selectionMatrix3D.setAxisSelection(xSelected, ySelected, zSelected);
                    selectionMatrix3D.setSelectionFrame(selectionFrame);
                    if (selectionFrame == null) {
                        frameMatrix3D.setToZero(vectorFrame);
                    } else {
                        frameMatrix3D.setToZero(selectionFrame);
                    }
                    frameMatrix3D.setM00(xSelected ? 1.0 : 0.0);
                    frameMatrix3D.setM11(ySelected ? 1.0 : 0.0);
                    frameMatrix3D.setM22(zSelected ? 1.0 : 0.0);
                    frameMatrix3D.changeFrame(vectorFrame);
                    frameMatrix3D.transform((FixedFrameTuple3DBasics)expectedVector);
                    selectionMatrix3D.applySelection(actualVector);
                    Assert.assertEquals(expectedVector.getReferenceFrame(), actualVector.getReferenceFrame());
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)actualVector, (double)1.0E-12);
                }
            }
        }
    }

    @Test
    public void testGetFullSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        SelectionMatrix3D selectionMatrix3D = new SelectionMatrix3D();
        FrameMatrix3D frameMatrix3D = new FrameMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 1000; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    boolean xSelected = random.nextBoolean();
                    boolean ySelected = random.nextBoolean();
                    boolean zSelected = random.nextBoolean();
                    selectionMatrix3D.setAxisSelection(xSelected, ySelected, zSelected);
                    selectionMatrix3D.setSelectionFrame(selectionFrame);
                    frameMatrix3D.setToZero(selectionFrame);
                    frameMatrix3D.setM00(xSelected ? 1.0 : 0.0);
                    frameMatrix3D.setM11(ySelected ? 1.0 : 0.0);
                    frameMatrix3D.setM22(zSelected ? 1.0 : 0.0);
                    selectionMatrix3D.getFullSelectionMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    if (selectionFrame != null) {
                        frameMatrix3D.changeFrame(destinationFrame);
                    }
                    frameMatrix3D.get((DMatrix)expectedSelectionMatrix);
                    SelectionMatrix3DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                    DMatrixRMaj expectedSubspaceVector = new DMatrixRMaj(3, 1);
                    DMatrixRMaj actualSubspaceVector = new DMatrixRMaj(3, 1);
                    FrameVector3D randomVector = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)destinationFrame);
                    DMatrixRMaj originalVector = new DMatrixRMaj(3, 1);
                    randomVector.get((DMatrix)originalVector);
                    selectionMatrix3D.getFullSelectionMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    CommonOps_DDRM.mult((DMatrix1Row)expectedSelectionMatrix, (DMatrix1Row)originalVector, (DMatrix1Row)actualSubspaceVector);
                    if (selectionFrame != null) {
                        randomVector.changeFrame(selectionFrame);
                    }
                    if (!xSelected) {
                        randomVector.setX(0.0);
                    }
                    if (!ySelected) {
                        randomVector.setY(0.0);
                    }
                    if (!zSelected) {
                        randomVector.setZ(0.0);
                    }
                    if (selectionFrame != null) {
                        randomVector.changeFrame(destinationFrame);
                    }
                    randomVector.get((DMatrix)expectedSubspaceVector);
                    SelectionMatrix3DTest.assertMatrixEquals(expectedSubspaceVector, actualSubspaceVector, 1.0E-12);
                }
            }
        }
    }

    @Test
    public void testGetEfficientSelectionMatrixInFrame() throws Exception {
        Random random = new Random(456465L);
        SelectionMatrix3D selectionMatrix3D = new SelectionMatrix3D();
        RigidBodyTransform randomTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<ReferenceFrame> referenceFrames = new ArrayList<ReferenceFrame>();
        referenceFrames.add(null);
        referenceFrames.add(ReferenceFrame.getWorldFrame());
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        referenceFrames.add(EuclidFrameRandomTools.nextReferenceFrame((String)"blop2", (Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame()));
        referenceFrames.add(ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"blop1Bis", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)randomTransform));
        for (int i = 0; i < 1000; ++i) {
            for (ReferenceFrame selectionFrame : referenceFrames) {
                for (ReferenceFrame destinationFrame : referenceFrames.subList(1, referenceFrames.size())) {
                    DMatrixRMaj actualSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    DMatrixRMaj expectedSelectionMatrix = RandomMatrices_DDRM.rectangle((int)3, (int)3, (double)-1.0, (double)1.0, (Random)random);
                    boolean xSelected = random.nextBoolean();
                    boolean ySelected = random.nextBoolean();
                    boolean zSelected = random.nextBoolean();
                    selectionMatrix3D.setAxisSelection(xSelected, ySelected, zSelected);
                    selectionMatrix3D.setSelectionFrame(selectionFrame);
                    selectionMatrix3D.getFullSelectionMatrixInFrame(destinationFrame, expectedSelectionMatrix);
                    MatrixTools.removeZeroRows((DMatrix1Row)expectedSelectionMatrix, (double)1.0E-7);
                    selectionMatrix3D.getEfficientSelectionMatrixInFrame(destinationFrame, actualSelectionMatrix);
                    SelectionMatrix3DTest.assertMatrixEquals(expectedSelectionMatrix, actualSelectionMatrix, 1.0E-12);
                }
            }
        }
    }

    private static void assertMatrixEquals(DMatrixRMaj expected, DMatrixRMaj actual, double epsilon) {
        Assert.assertTrue(SelectionMatrix3DTest.assertErrorMessage(expected, actual), MatrixFeatures_DDRM.isEquals((DMatrixD1)expected, (DMatrixD1)actual, (double)epsilon));
    }

    private static String assertErrorMessage(DMatrixRMaj expected, DMatrixRMaj actual) {
        return "Expected:\n" + expected + "\nActual:\n" + actual;
    }
}

