/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.screwTheory.PointJacobian;

public class PointJacobianTest {
    private static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    private static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    private static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testVersusNumericalDifferentiation() {
        Random random = new Random(1252523L);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomFloatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        randomFloatingChain.nextState(random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        RigidBodyBasics base = randomFloatingChain.getRootJoint().getSuccessor();
        RigidBodyBasics endEffector = randomFloatingChain.getLeafBody();
        GeometricJacobian geometricJacobian = new GeometricJacobian(base, endEffector, (ReferenceFrame)base.getBodyFixedFrame());
        geometricJacobian.compute();
        FramePoint3D point = new FramePoint3D((ReferenceFrame)base.getBodyFixedFrame(), (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        PointJacobian pointJacobian = new PointJacobian();
        pointJacobian.set(geometricJacobian, (FramePoint3DReadOnly)point);
        pointJacobian.compute();
        JointBasics[] joints = geometricJacobian.getJointsInOrder();
        DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])joints), 1);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
        DMatrixRMaj pointVelocityFromJacobianMatrix = new DMatrixRMaj(3, 1);
        CommonOps_DDRM.mult((DMatrix1Row)pointJacobian.getJacobianMatrix(), (DMatrix1Row)jointVelocities, (DMatrix1Row)pointVelocityFromJacobianMatrix);
        FrameVector3D pointVelocityFromJacobian = new FrameVector3D(pointJacobian.getFrame());
        pointVelocityFromJacobian.set((DMatrix)pointVelocityFromJacobianMatrix);
        FramePoint3D point2 = new FramePoint3D((FrameTuple3DReadOnly)point);
        point2.changeFrame((ReferenceFrame)endEffector.getBodyFixedFrame());
        double dt = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        integrator.integrateFromVelocity(randomFloatingChain.getRevoluteJoints());
        randomFloatingChain.getElevator().updateFramesRecursively();
        point2.changeFrame((ReferenceFrame)base.getBodyFixedFrame());
        FrameVector3D pointVelocityFromNumericalDifferentiation = new FrameVector3D((FrameTuple3DReadOnly)point2);
        pointVelocityFromNumericalDifferentiation.sub((FrameTuple3DReadOnly)point);
        pointVelocityFromNumericalDifferentiation.scale(1.0 / dt);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)pointVelocityFromNumericalDifferentiation, (EuclidFrameGeometry)pointVelocityFromJacobian, (double)1.0E-6);
    }

    @Test
    public void testSingularValuesOfTwoPointJacobians() {
        Random random = new Random(12351235L);
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Y, Y, X};
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomFloatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        randomFloatingChain.nextState(random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        RigidBodyBasics base = randomFloatingChain.getRootJoint().getSuccessor();
        RigidBodyBasics endEffector = randomFloatingChain.getLeafBody();
        GeometricJacobian geometricJacobian = new GeometricJacobian(base, endEffector, (ReferenceFrame)base.getBodyFixedFrame());
        geometricJacobian.compute();
        FramePoint3D point1 = new FramePoint3D((ReferenceFrame)base.getBodyFixedFrame(), (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        FramePoint3D point2 = new FramePoint3D((ReferenceFrame)base.getBodyFixedFrame(), (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        PointJacobian pointJacobian1 = new PointJacobian();
        pointJacobian1.set(geometricJacobian, (FramePoint3DReadOnly)point1);
        pointJacobian1.compute();
        PointJacobian pointJacobian2 = new PointJacobian();
        pointJacobian2.set(geometricJacobian, (FramePoint3DReadOnly)point2);
        pointJacobian2.compute();
        DMatrixRMaj assembledJacobian = new DMatrixRMaj(6, geometricJacobian.getNumberOfColumns());
        CommonOps_DDRM.insert((DMatrix)pointJacobian1.getJacobianMatrix(), (DMatrix)assembledJacobian, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)pointJacobian2.getJacobianMatrix(), (DMatrix)assembledJacobian, (int)3, (int)0);
        SingularValueDecomposition_F64 svd = DecompositionFactory_DDRM.svd((int)assembledJacobian.getNumRows(), (int)assembledJacobian.getNumCols(), (boolean)true, (boolean)true, (boolean)false);
        svd.decompose((Matrix)assembledJacobian);
        double[] singularValues = svd.getSingularValues();
        double smallestSingularValue = Double.POSITIVE_INFINITY;
        for (double singularValue : singularValues) {
            if (!(singularValue < smallestSingularValue)) continue;
            smallestSingularValue = singularValue;
        }
        double epsilon = 1.0E-12;
        Assert.assertTrue(smallestSingularValue < epsilon);
    }
}

