/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.tools.MemoryTools;

public class ReferenceFrameMemoryTest {
    @Test
    public void testGarbageCollectionInBroadTrees() {
        int beforeMemoryInMB = MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)"ReferenceFrameTest: before");
        ReferenceFrame world = ReferenceFrame.getWorldFrame();
        ArrayList<PoseReferenceFrame> testFrames = new ArrayList<PoseReferenceFrame>();
        for (int i = 0; i < 100000; ++i) {
            PoseReferenceFrame testFrame = new PoseReferenceFrame("test_" + i, world);
            testFrames.add(testFrame);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        int duringMemoryInMB = MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMBWithoutGarbageCollecting((String)"ReferenceFrameTest: during");
        Assertions.assertTrue((duringMemoryInMB - beforeMemoryInMB > 20 ? 1 : 0) != 0);
        int afterMemoryInMB = MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)"ReferenceFrameTest: after");
        Assertions.assertTrue((afterMemoryInMB - beforeMemoryInMB < 140 ? 1 : 0) != 0, (String)("afterMemoryInMB - beforeMemoryInMB = " + (afterMemoryInMB - beforeMemoryInMB)));
        testFrames = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        afterMemoryInMB = MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)"ReferenceFrameTest: after testFrames = null");
        Assertions.assertTrue((afterMemoryInMB - beforeMemoryInMB < 10 ? 1 : 0) != 0);
    }
}

