/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.referenceFrames;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.CenterOfMassCalculator;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.robotics.random.RandomGeometry;

public class CenterOfMassReferenceFrameTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testRandomChain() {
        Random random = new Random(124L);
        int nJoints = 10;
        ArrayList joints = new ArrayList(nJoints);
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        SixDoFJoint sixDoFJoint = new SixDoFJoint("sixDoF", (RigidBodyBasics)elevator);
        RigidBody floatingBody = new RigidBody("floatingBody", (JointBasics)sixDoFJoint, (Matrix3DReadOnly)RandomGeometry.nextDiagonalMatrix3D((Random)random), random.nextDouble(), (Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        Vector3D[] jointAxes = new Vector3D[nJoints];
        for (int i = 0; i < nJoints; ++i) {
            jointAxes[i] = RandomGeometry.nextVector3D((Random)random);
        }
        joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (String)"test", (RigidBodyBasics)floatingBody, (Vector3DReadOnly[])jointAxes));
        CenterOfMassReferenceFrame centerOfMassReferenceFrame = new CenterOfMassReferenceFrame("com", (ReferenceFrame)elevator.getBodyFixedFrame(), (RigidBodyReadOnly)elevator);
        sixDoFJoint.setJointPosition((Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random));
        sixDoFJoint.getJointPose().getOrientation().setYawPitchRoll(random.nextDouble(), random.nextDouble(), random.nextDouble());
        for (RevoluteJoint joint : joints) {
            joint.setQ(random.nextDouble());
        }
        elevator.updateFramesRecursively();
        centerOfMassReferenceFrame.update();
        CenterOfMassCalculator comCalculator = new CenterOfMassCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)elevator.getBodyFixedFrame());
        comCalculator.reset();
        FramePoint3D centerOfMass = new FramePoint3D((FrameTuple3DReadOnly)comCalculator.getCenterOfMass());
        FramePoint3D centerOfMassFromFrame = new FramePoint3D((ReferenceFrame)centerOfMassReferenceFrame);
        centerOfMassFromFrame.changeFrame((ReferenceFrame)elevator.getBodyFixedFrame());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)centerOfMass, (EuclidGeometry)centerOfMassFromFrame, (double)1.0E-12);
        RotationMatrix rotation = new RotationMatrix();
        RigidBodyTransform transform = centerOfMassReferenceFrame.getTransformToDesiredFrame((ReferenceFrame)elevator.getBodyFixedFrame());
        rotation.set((RotationMatrixReadOnly)transform.getRotation());
        RotationMatrix idenitity = new RotationMatrix();
        idenitity.setIdentity();
        EuclidCoreTestTools.assertMatrix3DEquals((String)"", (Matrix3DReadOnly)idenitity, (Matrix3DReadOnly)rotation, (double)1.0E-12);
    }
}

