/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.random;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.random.RandomGeometry;

public class RandomGeometryTest {
    @Test
    public void testNextPoint3D32() {
        Random random = new Random();
        Point3D32 min = new Point3D32(-7.0f, -5.0f, -6.0f);
        Point3D32 max = new Point3D32(5.0f, 4.0f, 8.0f);
        for (int i = 0; i < 1000; ++i) {
            Point3D32 randomPoint3f = RandomGeometry.nextPoint3D32((Random)random, (Tuple3DReadOnly)min, (Tuple3DReadOnly)max);
            Assert.assertTrue(randomPoint3f.getX() >= -7.0 && randomPoint3f.getX() <= 5.0);
            Assert.assertTrue(randomPoint3f.getY() >= -5.0 && randomPoint3f.getY() <= 4.0);
            Assert.assertTrue(randomPoint3f.getZ() >= -6.0 && randomPoint3f.getZ() <= 8.0);
        }
    }

    @Test
    public void testNextPoint3D32Array() {
        Random random = new Random();
        Point3D32 min = new Point3D32(-7.0f, -5.0f, -6.0f);
        Point3D32 max = new Point3D32(5.0f, 4.0f, 8.0f);
        Point3D32[] randomPoint3fCloud = RandomGeometry.nextPoint3D32Array((Random)random, (int)1000, (Tuple3DReadOnly)min, (Tuple3DReadOnly)max);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertTrue(randomPoint3fCloud[i].getX() >= -7.0 && randomPoint3fCloud[i].getX() <= 5.0);
            Assert.assertTrue(randomPoint3fCloud[i].getY() >= -5.0 && randomPoint3fCloud[i].getY() <= 4.0);
            Assert.assertTrue(randomPoint3fCloud[i].getZ() >= -6.0 && randomPoint3fCloud[i].getZ() <= 8.0);
        }
    }

    @Test
    public void testNextPoint3D() {
        Random random = new Random(4876L);
        double[] range1 = new double[]{0.0, 0.0, 0.0};
        double[] range2 = new double[]{12.0, 12.0, 12.0};
        for (int i = 0; i < 25; ++i) {
            Point3D point = RandomGeometry.nextPoint3D((Random)random, (double[])range1, (double[])range2);
            Assert.assertTrue(range1[0] < point.getX() && point.getX() < range2[0]);
            Assert.assertTrue(range1[1] < point.getY() && point.getY() < range2[1]);
            Assert.assertTrue(range1[2] < point.getZ() && point.getZ() < range2[2]);
        }
    }

    @Test
    public void testNextVector3D() {
        Random random = new Random(4876L);
        Point3D boundary1 = new Point3D(0.0, 0.0, 0.0);
        Point3D boundary2 = new Point3D(12.0, 12.0, 12.0);
        for (int i = 0; i < 25; ++i) {
            Vector3D vector = RandomGeometry.nextVector3D((Random)random, (Tuple3DReadOnly)boundary1, (Tuple3DReadOnly)boundary2);
            Assert.assertTrue(boundary1.getX() < vector.getX() && vector.getX() < boundary2.getX());
            Assert.assertTrue(boundary1.getY() < vector.getY() && vector.getY() < boundary2.getY());
            Assert.assertTrue(boundary1.getZ() < vector.getZ() && vector.getZ() < boundary2.getZ());
        }
    }

    @Test
    public void testNextOrthogonalVector3D() {
        Random random = new Random(4876L);
        for (int i = 0; i < 100; ++i) {
            double length = RandomNumbers.nextDouble((Random)random, (double)0.1, (double)100.0);
            Vector3D vector = RandomGeometry.nextVector3D((Random)random, (double)length);
            Vector3D orthoVector = RandomGeometry.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)vector, (boolean)true);
            Assert.assertEquals(0.0, vector.dot((Tuple3DReadOnly)orthoVector), 1.0E-12);
            Assert.assertEquals(1.0, orthoVector.length(), 1.0E-12);
        }
    }
}

