/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.physics.ConstraintParameters;
import us.ihmc.robotics.physics.ConstraintParametersReadOnly;
import us.ihmc.robotics.physics.RobotJointLimitImpulseBasedCalculator;

public class RobotJointLimitImpulseBasedCalculatorTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testRevoluteChainSingleLimit() {
        Random random = new Random(45436L);
        for (int i = 0; i < 1000; ++i) {
            boolean isJointApproachingLimit;
            double jointLimitUpper;
            double jointLimitLower;
            double dt = random.nextDouble();
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            for (JointStateType state : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, (Iterable)joints);
            }
            int jointIndex = random.nextInt(numberOfJoints);
            RevoluteJoint joint = (RevoluteJoint)joints.get(jointIndex);
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)joint.getPredecessor());
            ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)rootBody);
            forwardDynamicsCalculator.compute();
            double q = joint.getQ();
            double qd = joint.getQd();
            double qdd = forwardDynamicsCalculator.getComputedJointAcceleration((JointReadOnly)joint).get(0);
            if (random.nextBoolean()) {
                jointLimitLower = q + 1.0E-12;
                jointLimitUpper = q + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
                isJointApproachingLimit = q + dt * qd + 0.5 * dt * dt * qdd <= jointLimitLower && qd + dt * qdd <= 0.0;
            } else {
                jointLimitLower = q - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
                jointLimitUpper = q - 1.0E-12;
                isJointApproachingLimit = q + dt * qd + 0.5 * dt * dt * qdd >= jointLimitUpper && qd + dt * qdd >= 0.0;
            }
            joint.setJointLimits(jointLimitLower, jointLimitUpper);
            RobotJointLimitImpulseBasedCalculator calculator = new RobotJointLimitImpulseBasedCalculator(rootBody, forwardDynamicsCalculator);
            calculator.setConstraintParameters((ConstraintParametersReadOnly)new ConstraintParameters(0.0, 0.0, 0.0));
            calculator.initialize(dt);
            calculator.updateInertia(null, null);
            calculator.computeImpulse(dt);
            String message = "Iteration " + i;
            Assertions.assertEquals((Object)isJointApproachingLimit, (Object)calculator.isConstraintActive(), (String)message);
            if (!calculator.isConstraintActive()) continue;
            DMatrixRMaj jointVelocities = new DMatrixRMaj(joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum(), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            CommonOps_DDRM.addEquals((DMatrixD1)jointVelocities, (double)dt, (DMatrixD1)forwardDynamicsCalculator.getJointAccelerationMatrix());
            CommonOps_DDRM.addEquals((DMatrixD1)jointVelocities, (DMatrixD1)calculator.getJointVelocityChange(0));
            MultiBodySystemTools.insertJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            Assertions.assertEquals((double)0.0, (double)joint.getQd(), (double)1.0E-12, (String)message);
        }
    }

    @Test
    public void testRevoluteChainMultipleLimit() {
        Random random = new Random(45436L);
        for (int i = 0; i < 1000; ++i) {
            double dt = random.nextDouble();
            int numberOfJoints = 20;
            List joints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
            for (JointStateType state : JointStateType.values()) {
                MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)state, (Iterable)joints);
            }
            RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((RevoluteJoint)joints.get(0)).getPredecessor());
            ForwardDynamicsCalculator forwardDynamicsCalculator = new ForwardDynamicsCalculator((RigidBodyReadOnly)rootBody);
            forwardDynamicsCalculator.compute();
            int numberOfJointsToPutAtLimit = random.nextInt(numberOfJoints);
            ArrayList jointPool = new ArrayList(joints);
            for (int j = 0; j < numberOfJointsToPutAtLimit; ++j) {
                double jointLimitUpper;
                double jointLimitLower;
                int jointIndex = random.nextInt(jointPool.size());
                RevoluteJoint joint = (RevoluteJoint)jointPool.remove(jointIndex);
                double q = joint.getQ();
                if (random.nextBoolean()) {
                    jointLimitLower = q + 1.0E-12;
                    jointLimitUpper = q + EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
                } else {
                    jointLimitLower = q - EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)10.0);
                    jointLimitUpper = q - 1.0E-12;
                }
                joint.setJointLimits(jointLimitLower, jointLimitUpper);
            }
            RobotJointLimitImpulseBasedCalculator calculator = new RobotJointLimitImpulseBasedCalculator(rootBody, forwardDynamicsCalculator);
            calculator.setConstraintParameters((ConstraintParametersReadOnly)new ConstraintParameters(0.0, 0.0, 0.0));
            calculator.initialize(dt);
            calculator.updateInertia(null, null);
            calculator.computeImpulse(dt);
            String message = "Iteration " + i;
            if (!calculator.isConstraintActive()) continue;
            DMatrixRMaj jointVelocities = new DMatrixRMaj(joints.stream().mapToInt(JointReadOnly::getDegreesOfFreedom).sum(), 1);
            MultiBodySystemTools.extractJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            CommonOps_DDRM.addEquals((DMatrixD1)jointVelocities, (double)dt, (DMatrixD1)forwardDynamicsCalculator.getJointAccelerationMatrix());
            CommonOps_DDRM.addEquals((DMatrixD1)jointVelocities, (DMatrixD1)calculator.getJointVelocityChange(0));
            MultiBodySystemTools.insertJointsState((List)joints, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
            List activeLimits = calculator.getActiveLimits();
            List jointsAtLimit = calculator.getJointTargets();
            for (int j = 0; j < jointsAtLimit.size(); ++j) {
                OneDoFJointBasics joint = (OneDoFJointBasics)jointsAtLimit.get(j);
                double jointImpulse = calculator.getImpulse().get(j);
                Assertions.assertEquals((double)0.0, (double)(joint.getQd() * jointImpulse), (double)1.0E-12);
                if (activeLimits.get(j) == RobotJointLimitImpulseBasedCalculator.ActiveLimit.LOWER) {
                    Assertions.assertTrue((jointImpulse >= -1.0E-12 ? 1 : 0) != 0, (String)message);
                    Assertions.assertTrue((joint.getQd() >= -0.001 ? 1 : 0) != 0, (String)message);
                    continue;
                }
                Assertions.assertTrue((jointImpulse <= 1.0E-12 ? 1 : 0) != 0, (String)message);
                Assertions.assertTrue((joint.getQd() <= 0.001 ? 1 : 0) != 0, (String)message);
            }
        }
    }
}

