/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.optimization;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.optimization.ActiveSearchOptimizationSettings;
import us.ihmc.robotics.optimization.ActiveSearchQuadraticProgramOptimizer;
import us.ihmc.robotics.optimization.ActiveSearchSolutionInfo;
import us.ihmc.robotics.optimization.QuadraticProgram;

public class ActiveSearchQuadraticProgramOptimizerTest {
    @Test
    public void testUnconstrained() {
        Random random = new Random(12355L);
        int objectiveSize = 5;
        int solutionSize = 5;
        int constraintSize = 0;
        QuadraticProgram quadraticProgram = ActiveSearchQuadraticProgramOptimizerTest.createRandomQuadraticProgram(random, objectiveSize, solutionSize, constraintSize);
        DMatrixRMaj initialGuess = new DMatrixRMaj(solutionSize, 1);
        ActiveSearchSolutionInfo solutionInfo = this.solve(quadraticProgram, initialGuess);
        Assert.assertTrue(solutionInfo.isConverged());
        DMatrixRMaj axMinusB = new DMatrixRMaj(solutionSize, 1);
        CommonOps_DDRM.mult((DMatrix1Row)quadraticProgram.getA(), (DMatrix1Row)solutionInfo.getSolution(), (DMatrix1Row)axMinusB);
        CommonOps_DDRM.subtractEquals((DMatrixD1)axMinusB, (DMatrixD1)quadraticProgram.getB());
        Assert.assertTrue(MatrixFeatures_DDRM.isConstantVal((DMatrixRMaj)axMinusB, (double)0.0, (double)1.0E-12));
    }

    @Test
    public void testConstrainedSimple() {
        int objectiveSize = 3;
        int solutionSize = 3;
        int constraintSize = 1;
        DMatrixRMaj a = new DMatrixRMaj(objectiveSize, solutionSize);
        CommonOps_DDRM.setIdentity((DMatrix1Row)a);
        DMatrixRMaj b = new DMatrixRMaj(objectiveSize, 1);
        b.zero();
        DMatrixRMaj c = new DMatrixRMaj(constraintSize, solutionSize);
        CommonOps_DDRM.setIdentity((DMatrix1Row)c);
        DMatrixRMaj d = new DMatrixRMaj(constraintSize, 1);
        d.set(0, 0, -1.0);
        QuadraticProgram quadraticProgram = new QuadraticProgram(a, b, c, d);
        DMatrixRMaj initialGuess = new DMatrixRMaj(solutionSize, 1);
        initialGuess.set(0, 0, -10.0);
        initialGuess.set(1, 0, -10.0);
        initialGuess.set(2, 0, -10.0);
        ActiveSearchSolutionInfo solutionInfo = this.solve(quadraticProgram, initialGuess);
        Assert.assertTrue(solutionInfo.isConverged());
        DMatrixRMaj expectedResult = new DMatrixRMaj(solutionSize, 1);
        expectedResult.set(0, 0, d.get(0, 0));
        expectedResult.set(1, 0, 0.0);
        expectedResult.set(2, 0, 0.0);
        Assert.assertTrue(MatrixFeatures_DDRM.isEquals((DMatrixD1)expectedResult, (DMatrixD1)solutionInfo.getSolution(), (double)1.0E-12));
    }

    @Disabled
    @Test
    public void testFullyConstrained() {
        int objectiveSize = 3;
        int solutionSize = 5;
        int constraintSize = 5;
        Random random = new Random(1235125L);
        QuadraticProgram quadraticProgram = ActiveSearchQuadraticProgramOptimizerTest.createRandomQuadraticProgram(random, objectiveSize, solutionSize, constraintSize);
        DMatrixRMaj initialGuess = new DMatrixRMaj(solutionSize, 1);
        CommonOps_DDRM.solve((DMatrixRMaj)quadraticProgram.getC(), (DMatrixRMaj)quadraticProgram.getD(), (DMatrixRMaj)initialGuess);
        ActiveSearchSolutionInfo solutionInfo = this.solve(quadraticProgram, initialGuess);
        Assert.assertTrue(solutionInfo.isConverged());
    }

    private ActiveSearchSolutionInfo solve(QuadraticProgram quadraticProgram, DMatrixRMaj initialGuess) {
        ActiveSearchOptimizationSettings settings = new ActiveSearchOptimizationSettings(1.0E-12, 50, true);
        ActiveSearchQuadraticProgramOptimizer optimizer = new ActiveSearchQuadraticProgramOptimizer(settings);
        optimizer.setQuadraticProgram(quadraticProgram);
        optimizer.solve(initialGuess);
        return optimizer.getSolutionInfo();
    }

    private static QuadraticProgram createRandomQuadraticProgram(Random random, int objectiveSize, int solutionSize, int constraintSize) {
        DMatrixRMaj a = RandomMatrices_DDRM.rectangle((int)objectiveSize, (int)solutionSize, (Random)random);
        DMatrixRMaj b = RandomMatrices_DDRM.rectangle((int)objectiveSize, (int)1, (Random)random);
        DMatrixRMaj c = RandomMatrices_DDRM.rectangle((int)constraintSize, (int)solutionSize, (Random)random);
        DMatrixRMaj d = RandomMatrices_DDRM.rectangle((int)constraintSize, (int)1, (Random)random);
        return new QuadraticProgram(a, b, c, d);
    }
}

