/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.math.trajectories.HermiteCurveBasedOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.SimpleHermiteCurvedBasedOrientationTrajectoryCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimpleHermiteCurvedBasedOrientationTrajectoryCalculatorTest {
    @Test
    public void compareWithHermiteCurvedBasedOrientationTrajectoryGenerator() {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(394L);
        double dt = 0.01;
        double startIntegrationTime = 0.0;
        double endIntegrationTime = 1.0;
        FrameQuaternion currentOrientation = new FrameQuaternion();
        FrameVector3D currentAngularVelocity = new FrameVector3D();
        FrameVector3D currentAngularAcceleration = new FrameVector3D();
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameVector3D initialAngularVelocity = new FrameVector3D(worldFrame);
        FrameVector3D finalAngularVelocity = new FrameVector3D(worldFrame);
        System.out.println("## " + initialOrientation + " " + finalOrientation);
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        traj.setTrajectoryTime(endIntegrationTime - startIntegrationTime);
        traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)initialAngularVelocity);
        traj.setFinalConditions((FrameOrientation3DReadOnly)finalOrientation, (FrameVector3DReadOnly)finalAngularVelocity);
        traj.initialize();
        SimpleHermiteCurvedBasedOrientationTrajectoryCalculator trajCalculator = new SimpleHermiteCurvedBasedOrientationTrajectoryCalculator();
        trajCalculator.setTrajectoryTime(endIntegrationTime - startIntegrationTime);
        trajCalculator.setInitialConditions((QuaternionReadOnly)initialOrientation, (Vector3DReadOnly)initialAngularVelocity);
        trajCalculator.setFinalConditions((QuaternionReadOnly)finalOrientation, (Vector3DReadOnly)finalAngularVelocity);
        trajCalculator.setConvertingAngularVelocity(true);
        trajCalculator.setConvertingAngularAcceleration(true);
        trajCalculator.setNumberOfRevolutions(0);
        trajCalculator.initialize();
        for (double time = startIntegrationTime; time <= endIntegrationTime; time += dt) {
            traj.compute(time);
            traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
            trajCalculator.compute(time);
            Quaternion orientation = new Quaternion();
            Vector3D angularVelocity = new Vector3D();
            Vector3D angularAcceleration = new Vector3D();
            trajCalculator.getOrientation((QuaternionBasics)orientation);
            trajCalculator.getAngularVelocity(angularVelocity);
            trajCalculator.getAngularAcceleration(angularAcceleration);
            boolean angularVelocityEquals = currentAngularVelocity.epsilonEquals((EuclidGeometry)angularVelocity, 0.001);
            boolean angularAccelerationEquals = currentAngularAcceleration.epsilonEquals((EuclidGeometry)angularAcceleration, 0.001);
            Assertions.assertTrue((boolean)angularVelocityEquals, (String)"result is to far from the result of the original trajectory generator.");
            Assertions.assertTrue((boolean)angularAccelerationEquals, (String)"result is to far from the result of the original trajectory generator.");
        }
    }
}

