/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;

public abstract class Polynomial3DBasicsTest {
    protected static final int ITERATIONS = 1000;
    protected static final double SMALL_EPSILON = 1.0E-12;

    public abstract Polynomial3DBasics getPolynomial(int var1);

    @Test
    public void testLinearSet() {
        Polynomial3DBasics traj = this.getPolynomial(2);
        Assert.assertEquals(2L, traj.getMaximumNumberOfCoefficients());
        Assert.assertEquals(0L, traj.getNumberOfCoefficients());
        Point3D start = new Point3D(3.0, 4.0, 5.0);
        Point3D end = new Point3D(6.0, 7.0, 8.0);
        traj.setLinear(1.0, 2.0, (Point3DReadOnly)start, (Point3DReadOnly)end);
        Assert.assertEquals(1.0, traj.getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getTimeInterval().getEndTime(), 1.0E-12);
        traj.compute(traj.getTimeInterval().getStartTime());
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)start, (Point3DReadOnly)traj.getPosition(), (double)1.0E-12);
        traj.compute(traj.getTimeInterval().getEndTime());
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)end, (Point3DReadOnly)traj.getPosition(), (double)1.0E-12);
    }

    @Test
    public void testTimeInterval() {
        Polynomial3DBasics traj = this.getPolynomial(2);
        Assert.assertEquals(2L, traj.getMaximumNumberOfCoefficients());
        Assert.assertEquals(0L, traj.getNumberOfCoefficients());
        Point3D start = new Point3D(3.0, 4.0, 5.0);
        Point3D end = new Point3D(6.0, 7.0, 8.0);
        traj.setLinear(1.0, 2.0, (Point3DReadOnly)start, (Point3DReadOnly)end);
        Assert.assertEquals(1.0, traj.getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getTimeInterval().getEndTime(), 1.0E-12);
        traj.compute(traj.getTimeInterval().getStartTime());
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)start, (Point3DReadOnly)traj.getPosition(), (double)1.0E-12);
        traj.compute(traj.getTimeInterval().getEndTime());
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)end, (Point3DReadOnly)traj.getPosition(), (double)1.0E-12);
        Assert.assertEquals(1.0, traj.getAxis(Axis3D.X).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(1.0, traj.getAxis(Axis3D.Y).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(1.0, traj.getAxis(Axis3D.Z).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getAxis(Axis3D.X).getTimeInterval().getEndTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getAxis(Axis3D.Y).getTimeInterval().getEndTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getAxis(Axis3D.Z).getTimeInterval().getEndTime(), 1.0E-12);
        traj.getTimeInterval().setInterval(3.5, 7.2);
        Assert.assertEquals(3.5, traj.getAxis(Axis3D.X).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(3.5, traj.getAxis(Axis3D.Y).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(3.5, traj.getAxis(Axis3D.Z).getTimeInterval().getStartTime(), 1.0E-12);
        Assert.assertEquals(7.2, traj.getAxis(Axis3D.X).getTimeInterval().getEndTime(), 1.0E-12);
        Assert.assertEquals(7.2, traj.getAxis(Axis3D.Y).getTimeInterval().getEndTime(), 1.0E-12);
        Assert.assertEquals(7.2, traj.getAxis(Axis3D.Z).getTimeInterval().getEndTime(), 1.0E-12);
    }

    @Test
    public void testExceptionThrownAfterShift() {
        Polynomial3DBasics trajectory = this.getPolynomial(5);
        Point3D start = new Point3D(3.0, 4.0, 5.0);
        Point3D end = new Point3D(6.0, 7.0, 8.0);
        trajectory.setCubic(0.0, 5.0, (Point3DReadOnly)start, (Vector3DReadOnly)new Vector3D(), (Point3DReadOnly)end, (Vector3DReadOnly)new Vector3D());
        boolean caughtException = false;
        try {
            trajectory.initialize();
        }
        catch (RuntimeException e) {
            caughtException = true;
        }
        Assert.assertFalse(caughtException);
        trajectory.shiftTrajectory(0.5, 0.6, 0.76);
        try {
            trajectory.initialize();
        }
        catch (RuntimeException e) {
            caughtException = true;
        }
        Assert.assertTrue(caughtException);
    }

    @Test
    public void testSetConstant() {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            Polynomial3DBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + random.nextDouble();
            Point3D z = EuclidCoreRandomTools.nextPoint3D((Random)random);
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            if (maxNumberOfCoefficients < 1) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> Polynomial3DBasicsTest.lambda$testSetConstant$0(trajectory, t0, tf, (Point3DReadOnly)z));
                continue;
            }
            trajectory.setConstant(t0, tf, (Tuple3DReadOnly)z);
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)z, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testSetLinear() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            Point3D expected;
            double t;
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            Polynomial3DBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + random.nextDouble();
            Point3D z0 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            Point3D zf = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            if (maxNumberOfCoefficients < 2) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> Polynomial3DBasicsTest.lambda$testSetLinear$1(trajectory, t0, tf, (Point3DReadOnly)z0, (Point3DReadOnly)zf));
                continue;
            }
            trajectory.setLinear(t0, tf, (Point3DReadOnly)z0, (Point3DReadOnly)zf);
            Vector3D zDot = new Vector3D();
            zDot.sub((Tuple3DReadOnly)zf, (Tuple3DReadOnly)z0);
            zDot.scale(1.0 / (tf - t0));
            Polynomial3DBasics derivative = this.getPolynomial(1);
            derivative.setConstant(t0, tf, (Tuple3DReadOnly)zDot);
            trajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)z0, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            trajectory.compute(tf);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)zf, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            for (t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                expected = new Point3D();
                expected.interpolate((Tuple3DReadOnly)z0, (Tuple3DReadOnly)zf, (t - t0) / (tf - t0));
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expected, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
                derivative.compute(t);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)derivative.getPosition(), (EuclidGeometry)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)derivative.getVelocity(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            }
            trajectory.setLinear(t0, (Point3DReadOnly)z0, (Vector3DReadOnly)zDot);
            derivative = this.getPolynomial(1);
            derivative.setConstant(t0, tf, (Tuple3DReadOnly)zDot);
            trajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)z0, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            trajectory.compute(tf);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)zf, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            for (t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                expected = new Point3D();
                expected.interpolate((Tuple3DReadOnly)z0, (Tuple3DReadOnly)zf, (t - t0) / (tf - t0));
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expected, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zDot, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
                derivative.compute(t);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)derivative.getPosition(), (EuclidGeometry)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)derivative.getVelocity(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testSetQuadratic() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            Polynomial3DBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + 0.5;
            Point3D z0 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            Vector3D zd0 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            Point3D zf = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            if (maxNumberOfCoefficients < 3) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setQuadratic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf));
                continue;
            }
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            trajectory.setQuadratic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf);
            trajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)z0, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zd0, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            trajectory.compute(tf);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)zf, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            Polynomial3DBasics derivative = this.getPolynomial(2);
            derivative.setLinear(t0, tf, (Point3DReadOnly)new Point3D((Tuple3DReadOnly)zd0), (Point3DReadOnly)new Point3D((Tuple3DReadOnly)trajectory.getVelocity()));
            double dt = 1.0E-8;
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                derivative.compute(t);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)derivative.getPosition(), (EuclidGeometry)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)derivative.getVelocity(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
                trajectory.compute(t + dt);
                Point3D nextPosition = new Point3D((Tuple3DReadOnly)trajectory.getPosition());
                trajectory.compute(t - dt);
                Point3D lastPosition = new Point3D((Tuple3DReadOnly)trajectory.getPosition());
                Vector3D expectedVelocity = new Vector3D();
                expectedVelocity.sub((Tuple3DReadOnly)nextPosition, (Tuple3DReadOnly)lastPosition);
                expectedVelocity.scale(0.5 / dt);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)expectedVelocity, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-6);
            }
        }
    }

    @Test
    public void testSetCubic() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            Polynomial3DBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + 0.5;
            Point3D z0 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            Vector3D zd0 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            Point3D zf = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            Vector3D zdf = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            if (maxNumberOfCoefficients < 4) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setCubic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf, (Vector3DReadOnly)zdf));
                continue;
            }
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            trajectory.setCubic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf, (Vector3DReadOnly)zdf);
            trajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)z0, (Point3DReadOnly)trajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)zd0, (Vector3DReadOnly)trajectory.getVelocity(), (double)1.0E-12);
            Polynomial3DBasics derivative = this.getPolynomial(3);
            derivative.setQuadratic(t0, tf, (Point3DReadOnly)new Point3D((Tuple3DReadOnly)zd0), trajectory.getAcceleration(), (Point3DReadOnly)new Point3D((Tuple3DReadOnly)zdf));
            trajectory.compute(tf);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)zf, (EuclidGeometry)trajectory.getPosition(), (double)1.0E-12);
            double dt = 1.0E-8;
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                derivative.compute(t);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)derivative.getPosition(), (EuclidGeometry)trajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)derivative.getVelocity(), (Vector3DReadOnly)trajectory.getAcceleration(), (double)1.0E-12);
                trajectory.compute(t + dt);
                Point3D nextPosition = new Point3D((Tuple3DReadOnly)trajectory.getPosition());
                trajectory.compute(t - dt);
                Point3D lastPosition = new Point3D((Tuple3DReadOnly)trajectory.getPosition());
                Vector3D velocityExpected = new Vector3D();
                velocityExpected.sub((Tuple3DReadOnly)nextPosition, (Tuple3DReadOnly)lastPosition);
                velocityExpected.scale(0.5 / dt);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)velocityExpected, (Vector3DReadOnly)trajectory.getVelocity(), (double)5.0E-6);
            }
        }
    }

    @Test
    public void testTransformCubic() throws Exception {
        double t;
        double dt;
        Vector3D transformedzdf;
        Point3D transformedzf;
        Vector3D transformedzd0;
        Point3D transformedz0;
        RigidBodyTransform transform;
        Vector3D zdf;
        Point3D zf;
        Vector3D zd0;
        Point3D z0;
        double tf;
        double t0;
        Polynomial3DBasics trajectoryWithTransformedInputs;
        Polynomial3DBasics transformedTrajectory;
        int maxNumberOfCoefficients;
        int i;
        Random random = new Random(3453L);
        for (i = 0; i < 1000; ++i) {
            maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)4, (int)10);
            transformedTrajectory = this.getPolynomial(maxNumberOfCoefficients);
            trajectoryWithTransformedInputs = this.getPolynomial(maxNumberOfCoefficients);
            t0 = random.nextDouble();
            tf = t0 + 0.5;
            z0 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            zd0 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            zf = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            zdf = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            transformedTrajectory.setCubic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf, (Vector3DReadOnly)zdf);
            transformedTrajectory.applyTransform((Transform)transform);
            transformedz0 = new Point3D((Tuple3DReadOnly)z0);
            transformedzd0 = new Vector3D((Tuple3DReadOnly)zd0);
            transformedzf = new Point3D((Tuple3DReadOnly)zf);
            transformedzdf = new Vector3D((Tuple3DReadOnly)zdf);
            transformedz0.applyTransform((Transform)transform);
            transformedzd0.applyTransform((Transform)transform);
            transformedzf.applyTransform((Transform)transform);
            transformedzdf.applyTransform((Transform)transform);
            transformedTrajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)transformedz0, (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)transformedzd0, (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
            transformedTrajectory.compute(tf);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)transformedzf, (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)transformedzdf, (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
            trajectoryWithTransformedInputs.setCubic(t0, tf, (Point3DReadOnly)transformedz0, (Vector3DReadOnly)transformedzd0, (Point3DReadOnly)transformedzf, (Vector3DReadOnly)transformedzdf);
            dt = 0.001;
            for (t = t0; t <= tf; t += dt) {
                transformedTrajectory.compute(t);
                trajectoryWithTransformedInputs.compute(t);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)trajectoryWithTransformedInputs.getPosition(), (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)trajectoryWithTransformedInputs.getVelocity(), (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)trajectoryWithTransformedInputs.getAcceleration(), (Vector3DReadOnly)transformedTrajectory.getAcceleration(), (double)1.0E-12);
            }
        }
        for (i = 0; i < 1000; ++i) {
            maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)4, (int)10);
            transformedTrajectory = this.getPolynomial(maxNumberOfCoefficients);
            trajectoryWithTransformedInputs = this.getPolynomial(maxNumberOfCoefficients);
            t0 = random.nextDouble();
            tf = t0 + 0.5;
            z0 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            zd0 = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            zf = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)1.0);
            zdf = EuclidCoreRandomTools.nextVector3D((Random)random, (double)1.0);
            transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            transformedTrajectory.setCubic(t0, tf, (Point3DReadOnly)z0, (Vector3DReadOnly)zd0, (Point3DReadOnly)zf, (Vector3DReadOnly)zdf);
            transformedTrajectory.applyInverseTransform((Transform)transform);
            transformedz0 = new Point3D((Tuple3DReadOnly)z0);
            transformedzd0 = new Vector3D((Tuple3DReadOnly)zd0);
            transformedzf = new Point3D((Tuple3DReadOnly)zf);
            transformedzdf = new Vector3D((Tuple3DReadOnly)zdf);
            transformedz0.applyInverseTransform((Transform)transform);
            transformedzd0.applyInverseTransform((Transform)transform);
            transformedzf.applyInverseTransform((Transform)transform);
            transformedzdf.applyInverseTransform((Transform)transform);
            transformedTrajectory.compute(t0);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)transformedz0, (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)transformedzd0, (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
            transformedTrajectory.compute(tf);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)transformedzf, (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)transformedzdf, (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
            trajectoryWithTransformedInputs.setCubic(t0, tf, (Point3DReadOnly)transformedz0, (Vector3DReadOnly)transformedzd0, (Point3DReadOnly)transformedzf, (Vector3DReadOnly)transformedzdf);
            dt = 0.001;
            for (t = t0; t <= tf; t += dt) {
                transformedTrajectory.compute(t);
                trajectoryWithTransformedInputs.compute(t);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)trajectoryWithTransformedInputs.getPosition(), (Point3DReadOnly)transformedTrajectory.getPosition(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)trajectoryWithTransformedInputs.getVelocity(), (Vector3DReadOnly)transformedTrajectory.getVelocity(), (double)1.0E-12);
                EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)trajectoryWithTransformedInputs.getAcceleration(), (Vector3DReadOnly)transformedTrajectory.getAcceleration(), (double)1.0E-12);
            }
        }
    }

    private static /* synthetic */ void lambda$testSetLinear$1(Polynomial3DBasics trajectory, double t0, double tf, Point3DReadOnly z0, Point3DReadOnly zf) throws Throwable {
        trajectory.setLinear(t0, tf, z0, zf);
    }

    private static /* synthetic */ void lambda$testSetConstant$0(Polynomial3DBasics trajectory, double t0, double tf, Point3DReadOnly z) throws Throwable {
        trajectory.setConstant(t0, tf, (Tuple3DReadOnly)z);
    }
}

