/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.ConstantVelocityTrajectoryGenerator;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ConstantVelocityTrajectoryGeneratorTest {
    private final double epsilon = 1.0E-7;
    private ConstantVelocityTrajectoryGenerator constantVelocityTrajectoryGenerator;

    @Test
    public void testSimpleTrajectory() {
        DoubleProvider initialPosition = () -> 0.0;
        DoubleProvider velocity = () -> 1.0;
        DoubleProvider trajectoryTimeProvider = () -> 5.0;
        ConstantVelocityTrajectoryGenerator simpleLinearTrajectory = new ConstantVelocityTrajectoryGenerator("", initialPosition, velocity, trajectoryTimeProvider, new YoRegistry("Dummy"));
        simpleLinearTrajectory.initialize();
        simpleLinearTrajectory.compute(2.5);
        Assert.assertEquals(2.5, simpleLinearTrajectory.getValue(), 1.0E-7);
        Assert.assertEquals(1.0, simpleLinearTrajectory.getVelocity(), 1.0E-7);
        Assert.assertEquals(0.0, simpleLinearTrajectory.getAcceleration(), 1.0E-7);
    }

    @Test
    public void testRandomTrajectories() {
        double numberOfIterations = 100.0;
        double minimumTrajectoryTime = 0.001;
        Random random = new Random(499300L);
        int i = 0;
        while ((double)i < 100.0) {
            double position = 2.0 * random.nextDouble() - 1.0;
            double velocity = 2.0 * random.nextDouble() - 1.0;
            double trajectoryTime = random.nextDouble() + 0.001;
            DoubleProvider positionProvider = () -> position;
            DoubleProvider velocityProvider = () -> velocity;
            DoubleProvider trajectoryTimeProvider = () -> trajectoryTime;
            this.constantVelocityTrajectoryGenerator = new ConstantVelocityTrajectoryGenerator("", positionProvider, velocityProvider, trajectoryTimeProvider, new YoRegistry("Dummy"));
            this.constantVelocityTrajectoryGenerator.initialize();
            this.constantVelocityTrajectoryGenerator.compute(0.0);
            Assert.assertEquals(positionProvider.getValue(), this.constantVelocityTrajectoryGenerator.getValue(), 1.0E-7);
            double randomTimeDuringTrajectory = trajectoryTimeProvider.getValue() * random.nextDouble();
            double expectedPosition = positionProvider.getValue() + velocityProvider.getValue() * randomTimeDuringTrajectory;
            this.checkTrajectoryPositionVelocityAndAcceleration(randomTimeDuringTrajectory, expectedPosition, velocityProvider.getValue());
            Assert.assertFalse(this.constantVelocityTrajectoryGenerator.isDone());
            double randomTimeBeforeTrajectory = -random.nextDouble();
            this.constantVelocityTrajectoryGenerator.compute(randomTimeBeforeTrajectory);
            Assert.assertFalse(this.constantVelocityTrajectoryGenerator.isDone());
            double randomTimeAfterTrajectory = trajectoryTimeProvider.getValue() + random.nextDouble() + 1.0E-7;
            this.constantVelocityTrajectoryGenerator.compute(randomTimeAfterTrajectory);
            Assert.assertTrue(this.constantVelocityTrajectoryGenerator.isDone());
            ++i;
        }
    }

    private void checkTrajectoryPositionVelocityAndAcceleration(double time, double expectedPosition, double expectedVelocity) {
        this.constantVelocityTrajectoryGenerator.compute(time);
        Assert.assertEquals("Position is wrong ", this.constantVelocityTrajectoryGenerator.getValue(), expectedPosition, 1.0E-7);
        Assert.assertEquals("Velocity is wrong ", this.constantVelocityTrajectoryGenerator.getVelocity(), expectedVelocity, 1.0E-7);
        Assert.assertEquals("Acceleration is wrong ", this.constantVelocityTrajectoryGenerator.getAcceleration(), 0.0, 1.0E-7);
    }
}

