/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.interpolators;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.interpolators.OrientationInterpolationCalculator;

public class OrientationInterpolationCalculatorTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testComputeAngularVelocity() {
        Random random = new Random(101L);
        ReferenceFrame world = ReferenceFrame.getWorldFrame();
        for (int i = 0; i < 50000; ++i) {
            FrameQuaternion startOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)world);
            FrameQuaternion endOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)world);
            double alpha = random.nextDouble();
            double alphaDot = random.nextDouble();
            double dt = 1.0E-6;
            double deltaAlpha = alphaDot * dt;
            double alphaNew = alpha + deltaAlpha;
            FrameQuaternion interpolatedOrientation0 = new FrameQuaternion(startOrientation.getReferenceFrame());
            interpolatedOrientation0.interpolate((FrameQuaternionReadOnly)startOrientation, (FrameQuaternionReadOnly)endOrientation, alpha);
            FrameQuaternion interpolatedOrientationDt = new FrameQuaternion(startOrientation.getReferenceFrame());
            interpolatedOrientationDt.interpolate((FrameQuaternionReadOnly)startOrientation, (FrameQuaternionReadOnly)endOrientation, alphaNew);
            Matrix3D interpolatedOrientationMatrixDot = new Matrix3D();
            RigidBodyTransform transformationAtDt = new RigidBodyTransform();
            transformationAtDt.getRotation().set((Orientation3DReadOnly)interpolatedOrientationDt);
            interpolatedOrientationMatrixDot.set((RotationMatrixReadOnly)transformationAtDt.getRotation());
            RotationMatrix interpolatedOrientation0Matrix = new RotationMatrix();
            RigidBodyTransform transformationAt0 = new RigidBodyTransform();
            transformationAt0.getRotation().set((Orientation3DReadOnly)interpolatedOrientation0);
            interpolatedOrientation0Matrix.set((RotationMatrixReadOnly)transformationAt0.getRotation());
            interpolatedOrientationMatrixDot.sub((Matrix3DReadOnly)interpolatedOrientation0Matrix);
            interpolatedOrientationMatrixDot.scale(1.0 / dt);
            RotationMatrix orientationTranspose = new RotationMatrix((RotationMatrixReadOnly)interpolatedOrientation0Matrix);
            orientationTranspose.transpose();
            Matrix3D omegaTilde = new Matrix3D((Matrix3DReadOnly)interpolatedOrientationMatrixDot);
            omegaTilde.multiply((Matrix3DReadOnly)orientationTranspose);
            Assert.assertTrue(omegaTilde.isMatrixSkewSymmetric(0.001));
            Vector3D angularVelocity = new Vector3D(-omegaTilde.getM12(), omegaTilde.getM02(), -omegaTilde.getM01());
            OrientationInterpolationCalculator orientationInterpolationCalculator = new OrientationInterpolationCalculator();
            FrameVector3D angularVelocityFromCalculator = new FrameVector3D();
            orientationInterpolationCalculator.computeAngularVelocity((FrameVector3DBasics)angularVelocityFromCalculator, (FrameQuaternionBasics)startOrientation, (FrameQuaternionBasics)endOrientation, alphaDot);
            double epsilon = 1.0E-5;
            Assert.assertEquals(angularVelocity.getX(), angularVelocityFromCalculator.getX(), epsilon);
            Assert.assertEquals(angularVelocity.getY(), angularVelocityFromCalculator.getY(), epsilon);
            Assert.assertEquals(angularVelocity.getZ(), angularVelocityFromCalculator.getZ(), epsilon);
        }
    }
}

