/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.frames;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.frames.YoMatrix;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMatrixTest {
    @Test
    public void testSimpleYoMatrixExample() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix("testMatrix", maxNumberOfRows, maxNumberOfColumns, registry);
        Assert.assertEquals(maxNumberOfRows, yoMatrix.getNumberOfRows());
        Assert.assertEquals(maxNumberOfColumns, yoMatrix.getNumberOfColumns());
        DMatrixRMaj denseMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.get(denseMatrix);
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)denseMatrix, (double)1.0E-10);
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomGeometry.nextDenseMatrix64F((Random)random, (int)maxNumberOfRows, (int)maxNumberOfColumns);
        yoMatrix.set(randomMatrix);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.get(checkMatrix);
        MatrixTestTools.assertMatrixEquals((DMatrix)randomMatrix, (DMatrix)checkMatrix, (double)1.0E-10);
        Assert.assertEquals(registry.findVariable("testMatrix_0_0").getValueAsDouble(), checkMatrix.get(0, 0), 1.0E-10);
    }

    @Test
    public void testYoMatrixDimensioning() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrix";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        int smallerRows = maxNumberOfRows - 2;
        int smallerColumns = maxNumberOfColumns - 3;
        DMatrixRMaj denseMatrix = new DMatrixRMaj(smallerRows, smallerColumns);
        try {
            yoMatrix.get(denseMatrix);
            Assert.fail("Should throw an exception if the size isn't right!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        yoMatrix.getAndReshape(denseMatrix);
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)denseMatrix, (double)1.0E-10);
        Assert.assertEquals(maxNumberOfRows, denseMatrix.getNumRows());
        Assert.assertEquals(maxNumberOfColumns, denseMatrix.getNumCols());
        Assert.assertEquals(maxNumberOfRows, yoMatrix.getNumberOfRows());
        Assert.assertEquals(maxNumberOfColumns, yoMatrix.getNumberOfColumns());
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomGeometry.nextDenseMatrix64F((Random)random, (int)maxNumberOfRows, (int)maxNumberOfColumns);
        yoMatrix.set(randomMatrix);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.get(checkMatrix);
        MatrixTestTools.assertMatrixEquals((DMatrix)randomMatrix, (DMatrix)checkMatrix, (double)1.0E-10);
        DMatrixRMaj smallerMatrix = RandomGeometry.nextDenseMatrix64F((Random)random, (int)smallerRows, (int)smallerColumns);
        yoMatrix.set(smallerMatrix);
        Assert.assertEquals(smallerRows, smallerMatrix.getNumRows());
        Assert.assertEquals(smallerColumns, smallerMatrix.getNumCols());
        Assert.assertEquals(smallerRows, yoMatrix.getNumberOfRows());
        Assert.assertEquals(smallerColumns, yoMatrix.getNumberOfColumns());
        DMatrixRMaj checkMatrix2 = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix2);
        MatrixTestTools.assertMatrixEquals((DMatrix)smallerMatrix, (DMatrix)checkMatrix2, (double)1.0E-10);
        this.checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, checkMatrix2, registry);
    }

    @Test
    public void testYoMatrixSetToZero() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrixForZero";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomGeometry.nextDenseMatrix64F((Random)random, (int)maxNumberOfRows, (int)maxNumberOfColumns);
        yoMatrix.set(randomMatrix);
        int numberOfRows = 2;
        int numberOfColumns = 6;
        yoMatrix.setToZero(numberOfRows, numberOfColumns);
        DMatrixRMaj zeroMatrix = new DMatrixRMaj(numberOfRows, numberOfColumns);
        this.checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, zeroMatrix, registry);
    }

    @Test
    public void testYoMatrixSetTooBig() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrix";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        DMatrixRMaj tooBigMatrix = new DMatrixRMaj(maxNumberOfRows + 1, maxNumberOfColumns);
        try {
            yoMatrix.set(tooBigMatrix);
            Assert.fail("Too Big");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        tooBigMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns + 1);
        try {
            yoMatrix.set(tooBigMatrix);
            Assert.fail("Too Big");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DMatrixRMaj okMatrix = new DMatrixRMaj(0, maxNumberOfColumns + 10);
        yoMatrix.set(okMatrix);
        this.assertMatrixYoVariablesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, registry);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix);
        Assert.assertEquals(0L, checkMatrix.getNumRows());
        Assert.assertEquals(maxNumberOfColumns + 10, checkMatrix.getNumCols());
        okMatrix = new DMatrixRMaj(maxNumberOfRows + 10, 0);
        yoMatrix.set(okMatrix);
        this.assertMatrixYoVariablesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, registry);
        checkMatrix = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix);
        Assert.assertEquals(maxNumberOfRows + 10, checkMatrix.getNumRows());
        Assert.assertEquals(0L, checkMatrix.getNumCols());
    }

    private void checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(String name, int maxNumberOfRows, int maxNumberOfColumns, DMatrixRMaj checkMatrix, YoRegistry registry) {
        int smallerRows = checkMatrix.getNumRows();
        int smallerColumns = checkMatrix.getNumCols();
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                YoDouble variable = (YoDouble)registry.findVariable(name + "_" + row + "_" + column);
                if (row < smallerRows && column < smallerColumns) {
                    Assert.assertEquals(checkMatrix.get(row, column), variable.getDoubleValue(), 1.0E-10);
                    continue;
                }
                Assert.assertTrue(Double.isNaN(variable.getDoubleValue()));
            }
        }
    }

    private void assertMatrixYoVariablesAreNaN(String name, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                YoDouble variable = (YoDouble)registry.findVariable(name + "_" + row + "_" + column);
                Assert.assertTrue(Double.isNaN(variable.getDoubleValue()));
            }
        }
    }
}

