/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FilteredVelocityYoVariableTest {
    private static final double DT = 0.1;

    @Test
    public void testUpdateForTranslationalVelocity() {
        YoRegistry registry = new YoRegistry("testRegistry");
        double alpha = 0.3;
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        FilteredVelocityYoVariable filteredVelocityYoVariable = new FilteredVelocityYoVariable("filteredVelocityYoVariable", "test description", alpha, positionVariable, 0.1, registry);
        filteredVelocityYoVariable.set(0.0);
        positionVariable.set(0.0);
        for (int i = 0; i < 10000; ++i) {
            positionVariable.add(10.0);
            filteredVelocityYoVariable.update();
        }
        Assert.assertEquals(100.0, filteredVelocityYoVariable.getDoubleValue(), 1.0E-7);
    }

    @Test
    public void testUpdateForRotationalVelocity() {
        YoRegistry registry = new YoRegistry("testRegistry");
        double alpha = 0.005;
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        FilteredVelocityYoVariable filteredVelocityYoVariable = new FilteredVelocityYoVariable("filteredVelocityYoVariable", "test description", alpha, positionVariable, 0.1, registry);
        filteredVelocityYoVariable.set(0.0);
        positionVariable.set(-Math.PI);
        for (int i = 0; i < 10000; ++i) {
            if (positionVariable.getValueAsDouble() + 0.5 > Math.PI) {
                positionVariable.set(-Math.PI + (Math.PI - positionVariable.getValueAsDouble()));
            } else {
                positionVariable.add(0.5);
            }
            filteredVelocityYoVariable.updateForAngles();
        }
        Assert.assertEquals(5.0, filteredVelocityYoVariable.getDoubleValue(), 1.0E-5);
    }
}

