/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.DelayedYoDouble;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class DelayedYoDoubleTest {
    @Test
    public void testDelayedYoVariableMultipleTickDelays() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        for (int ticksToDelay = 0; ticksToDelay < 10; ++ticksToDelay) {
            int i;
            double firstValue = Math.random();
            variableToDelay.set(firstValue);
            DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", variableToDelay, ticksToDelay, registry);
            int ticksToTest = 100;
            double[] valuesToSet = new double[ticksToTest];
            for (i = 0; i < valuesToSet.length; ++i) {
                valuesToSet[i] = Math.random();
            }
            Assert.assertEquals(delayedYoVariable.getDoubleValue(), firstValue, 1.0E-7);
            for (i = 0; i < ticksToTest; ++i) {
                variableToDelay.set(valuesToSet[i]);
                delayedYoVariable.update();
                if (i < ticksToDelay) {
                    Assert.assertEquals(delayedYoVariable.getDoubleValue(), firstValue, 1.0E-7);
                    continue;
                }
                Assert.assertEquals(delayedYoVariable.getDoubleValue(), valuesToSet[i - ticksToDelay], 1.0E-7);
            }
        }
    }

    @Test
    public void testDelayedYoVariableOneTickDelay() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        int ticksToDelay = 1;
        variableToDelay.set(0.0);
        DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", variableToDelay, ticksToDelay, registry);
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 0.0, 1.0E-7);
        variableToDelay.set(1.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 0.0, 1.0E-7);
        variableToDelay.set(2.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 1.0, 1.0E-7);
        variableToDelay.set(3.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 2.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
    }

    @Test
    public void testDelayedYoVariableZeroTickDelay() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble variableToDelay = new YoDouble("variableToDelay", registry);
        int ticksToDelay = 0;
        variableToDelay.set(0.0);
        DelayedYoDouble delayedYoVariable = new DelayedYoDouble("delayedVariable" + ticksToDelay, "", variableToDelay, ticksToDelay, registry);
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 0.0, 1.0E-7);
        variableToDelay.set(1.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 1.0, 1.0E-7);
        variableToDelay.set(2.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 2.0, 1.0E-7);
        variableToDelay.set(3.0);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getDoubleValue(), 3.0, 1.0E-7);
    }
}

