/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.DelayedYoBoolean;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class DelayedYoBooleanTest {
    private static YoRegistry registry;
    private static YoBoolean variableToDelay;
    private static Boolean DEBUG;
    private int ticksToDelay;

    @BeforeEach
    public void setUp() {
        registry = new YoRegistry("registry");
        variableToDelay = new YoBoolean("variableToDelay", registry);
    }

    @AfterEach
    public void tearDown() {
        registry = null;
        variableToDelay = null;
    }

    @Test
    public void testDelayedYoVariableMultipleTickDelays() {
        this.ticksToDelay = 0;
        while (this.ticksToDelay < 10) {
            int i;
            variableToDelay.set(true);
            DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
            int ticksToTest = 100;
            boolean[] valuesToSet = new boolean[ticksToTest];
            for (i = 0; i < valuesToSet.length; ++i) {
                valuesToSet[i] = Math.random() < 0.5;
            }
            Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
            for (i = 0; i < ticksToTest; ++i) {
                variableToDelay.set(valuesToSet[i]);
                delayedYoVariable.update();
                if (i < this.ticksToDelay) {
                    Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
                    continue;
                }
                Assert.assertEquals(delayedYoVariable.getBooleanValue(), valuesToSet[i - this.ticksToDelay]);
            }
            ++this.ticksToDelay;
        }
    }

    @Test
    public void testDelayedYoVariableOneTickDelay() {
        this.ticksToDelay = 1;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
        variableToDelay.set(false);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
    }

    @Test
    public void testDelayedYoVariableZeroTickDelay() {
        this.ticksToDelay = 0;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        variableToDelay.set(false);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
        variableToDelay.set(true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
    }

    @Test
    public void testUpdateWithZero() {
        this.ticksToDelay = 0;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
        variableToDelay.set(true);
        delayedYoVariable.update();
        delayedYoVariable.getInternalState("Should be all true", DEBUG);
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        delayedYoVariable.update();
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
    }

    @Test
    public void testReset() {
        int i;
        this.ticksToDelay = 10;
        variableToDelay.set(false);
        DelayedYoBoolean delayedYoVariable = new DelayedYoBoolean("delayedVariable" + this.ticksToDelay, "", variableToDelay, this.ticksToDelay, registry);
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
            delayedYoVariable.update();
        }
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
        variableToDelay.set(true);
        delayedYoVariable.update();
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
            delayedYoVariable.update();
        }
        Assert.assertEquals(delayedYoVariable.getBooleanValue(), true);
        variableToDelay.set(false);
        delayedYoVariable.update();
        delayedYoVariable.getInternalState("Should be all true, except for the end", DEBUG);
        delayedYoVariable.reset();
        delayedYoVariable.update();
        for (i = 0; i < this.ticksToDelay; ++i) {
            Assert.assertEquals(delayedYoVariable.getBooleanValue(), false);
            delayedYoVariable.update();
        }
        delayedYoVariable.getInternalState("Should be all false", DEBUG);
    }

    static {
        DEBUG = false;
    }
}

