/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.BacklashProcessingYoVariable;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.robotics.math.filters.RevisedBacklashCompensatingVelocityYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BacklashProcessingYoVariableTest {
    @Test
    public void testAgainstRevisedBacklash() {
        YoRegistry registry = new YoRegistry("dummy");
        YoDouble slopTime = new YoDouble("slopTime", registry);
        double dt = 0.002;
        YoDouble alpha = new YoDouble("alpha", registry);
        alpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)16.0, (double)dt));
        YoDouble positionVariable = new YoDouble("rawPosition", registry);
        FilteredVelocityYoVariable velocityVariable = new FilteredVelocityYoVariable("fd", "", (DoubleProvider)alpha, positionVariable, dt, registry);
        BacklashProcessingYoVariable blToTest = new BacklashProcessingYoVariable("blTest", "", (YoDouble)velocityVariable, dt, (DoubleProvider)slopTime, registry);
        RevisedBacklashCompensatingVelocityYoVariable blExpected = new RevisedBacklashCompensatingVelocityYoVariable("blExpected", "", (DoubleProvider)alpha, positionVariable, dt, (DoubleProvider)slopTime, registry);
        Random random = new Random(561651L);
        for (double t = 0.0; t < 100.0; t += dt) {
            positionVariable.set(2.0 * Math.sin(62.83185307179586) + RandomNumbers.nextDouble((Random)random, (double)1.0) * Math.sin(190.58995431778078));
            velocityVariable.update();
            blToTest.update();
            blExpected.update();
            Assert.assertEquals(blToTest.getDoubleValue(), blExpected.getDoubleValue(), 1.0E-10);
        }
    }
}

