/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.AlphaFilteredWrappingYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AlphaFilteredWrappingYoVariableTest {
    private static final boolean DEBUG = false;
    private final Random random = new Random();

    @Test
    public void testInputModulo() {
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble alpha = new YoDouble("alpha", registry);
        alpha.set(0.0);
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        AlphaFilteredWrappingYoVariable alphaFilteredWrappingYoVariable = new AlphaFilteredWrappingYoVariable("alphaFilteredWrappingYoVariable", "", registry, positionVariable, (DoubleProvider)alpha, -2.0, 8.0);
        positionVariable.set(8.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)-2.0, (double)1.0E-10));
        positionVariable.set(-2.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)-2.0, (double)1.0E-10));
        positionVariable.set(33.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)3.0, (double)1.0E-10));
        positionVariable.set(38.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)-2.0, (double)1.0E-10));
        positionVariable.set(42.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)2.0, (double)1.0E-10));
        positionVariable.set(-22.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)-2.0, (double)1.0E-10));
        positionVariable.set(-23.5);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)6.5, (double)1.0E-10));
        positionVariable.set(-42.0);
        alphaFilteredWrappingYoVariable.update();
        Assert.assertTrue(MathTools.epsilonEquals((double)alphaFilteredWrappingYoVariable.getDoubleValue(), (double)-2.0, (double)1.0E-10));
    }

    @Test
    public void testNoisyFixedPosition() {
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble alpha = new YoDouble("alpha", registry);
        alpha.set(0.8);
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        AlphaFilteredWrappingYoVariable alphaFilteredWrappingYoVariable = new AlphaFilteredWrappingYoVariable("alphaFilteredWrappingYoVariable", "", registry, positionVariable, (DoubleProvider)alpha, 0.0, 20.0);
        double pseudoNoise = 0.0;
        positionVariable.set(10.0);
        for (int i = 0; i < 10000; ++i) {
            if (i % 2 == 0) {
                pseudoNoise = this.random.nextDouble();
            }
            positionVariable.add(Math.pow(-1.0, i) * pseudoNoise);
            alphaFilteredWrappingYoVariable.update();
        }
        Assert.assertEquals(10.0, alphaFilteredWrappingYoVariable.getDoubleValue(), 1.0);
    }

    @Test
    public void testErrorAlwaysDecreases() {
        YoRegistry registry = new YoRegistry("testRegistry");
        YoDouble alpha = new YoDouble("alpha", registry);
        alpha.set(0.999999);
        YoDouble positionVariable = new YoDouble("positionVariable", registry);
        double lowerLimit = RandomNumbers.nextDouble((Random)this.random, (double)-100.0, (double)100.0);
        double upperLimit = RandomNumbers.nextDouble((Random)this.random, (double)-100.0, (double)100.0);
        if (upperLimit < lowerLimit) {
            double temp = lowerLimit;
            lowerLimit = upperLimit;
            upperLimit = temp;
        }
        AlphaFilteredWrappingYoVariable alphaFilteredWrappingYoVariable = new AlphaFilteredWrappingYoVariable("alphaFilteredWrappingYoVariable", "", registry, positionVariable, (DoubleProvider)alpha, lowerLimit, upperLimit);
        positionVariable.set(RandomNumbers.nextDouble((Random)this.random, (double)lowerLimit, (double)upperLimit));
        alphaFilteredWrappingYoVariable.update();
        for (int iteration = 0; iteration < 10000; ++iteration) {
            positionVariable.set(RandomNumbers.nextDouble((Random)this.random, (double)lowerLimit, (double)upperLimit));
            double lastError = this.getErrorConsideringWrap(alphaFilteredWrappingYoVariable.getDoubleValue(), positionVariable.getDoubleValue(), lowerLimit, upperLimit);
            for (int convergeAlphaCount = 0; convergeAlphaCount < 100; ++convergeAlphaCount) {
                alphaFilteredWrappingYoVariable.update();
                double currentError = this.getErrorConsideringWrap(alphaFilteredWrappingYoVariable.getDoubleValue(), positionVariable.getDoubleValue(), lowerLimit, upperLimit);
                Assert.assertTrue(Math.abs(currentError) < Math.abs(lastError));
            }
        }
    }

    public double getErrorConsideringWrap(double current, double target, double lowerLimit, double upperLimit) {
        double range = upperLimit - lowerLimit;
        if (target > upperLimit) {
            target = (target - lowerLimit) % range + lowerLimit;
        }
        if (target < lowerLimit) {
            double offset = (target - upperLimit) % range;
            target = offset + upperLimit;
        }
        double standardError = target - current;
        double wrappingError = 0.0;
        wrappingError = target > current ? lowerLimit - current + target - upperLimit : upperLimit - current + target - lowerLimit;
        if (Math.abs(standardError) < Math.abs(wrappingError)) {
            return standardError;
        }
        return wrappingError;
    }

    @Test
    public void testWrappingError() {
        double e = this.getErrorConsideringWrap(0.2, 0.8, 0.0, 1.0);
        Assert.assertEquals(-0.4, e, 0.001);
        e = this.getErrorConsideringWrap(0.8, 0.2, 0.0, 1.0);
        Assert.assertEquals(0.4, e, 0.001);
        e = this.getErrorConsideringWrap(0.0, 0.4, 0.0, 1.0);
        Assert.assertEquals(0.4, e, 0.001);
        e = this.getErrorConsideringWrap(-0.2, 0.4, -1.0, 1.0);
        Assert.assertEquals(0.6, e, 0.001);
        e = this.getErrorConsideringWrap(-1.0, 1.0, -1.0, 1.0);
        Assert.assertEquals(0.0, e, 0.001);
        e = this.getErrorConsideringWrap(1.0, -1.0, -1.0, 1.0);
        Assert.assertEquals(0.0, e, 0.001);
        e = this.getErrorConsideringWrap(0.4, 1.6, -1.0, 1.0);
        Assert.assertEquals(-0.8, e, 0.001);
        e = this.getErrorConsideringWrap(-0.4, -1.6, -1.0, 1.0);
        Assert.assertEquals(0.8, e, 0.001);
        e = this.getErrorConsideringWrap(0.4, -1.6, -1.0, 1.0);
        Assert.assertEquals(0.0, e, 0.001);
        e = this.getErrorConsideringWrap(0.2, 0.2, -1.0, 1.0);
        Assert.assertEquals(0.0, e, 0.001);
        e = this.getErrorConsideringWrap(-3.2, -4.0, -5.0, -1.0);
        Assert.assertEquals(-0.8, e, 0.001);
        e = this.getErrorConsideringWrap(0.0, 0.0, -1.0, 1.0);
    }

    @Test
    public void testAlphaAndBreakFrequencyComputations() {
        double DT = 0.1;
        double randomAlpha = this.random.nextDouble();
        double computedBreakFrequency = AlphaFilteredWrappingYoVariable.computeBreakFrequencyGivenAlpha((double)randomAlpha, (double)DT);
        double computedAlpha = AlphaFilteredWrappingYoVariable.computeAlphaGivenBreakFrequencyProperly((double)computedBreakFrequency, (double)DT);
        Assert.assertEquals(randomAlpha, computedAlpha, 1.0E-7);
        Assert.assertEquals(computedBreakFrequency, AlphaFilteredWrappingYoVariable.computeBreakFrequencyGivenAlpha((double)computedAlpha, (double)DT), 1.0E-7);
    }
}

